/*
 * Decompiled with CFR 0.152.
 */
package pedersen.opponent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pedersen.debug.DebuggableBase;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBase;
import pedersen.opponent.TargetStandardImpl;
import pedersen.opponent.profile.TargetMovementChallengeImpl;
import pedersen.opponent.profile.TargetMovementFullThrottleImpl;
import pedersen.opponent.profile.TargetMovementGridImpl2;
import pedersen.opponent.profile.TargetMovementRambotDefenseImpl;
import pedersen.opponent.profile.TargetMovementRambotOffenseImpl;
import pedersen.opponent.profile.TargetMovementTangoImpl;
import pedersen.opponent.profile.TargetMovementWaypointImpl;
import pedersen.opponent.profile.TargetTargetingChallengeImpl;

public class TargetFactory
extends DebuggableBase {
    private static int targetCount = 0;
    public static final TargetFactory singleton = new TargetFactory();
    private final List<String> ramOffenseTargets = new ArrayList<String>();
    private final List<String> ramDefenseTargets = new ArrayList<String>();
    private final List<String> waypointTargets = new ArrayList<String>();
    private final List<String> tangoTargets = new ArrayList<String>();
    private final List<String> fullThrottleTargets = new ArrayList<String>();
    private final List<String> gridTargets = new ArrayList<String>();
    private final List<String> targetingChallengeTargets = new ArrayList<String>();
    private final List<String> movementChallengeTargets = new ArrayList<String>();

    private TargetFactory() {
        this.targetingChallengeTargets.add("abc.Shadow 3.66dTC");
        this.targetingChallengeTargets.add("cjm.Chalk 1.2TC");
        this.targetingChallengeTargets.add("cx.mini.Cigaret 1.31TC");
        this.targetingChallengeTargets.add("davidalves.micro.DuelistMicro 2.0TC");
        this.targetingChallengeTargets.add("davidalves.net.DuelistMicro 1.22TC");
        this.targetingChallengeTargets.add("davidalves.Phoenix 0.855TC");
        this.targetingChallengeTargets.add("dft.Cyanide 1.80.bTC");
        this.targetingChallengeTargets.add("gh.GrubbmGrb 1.1.3TC");
        this.targetingChallengeTargets.add("gh.GrubbmGrb 1.2.4TC");
        this.targetingChallengeTargets.add("jam.micro.RaikoMicro 1.44TC");
        this.targetingChallengeTargets.add("jam.RaikoMX 0.32TC");
        this.targetingChallengeTargets.add("kawigi.sbf.FloodMini 1.4TC");
        this.targetingChallengeTargets.add("kc.Fortune 1.0");
        this.targetingChallengeTargets.add("kc.serpent.WaveSerpent 1.221TC");
        this.targetingChallengeTargets.add("pedersen.Butterfly 2.0");
        this.targetingChallengeTargets.add("pez.rumble.CassiusClay 1.9996bdTC");
        this.targetingChallengeTargets.add("pez.rumble.CassiusClay 2pi.08TC");
        this.targetingChallengeTargets.add("simonton.micro.WeeklongObsession 1.5TC");
        this.targetingChallengeTargets.add("simonton.mini.WeeksOnEnd 1.10TC");
        this.targetingChallengeTargets.add("stefw.Tigger 0.0.23TC");
        this.targetingChallengeTargets.add("wiki.etc.RandomMovementBot 1.0");
        this.movementChallengeTargets.add("abc.tron3.Shadow 3.66MC");
        this.movementChallengeTargets.add("cjm.Che 1.2MC");
        this.movementChallengeTargets.add("kawigi.sbf.FloodHT 0.9.2MC");
        this.movementChallengeTargets.add("pez.rumble.CassiusClay 1.9996bdMC");
        this.movementChallengeTargets.add("wiki.challenge.WaveSurfingChallengeBotA 1.0");
        this.movementChallengeTargets.add("wiki.challenge.WaveSurfingChallengeBotB 1.1");
        this.movementChallengeTargets.add("wiki.challenge.WaveSurfingChallengeBotC 1.0");
        this.ramDefenseTargets.add("bayen.UbaRamLT");
        this.ramDefenseTargets.add("bbo.RamboT");
        this.ramDefenseTargets.add("benhorner.PureAggression");
        this.ramDefenseTargets.add("bvh.mini.Mjolnir");
        this.ramDefenseTargets.add("demetrix.nano.SledgeHammer");
        this.ramDefenseTargets.add("gh.micro.GrubbmThree");
        this.ramDefenseTargets.add("jab.micro.Sanguijuela");
        this.ramDefenseTargets.add("jgap.JGAP130166");
        this.ramDefenseTargets.add("kc.micro.rammer.MaxRisk");
        this.ramDefenseTargets.add("mld.Tide");
        this.ramDefenseTargets.add("mz.NanoDeath");
        this.ramDefenseTargets.add("pedersen.Banzai");
        this.ramDefenseTargets.add("radnor.RamRod");
        this.ramDefenseTargets.add("rcp.Kuramatron");
        this.ramDefenseTargets.add("stelo.Lifestealer");
        this.ramDefenseTargets.add("step.nanoPri");
        this.ramDefenseTargets.add("wiki.micro.ARAMtocles");
        this.ramOffenseTargets.add("abc.Shadow");
        this.ramOffenseTargets.add("ahf.r2d2.R2d2");
        this.ramOffenseTargets.add("ags.polished.PolishedRuby");
        this.ramOffenseTargets.add("ar.horizon.Horizon");
        this.ramOffenseTargets.add("ary.Help");
        this.ramOffenseTargets.add("ary.nano.AceSurf");
        this.ramOffenseTargets.add("ary.SMG");
        this.ramOffenseTargets.add("axeBots.Musashi");
        this.ramOffenseTargets.add("axeBots.Okami");
        this.ramOffenseTargets.add("axeBots.SilverSurfer");
        this.ramOffenseTargets.add("bing2.Melody");
        this.ramOffenseTargets.add("chase.na.Seraphim");
        this.ramOffenseTargets.add("davidalves.Phoenix");
        this.ramOffenseTargets.add("deo.CloudBot");
        this.ramOffenseTargets.add("dft.Freddie");
        this.ramOffenseTargets.add("dsx724.VSAB");
        this.ramOffenseTargets.add("dz.GalbaMini");
        this.ramOffenseTargets.add("ebo.Tahoe");
        this.ramOffenseTargets.add("florent.FloatingTadpole");
        this.ramOffenseTargets.add("florent.test.Toad");
        this.ramOffenseTargets.add("florent.XSeries.X2");
        this.ramOffenseTargets.add("gh.GresSuffurd");
        this.ramOffenseTargets.add("jam.micro.RaikoMicro");
        this.ramOffenseTargets.add("jam.mini.Raiko");
        this.ramOffenseTargets.add("jk.mini.Cunobelin");
        this.ramOffenseTargets.add("kawam.kmBot9");
        this.ramOffenseTargets.add("kawigi.sbf.FloodHT");
        this.ramOffenseTargets.add("kc.micro.WaveShark");
        this.ramOffenseTargets.add("kc.serpent.Hydra");
        this.ramOffenseTargets.add("kc.serpent.WaveSerpent");
        this.ramOffenseTargets.add("kid.Toa");
        this.ramOffenseTargets.add("Krabb.krabby2.Krabby2");
        this.ramOffenseTargets.add("mladjo.iRobot");
        this.ramOffenseTargets.add("mladjo.Grrrrr");
        this.ramOffenseTargets.add("mue.Ascendant");
        this.ramOffenseTargets.add("mz.AdeptBSB 1.03");
        this.ramOffenseTargets.add("nat.Blackhole");
        this.ramOffenseTargets.add("nz.jdc.nano.NeophytePattern");
        this.ramOffenseTargets.add("paulk.PaulV3 1.7");
        this.ramOffenseTargets.add("pez.mini.Pugilist");
        this.ramOffenseTargets.add("pez.rumble.Ali");
        this.ramOffenseTargets.add("ph.micro.Pikeman");
        this.ramOffenseTargets.add("pla.Memnoch");
        this.ramOffenseTargets.add("pulsar.PulsarMax");
        this.ramOffenseTargets.add("robar.nano.Mosquito");
        this.ramOffenseTargets.add("rz.Aleph");
        this.ramOffenseTargets.add("simonton.beta.LifelongObsession");
        this.ramOffenseTargets.add("stelo.Chord");
        this.ramOffenseTargets.add("stelo.Matchup");
        this.ramOffenseTargets.add("stelo.PastFuture");
        this.ramOffenseTargets.add("stelo.RamTrackSurfer");
        this.ramOffenseTargets.add("tcf.Drifter");
        this.ramOffenseTargets.add("tide.pear.Pear");
        this.ramOffenseTargets.add("trab.Crusader");
        this.ramOffenseTargets.add("voidious.Dookious");
        this.ramOffenseTargets.add("voidious.mini.Komarious");
        this.ramOffenseTargets.add("voidious.Lukious");
        this.ramOffenseTargets.add("vuen.Fractal");
        this.ramOffenseTargets.add("wcsv.Engineer.Engineer");
        this.ramOffenseTargets.add("wcsv.mega.PowerHouse2");
        this.ramOffenseTargets.add("whind.Strength");
        this.ramOffenseTargets.add("wiki.BasicGFSurfer");
        this.ramOffenseTargets.add("wiki.mini.Griffon");
        this.ramOffenseTargets.add("wiki.Wolverine");
        this.ramOffenseTargets.add("zeze2.OperatorZeze");
        this.waypointTargets.add("caimano.Furia_Ceca");
        this.waypointTargets.add("cjk.Merkava 0.2.0");
        this.waypointTargets.add("dans.Cinnamon");
        this.waypointTargets.add("jcs.Autobot");
        this.waypointTargets.add("kawigi.micro.Shiz");
        this.waypointTargets.add("krillr.mega.Phyche 0.0.2");
        this.waypointTargets.add("myl.micro.NekoNinja");
        this.waypointTargets.add("repositorio.NanoStep");
        this.waypointTargets.add("sgp.nano.FurryLeech");
        this.waypointTargets.add("dcs.Eater_of_Worlds Mini 1.0");
        this.waypointTargets.add("dks.MicroDanMK2");
        this.waypointTargets.add("et.Predator");
        this.waypointTargets.add("geep.mini.GPBotB");
        this.waypointTargets.add("krillr.mega.Phyche 0.0.3");
        this.waypointTargets.add("lrem.Spectre");
        this.waypointTargets.add("myl.micro.Predator");
        this.waypointTargets.add("myl.micro.Troodon");
        this.waypointTargets.add("rz.SmallDevil");
        this.waypointTargets.add("synnalagma.test.MiniNeural");
        this.waypointTargets.add("tobe.mini.Charon");
        this.waypointTargets.add("braaropolis.Abot");
        this.waypointTargets.add("pmc.SniperBot");
        this.waypointTargets.add("zen.Lindada");
        this.tangoTargets.add("alex.Diabolo");
        this.tangoTargets.add("amk.jointstrike.JointStrike");
        this.tangoTargets.add("amk.ShizzleStiX.ShizzleStiX");
        this.tangoTargets.add("bayen.UbaMicro");
        this.tangoTargets.add("bigpete.Stewie");
        this.tangoTargets.add("csm.NthGeneration");
        this.tangoTargets.add("deewiant.Anomaly");
        this.tangoTargets.add("dft.Freddie");
        this.tangoTargets.add("demetrix.nano.Neutrino");
        this.tangoTargets.add("dummy.micro.Sparrow");
        this.tangoTargets.add("fm.claire");
        this.tangoTargets.add("frag.FragBot");
        this.tangoTargets.add("franzor.Lizt");
        this.tangoTargets.add("gg.Wolverine");
        this.tangoTargets.add("hirataatsushi.Neo");
        this.tangoTargets.add("japs.Sjonniebot");
        this.tangoTargets.add("jaw.Mouse");
        this.tangoTargets.add("jaybot.adv.bots.JayBot");
        this.tangoTargets.add("joe.ADinosaur");
        this.tangoTargets.add("lion.Kresnanano");
        this.tangoTargets.add("lk.nano.Avesnar");
        this.tangoTargets.add("lorneswork.Predator");
        this.tangoTargets.add("md.November");
        this.tangoTargets.add("mld.DustBunny");
        this.tangoTargets.add("mrm.MightyMoose");
        this.tangoTargets.add("myl.nano.KomoriNinja");
        this.tangoTargets.add("mz.Adept 2.65");
        this.tangoTargets.add("mz.Movement");
        this.tangoTargets.add("mz.NanoGod");
        this.tangoTargets.add("ndn.DyslexicMonkey");
        this.tangoTargets.add("oa.weak.FlyMk1");
        this.tangoTargets.add("pe.minimelee.SandboxMiniMelee");
        this.tangoTargets.add("pez.nano.Icarus");
        this.tangoTargets.add("pfvicm.Sobieski");
        this.tangoTargets.add("pla.Memnoch");
        this.tangoTargets.add("pulsar.PulsarNano");
        this.tangoTargets.add("ratosh.Nobo");
        this.tangoTargets.add("rfj.Sunburn");
        this.tangoTargets.add("ruc.nano.Zealot");
        this.tangoTargets.add("rz.Artist");
        this.tangoTargets.add("sgp.MadHatter");
        this.tangoTargets.add("sigterm.Sigterm");
        this.tangoTargets.add("stelo.RamTrackSurfer");
        this.tangoTargets.add("stelo.Wang");
        this.tangoTargets.add("strider.Festis");
        this.tangoTargets.add("takeBot.SpinSpiral");
        this.tangoTargets.add("takeBot.WeavingWiggle");
        this.tangoTargets.add("taqho.taqbot");
        this.tangoTargets.add("toz.Gnome");
        this.tangoTargets.add("wiki.nano.DevilFISH");
        this.tangoTargets.add("wiki.nano.RaikoNano");
        this.fullThrottleTargets.add("davidalves.net.DuelistNano");
        this.fullThrottleTargets.add("dummy.micro.HummingBird");
        this.fullThrottleTargets.add("krillr.mini.JointStrike");
        this.fullThrottleTargets.add("non.mega.NaN");
        this.fullThrottleTargets.add("ntw.Sighup");
        this.fullThrottleTargets.add("ph.Thinker");
        this.fullThrottleTargets.add("vft.Hrist");
        this.gridTargets.add("asm.Statistas");
        this.gridTargets.add("bndl.LostLion");
        this.gridTargets.add("brainfade.Fallen");
        this.gridTargets.add("davidalves.net.DuelistMicro 1.22");
        this.gridTargets.add("davidalves.net.DuelistMicroMkII 1.1");
        this.gridTargets.add("dz.OthoMicro");
        this.gridTargets.add("mld.Moebius");
        this.gridTargets.add("non.mega.NoName");
        this.gridTargets.add("sgs.DogManSPE");
        this.gridTargets.add("strider.Mer");
        this.gridTargets.add("wiki.mini.BlackDestroyer");
    }

    public Target produce(String name) {
        TargetBase target = null;
        boolean allowProfiles = true;
        boolean allowFullThrottle = false;
        boolean allowRamOffense = true;
        boolean allowRamDefense = true;
        boolean allowWaypoint = false;
        boolean allowTango = true;
        boolean allowGrid = false;
        if (TargetFactory.isInList(name, this.targetingChallengeTargets)) {
            target = new TargetTargetingChallengeImpl(name);
        } else if (TargetFactory.isInList(name, this.movementChallengeTargets)) {
            target = new TargetMovementChallengeImpl(name);
        } else if (allowProfiles) {
            if (allowRamOffense && TargetFactory.isInList(name, this.ramOffenseTargets)) {
                target = new TargetMovementRambotOffenseImpl(name);
            } else if (allowRamDefense && TargetFactory.isInList(name, this.ramDefenseTargets)) {
                target = new TargetMovementRambotDefenseImpl(name);
            } else if (allowWaypoint && TargetFactory.isInList(name, this.waypointTargets)) {
                target = new TargetMovementWaypointImpl(name);
            } else if (allowTango && TargetFactory.isInList(name, this.tangoTargets)) {
                target = new TargetMovementTangoImpl(name);
            } else if (allowFullThrottle && TargetFactory.isInList(name, this.fullThrottleTargets)) {
                target = new TargetMovementFullThrottleImpl(name);
            } else if (allowGrid && TargetFactory.isInList(name, this.gridTargets)) {
                target = new TargetMovementGridImpl2(name);
            }
        }
        if (target == null) {
            target = new TargetStandardImpl(name);
        }
        this.consoleTick("Target [" + name + "] initialized as [" + target.getClass().getSimpleName() + "].");
        ++targetCount;
        return target;
    }

    private static boolean isInList(String name, Collection<String> c) {
        for (String e : c) {
            if (!name.contains(e)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String description() {
        return "Target Factory produced " + targetCount + " targets.";
    }
}

