/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;
import pedersen.divination.WaveOutboundImpl;
import pedersen.physics.BearingOffsetRange;
import pedersen.physics.Circle;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.SlopeFormula;
import pedersen.physics.Wave;

public class GeometryAdapter {
    public static Set<Double> quadraticEquation(double a, double b, double c) {
        HashSet<Double> set = new HashSet<Double>();
        double sqrt = Math.sqrt(b * b - 4.0 * a * c);
        if (a != 0.0 && sqrt != Double.NaN) {
            set.add((-b + sqrt) / (a + a));
            set.add((-b - sqrt) / (a + a));
        }
        return set;
    }

    public static Line2D.Double getInterceptLineSegment(WaveOutboundImpl out, Wave in, long time) {
        double relativeFiringSolution;
        Circle in1;
        Circle out1 = out.getCircle(time + 1L);
        BearingOffsetRange bor = out1.getRangeOfIntersection(in1 = in.getCircle(time + 1L));
        if (bor != null && bor.isInRange(relativeFiringSolution = out.firingSolution.getAbsoluteRadians() - out.getPosition().getBearing(in).getAbsoluteRadians())) {
            Point2D.Double p1;
            Point2D.Double anchor = out.getPosition().getPoint2D();
            SlopeFormula path = new SlopeFormula((HasPosition)out, out.firingSolution);
            Circle in0 = in.getCircle(time);
            Circle out0 = out.getCircle(time);
            Point2D.Double p0 = GeometryAdapter.getClosestPoint(out0.getPosition().getPoint2D(), path.getPointsOfIntersection(in1));
            if (out0.getRadius().radius() > anchor.distance(p0)) {
                p0 = out.getPosition().addVector((HasDirection)out.firingSolution, out0.getRadius().radius()).getPoint2D();
            }
            if ((p1 = GeometryAdapter.getClosestPoint(out1.getPosition().getPoint2D(), path.getPointsOfIntersection(in0))) == null || out1.getRadius().radius() < anchor.distance(p1)) {
                p1 = out.getPosition().addVector((HasDirection)out.firingSolution, out1.getRadius().radius()).getPoint2D();
            }
            if (anchor.distance(p0) < anchor.distance(p1)) {
                return new Line2D.Double(p0, p1);
            }
        }
        return null;
    }

    private static Point2D.Double getClosestPoint(Point2D.Double position, Set<Point2D.Double> c) {
        Point2D.Double closestPoint = null;
        double closestPointDistance = Double.POSITIVE_INFINITY;
        for (Point2D.Double e : c) {
            double d = position.distance(e);
            if (!(d < closestPointDistance)) continue;
            closestPointDistance = d;
            closestPoint = e;
        }
        return closestPoint;
    }
}

