/*
 * Decompiled with CFR 0.152.
 */
package tex;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.TreeMap;
import robocode.AdvancedRobot;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import tex.BotProgramming;
import tex.EnemyLocation;
import tex.FireProgram;
import tex.Gunner;
import tex.PatrolProgram;
import tex.Util;

public class Longbot
extends AdvancedRobot {
    private TreeMap<String, EnemyLocation> myEnemyLocations;
    private String myLockedEnemy = "";
    private int myMissedTarget = 0;
    public static double BULLET_SPEED = 20.0;
    public static double BULLET_POWER = 3.0;
    public PatrolProgram myPatrolProgram = new PatrolProgram();
    public FireProgram myFireProgram = new FireProgram();
    private Gunner myGunner;
    int X1 = -1;
    int X2;
    int Y1;
    int Y2;

    public Longbot() {
        this.myEnemyLocations = new TreeMap();
        this.myGunner = new AnticipateGunner();
    }

    public void run() {
        this.setColors(Color.red, Color.blue, Color.green);
        BotProgramming myBotProgram = new BotProgramming();
        while (true) {
            myBotProgram.nextProgram(this);
            myBotProgram.execute(this);
        }
    }

    public void onHitWall(HitWallEvent event) {
        System.out.println("hit wall");
        this.turnRightRadians(Math.PI - event.getBearingRadians());
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        assert (this.myEnemyLocations != null);
        this.myMissedTarget = 0;
        if (this.myLockedEnemy.equals("")) {
            this.myLockedEnemy = e.getName();
        }
        this.myEnemyLocations.put(e.getName(), new EnemyLocation(e, this));
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
        System.out.println("Bullet missed: " + Integer.toString(this.myMissedTarget));
        ++this.myMissedTarget;
        if (this.myMissedTarget > 5) {
            this.myLockedEnemy = "";
        }
    }

    public void onPaint(Graphics2D g) {
        EnemyLocation enemy = this.getLastSeenEnemy();
        System.out.println("on paint ");
        if (enemy != null) {
            double time = Math.sqrt(enemy.getDistanceSqr(this.getLocation())) / (BULLET_SPEED - 3.0 * BULLET_POWER);
            double enemyX = enemy.getX() + enemy.getdX() * (time += (double)(this.getTime() - enemy.getTime()));
            double enemyY = enemy.getY() + enemy.getdY() * time;
            g.setColor(Color.yellow);
            g.drawLine((int)this.getX(), (int)this.getY(), (int)enemyX, (int)enemyY);
            g.setColor(Color.green);
            g.drawLine((int)enemy.getX(), (int)enemy.getdY(), (int)enemyX, (int)enemyY);
            g.setColor(Color.red);
            if (this.X1 > 0) {
                g.drawLine(this.X1, this.Y1, this.X2, this.Y2);
            }
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.myEnemyLocations.remove(e.getName());
        if (this.myLockedEnemy.equals(e.getName())) {
            this.myLockedEnemy = "";
        }
    }

    public void onMouseClicked(MouseEvent e) {
        System.out.println("mouse: " + e.getX() + e.getY());
    }

    public EnemyLocation getLastSeenEnemy() {
        if (this.myLockedEnemy.equals("")) {
            return null;
        }
        return this.myEnemyLocations.get(this.myLockedEnemy);
    }

    public Point2D getLocation() {
        return new Point2D.Double(this.getX(), this.getY());
    }

    private Gunner getGunner() {
        return this.myGunner;
    }

    public boolean mustAimGun(EnemyLocation enemy) {
        return this.getGunner().mustAim(enemy);
    }

    public void aimGun(EnemyLocation enemy) {
        this.getGunner().aim(enemy);
    }

    public void fireGun() {
        this.getGunner().fire();
    }

    public class AnticipateGunner
    extends BasicGunner {
        @Override
        public double getGunMovementInRadians(EnemyLocation enemy) {
            double time = Math.sqrt(enemy.getDistanceSqr(Longbot.this.getLocation())) / (BULLET_SPEED - 3.0 * BULLET_POWER);
            double enemyX = enemy.getX() + enemy.getdX() * (time += (double)(Longbot.this.getTime() - enemy.getTime()));
            double enemyY = enemy.getY() + enemy.getdY() * time;
            if (enemyX < 0.0) {
                enemyX = 0.0;
            }
            if (enemyX > Longbot.this.getBattleFieldWidth()) {
                enemyX = Longbot.this.getBattleFieldWidth();
            }
            if (enemyY < 0.0) {
                enemyY = 0.0;
            }
            if (enemyY > Longbot.this.getBattleFieldHeight()) {
                enemyY = Longbot.this.getBattleFieldHeight();
            }
            double aimPointX = enemyX - Longbot.this.getX();
            double aimPointY = enemyY - Longbot.this.getY();
            double turnGunAngle = Math.atan2(aimPointY, aimPointX) - (1.5707963267948966 - Longbot.this.getGunHeadingRadians());
            return Util.ReduceAngle(turnGunAngle);
        }
    }

    public abstract class BasicGunner
    implements Gunner {
        @Override
        public void aim(EnemyLocation enemy) {
            Longbot.this.setTurnGunLeftRadians(this.getGunMovementInRadians(enemy));
        }

        public abstract double getGunMovementInRadians(EnemyLocation var1);

        @Override
        public void fire() {
            Longbot.this.setFireBullet(BULLET_POWER);
            EnemyLocation enemy = Longbot.this.getLastSeenEnemy();
            Longbot.this.X1 = (int)enemy.getX();
            Longbot.this.Y1 = (int)enemy.getY();
            double time = Math.sqrt(enemy.getDistanceSqr(Longbot.this.getLocation())) / (BULLET_SPEED - 3.0 * BULLET_POWER);
            Longbot.this.X2 = (int)(enemy.getX() + enemy.getdX() * (time += (double)(Longbot.this.getTime() - enemy.getTime())));
            Longbot.this.Y2 = (int)(enemy.getY() + enemy.getdY() * time);
        }

        @Override
        public boolean mustAim(EnemyLocation enemy) {
            return Math.abs(this.getGunMovementInRadians(enemy)) > 0.05;
        }
    }

    public class HeadsOnGunner
    extends BasicGunner {
        @Override
        public double getGunMovementInRadians(EnemyLocation enemy) {
            double turnGunAngle = Longbot.this.getGunHeadingRadians() - enemy.getDirection(Longbot.this);
            return Util.ReduceAngle(turnGunAngle);
        }
    }
}

