/*
 * Decompiled with CFR 0.152.
 */
package xander.core.track;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.RobotProxy;
import xander.core.event.BulletHitListener;
import xander.core.event.GunFiredEvent;
import xander.core.event.GunListener;
import xander.core.event.MyNonFiringWaveListener;
import xander.core.event.MyVirtualWaveListener;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentGunFiredEvent;
import xander.core.event.OpponentGunListener;
import xander.core.event.OpponentWaveListener;
import xander.core.event.RoundBeginListener;
import xander.core.event.ScannedRobotListener;
import xander.core.event.TurnListener;
import xander.core.gun.GunController;
import xander.core.gun.power.FixedPowerSelector;
import xander.core.gun.power.PowerSelector;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.paint.MyVirtualWavePainter;
import xander.core.paint.MyWavePainter;
import xander.core.paint.OpponentWavePainter;
import xander.core.track.BulletShadow;
import xander.core.track.OpponentGunWatcher;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;
import xander.core.track.WaveState;
import xander.core.track.XBullet;
import xander.core.track.XBulletWave;

public class WaveHistory
implements RoundBeginListener,
GunListener,
OpponentGunListener,
TurnListener,
BulletHitListener,
ScannedRobotListener {
    private static final Log log = Logger.getLog(WaveHistory.class);
    private List<Wave> opponentWaves = new ArrayList<Wave>();
    private List<XBulletWave> myWaves = new ArrayList<XBulletWave>();
    private List<XBulletWave> myVirtualWaves = new ArrayList<XBulletWave>();
    private List<Wave> myNonFiringWaves = new ArrayList<Wave>();
    private List<MyWaveListener> myWaveListeners = new ArrayList<MyWaveListener>();
    private List<MyVirtualWaveListener> myVirtualWaveListeners = new ArrayList<MyVirtualWaveListener>();
    private List<MyNonFiringWaveListener> myNonFiringWaveListeners = new ArrayList<MyNonFiringWaveListener>();
    private List<OpponentWaveListener> oppWaveListeners = new ArrayList<OpponentWaveListener>();
    private Wave oppNextWaveToHit;
    private SnapshotHistory snapshotHistory;
    private double maxWaveSaveDistance;
    private boolean processNonFiringWaves;
    private PowerSelector nonFiringPowerSelector;

    public WaveHistory(GunController gunController, OpponentGunWatcher opponentGunWatcher, RobotEvents robotEvents, RobotProxy robotProxy, SnapshotHistory snapshotHistory, Configuration configuration) {
        this.snapshotHistory = snapshotHistory;
        this.processNonFiringWaves = configuration.isProcessNonFiringWaves();
        if (this.processNonFiringWaves) {
            this.nonFiringPowerSelector = configuration.getNonFiringPowerSelector();
            if (this.nonFiringPowerSelector == null) {
                log.warn("No non-firing power selector set in the configuration; defaulting to fixed power selection of 1.95");
                this.nonFiringPowerSelector = new FixedPowerSelector(1.95);
            }
        }
        gunController.addGunListener(this);
        opponentGunWatcher.addOpponentGunListener(this);
        robotEvents.addRoundBeginListener(this);
        robotEvents.addTurnListener(this);
        robotEvents.addBulletHitListener(this);
        robotEvents.addScannedRobotListener(this);
        this.maxWaveSaveDistance = robotProxy.getBattleFieldDiagonal();
        if (configuration.isDrawOpponentWaves()) {
            robotEvents.addPainter(new OpponentWavePainter(this));
        }
        if (configuration.isDrawMyWaves()) {
            robotEvents.addPainter(new MyWavePainter(this));
        }
        if (configuration.isDrawMyVirtualWaves()) {
            robotEvents.addPainter(new MyVirtualWavePainter(this));
        }
    }

    @Override
    public void onRoundBegin() {
        this.opponentWaves.clear();
        this.myWaves.clear();
        this.myVirtualWaves.clear();
    }

    public int getOpponentWaveCount() {
        return this.opponentWaves.size();
    }

    public int getOpponentActiveWaveCount() {
        int count = 0;
        for (Wave wave : this.opponentWaves) {
            if (wave.isPassed()) continue;
            ++count;
        }
        return count;
    }

    public void addMyWaveListener(MyWaveListener listener) {
        this.myWaveListeners.add(listener);
    }

    public void addMyVirtualWaveListener(MyVirtualWaveListener listener) {
        this.myVirtualWaveListeners.add(listener);
    }

    public void addMyNonFiringWaveListener(MyNonFiringWaveListener listener) {
        this.myNonFiringWaveListeners.add(listener);
    }

    public void addOpponentWaveListener(OpponentWaveListener listener) {
        this.oppWaveListeners.add(listener);
    }

    public List<Wave> getOpponentWaves() {
        return this.opponentWaves;
    }

    public List<XBulletWave> getMyWaves() {
        return this.myWaves;
    }

    public List<XBulletWave> getMyVirtualWaves() {
        return this.myVirtualWaves;
    }

    public Wave getOpponentWaveAfter(Wave wave, double myX, double myY) {
        long time = Resources.getTime();
        long timeToHit = wave.getTimeUntilHit(myX, myY, time);
        long closestTimeToHitAfter = Long.MAX_VALUE;
        Wave closestWaveAfter = null;
        for (Wave waveAfter : this.opponentWaves) {
            long timeToHitAfter;
            if (wave == waveAfter || !waveAfter.isLeading() || (timeToHitAfter = waveAfter.getTimeUntilHit(myX, myY, time)) < timeToHit || timeToHitAfter >= closestTimeToHitAfter) continue;
            closestTimeToHitAfter = timeToHitAfter;
            closestWaveAfter = waveAfter;
        }
        return closestWaveAfter;
    }

    private void addBulletShadow(XBulletWave myWave, Wave opponentWave, long time) {
        if (myWave.getState() == WaveState.LEADING && opponentWave.getState() == WaveState.LEADING) {
            double angle2;
            double angle1;
            double turnAngle;
            double intersectPartialDistance;
            long currentTime = time;
            double distanceBetweenOrigins = RCMath.getDistanceBetweenPoints(myWave.getOrigin(), opponentWave.getOrigin());
            while (myWave.getBulletTravelDistance(time) + opponentWave.getBulletTravelDistance(time) < distanceBetweenOrigins) {
                ++time;
            }
            double trailPointDistance = myWave.getBulletTravelDistance(time - 1L);
            double leadPointDistance = myWave.getBulletTravelDistance(time);
            Point2D.Double leadPoint = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), leadPointDistance, myWave.getXBullet().getAim());
            Point2D.Double trailPoint = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), trailPointDistance, myWave.getXBullet().getAim());
            double t_t = RCMath.getDistanceBetweenPoints(opponentWave.getOrigin(), trailPoint);
            double t_i = opponentWave.getBulletTravelDistance(time);
            double t_im1 = opponentWave.getBulletTravelDistance(time - 1L);
            double t_l = RCMath.getDistanceBetweenPoints(opponentWave.getOrigin(), leadPoint);
            double t_max = Math.max(t_t, t_i);
            double t_min = Math.min(t_l, t_im1);
            if (t_l >= t_t || t_max - t_min > RCPhysics.MAX_BULLET_VELOCITY * 2.0) {
                return;
            }
            Point2D.Double useLeadPoint = leadPoint;
            Point2D.Double useTrailPoint = trailPoint;
            if (t_im1 > t_l) {
                intersectPartialDistance = myWave.getBulletVelocity() * ((t_t - t_im1) / (t_t - t_l));
                useLeadPoint = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), trailPointDistance + intersectPartialDistance, myWave.getXBullet().getAim());
            }
            if (t_i < t_t) {
                intersectPartialDistance = myWave.getBulletVelocity() * ((t_t - t_i) / (t_t - t_l));
                useTrailPoint = RCMath.getLocation(myWave.getOriginX(), myWave.getOriginY(), trailPointDistance + intersectPartialDistance, myWave.getXBullet().getAim());
            }
            if (Math.abs(turnAngle = RCMath.getTurnAngle(angle1 = RCMath.getRobocodeAngle(opponentWave.getOrigin(), useLeadPoint), angle2 = RCMath.getRobocodeAngle(opponentWave.getOrigin(), useTrailPoint))) > 20.0) {
                log.warn("Possible bad bullet shadow; currentTime=" + currentTime + ";intersectTime=" + time);
                log.warn("Angles " + Logger.format(angle1) + "; " + Logger.format(angle2));
                log.warn("t_t=" + Logger.format(t_t) + ";t_l=" + Logger.format(t_l) + ";t_i=" + Logger.format(t_i) + ";t_im1=" + Logger.format(t_im1));
            }
            if (turnAngle < 0.0) {
                opponentWave.addBulletShadow(new BulletShadow(angle2, angle1));
            } else {
                opponentWave.addBulletShadow(new BulletShadow(angle1, angle2));
            }
        }
    }

    @Override
    public void gunFired(GunFiredEvent event) {
        long adjustedFireTime = Resources.getTime();
        XBullet xbullet = new XBullet(event.getMySnapshot().getLocation(), event.getAim(), event.getPower());
        XBulletWave wave = new XBulletWave(event.getOpponentSnapshot(), event.getMySnapshot(), xbullet, event.getGun().getName(), adjustedFireTime);
        this.myWaves.add(wave);
        for (Wave opponentWave : this.opponentWaves) {
            this.addBulletShadow(wave, opponentWave, Resources.getTime());
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppWaveUpdated(opponentWave);
            }
        }
        for (MyWaveListener listener : this.myWaveListeners) {
            listener.myWaveCreated(wave);
        }
    }

    @Override
    public void virtualGunFired(GunFiredEvent event) {
        long adjustedFireTime = Resources.getTime();
        XBullet xbullet = new XBullet(event.getMySnapshot().getLocation(), event.getAim(), event.getPower());
        XBulletWave wave = new XBulletWave(event.getOpponentSnapshot(), event.getMySnapshot(), xbullet, event.getGun().getName(), adjustedFireTime);
        this.myVirtualWaves.add(wave);
        for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
            listener.myVirtualWaveCreated(wave);
        }
    }

    private void addNonFiringWave(Snapshot opponent) {
        long fireTime = Resources.getTime();
        double power = this.nonFiringPowerSelector.getFirePower(opponent);
        Wave wave = new Wave(this.snapshotHistory.getMySnapshot(), opponent, power, fireTime);
        this.myNonFiringWaves.add(wave);
        for (MyNonFiringWaveListener listener : this.myNonFiringWaveListeners) {
            listener.myNonFiringWaveCreated(wave);
        }
    }

    @Override
    public void opponentGunFired(OpponentGunFiredEvent event) {
        long adjustedFireTime = event.getTime() - 1L;
        Wave wave = new Wave(event.getMySnapshot(), event.getOpponentSnapshot(), event.getPower(), adjustedFireTime);
        this.opponentWaves.add(wave);
        for (XBulletWave myWave : this.myWaves) {
            this.addBulletShadow(myWave, wave, Resources.getTime());
        }
        for (OpponentWaveListener listener : this.oppWaveListeners) {
            listener.oppWaveCreated(wave);
        }
    }

    private void updateMyWaves(long time) {
        Snapshot oppSnapshot = null;
        Iterator<XBulletWave> iter = this.myWaves.iterator();
        while (iter.hasNext()) {
            XBulletWave wave = iter.next();
            if (oppSnapshot == null || !oppSnapshot.getName().equals(wave.getInitialDefenderSnapshot().getName())) {
                oppSnapshot = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            }
            double waveDistance = wave.getBulletTravelDistance(time);
            double oppDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= oppDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (MyWaveListener listener : this.myWaveListeners) {
                    listener.myWaveHit(wave, oppSnapshot);
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= oppDistance) {
                wave.state = WaveState.PASSING;
                for (MyWaveListener listener : this.myWaveListeners) {
                    listener.myWavePassing(wave, oppSnapshot);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= oppDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (MyWaveListener listener : this.myWaveListeners) {
                    listener.myWavePassed(wave, oppSnapshot);
                }
            }
            if (wave.getState() != WaveState.PASSED || !(waveDistance > this.maxWaveSaveDistance)) continue;
            for (MyWaveListener listener : this.myWaveListeners) {
                listener.myWaveDestroyed(wave);
            }
            iter.remove();
        }
    }

    private void updateMyVirtualWaves(long time) {
        Snapshot oppSnapshot = null;
        Iterator<XBulletWave> iter = this.myVirtualWaves.iterator();
        while (iter.hasNext()) {
            XBulletWave wave = iter.next();
            if (oppSnapshot == null || !oppSnapshot.getName().equals(wave.getInitialDefenderSnapshot().getName())) {
                oppSnapshot = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            }
            double waveDistance = wave.getBulletTravelDistance(time);
            double oppDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= oppDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                    listener.myVirtualWaveHit(wave);
                }
                double waveDistanceToOpponent = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
                Point2D.Double expectedRobotPosition = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), waveDistanceToOpponent, wave.getXBullet().getAim());
                double diff = RCMath.getDistanceBetweenPoints(oppSnapshot.getLocation(), expectedRobotPosition);
                if (diff <= 20.0) {
                    for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                        listener.myVirtualBulletHit(wave);
                    }
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= oppDistance) {
                wave.state = WaveState.PASSING;
                for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                    listener.myVirtualWavePassing(wave);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= oppDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                    listener.myVirtualWavePassed(wave);
                }
            }
            if (wave.getState() != WaveState.PASSED || !(waveDistance > this.maxWaveSaveDistance)) continue;
            for (MyVirtualWaveListener listener : this.myVirtualWaveListeners) {
                listener.myVirtualWaveDestroyed(wave);
            }
            iter.remove();
        }
    }

    private void updateMyNonFiringWaves(long time) {
        Snapshot oppSnapshot = null;
        Iterator<Wave> iter = this.myNonFiringWaves.iterator();
        while (iter.hasNext()) {
            Wave wave = iter.next();
            if (oppSnapshot == null || !oppSnapshot.getName().equals(wave.getInitialDefenderSnapshot().getName())) {
                oppSnapshot = this.snapshotHistory.getSnapshot(wave.getInitialDefenderSnapshot().getName());
            }
            double waveDistance = wave.getBulletTravelDistance(time);
            double oppDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), oppSnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= oppDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (MyNonFiringWaveListener listener : this.myNonFiringWaveListeners) {
                    listener.myNonFiringWaveHit(wave, oppSnapshot);
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= oppDistance) {
                wave.state = WaveState.PASSING;
                for (MyNonFiringWaveListener listener : this.myNonFiringWaveListeners) {
                    listener.myNonFiringWavePassing(wave, oppSnapshot);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= oppDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (MyNonFiringWaveListener listener : this.myNonFiringWaveListeners) {
                    listener.myNonFiringWavePassed(wave, oppSnapshot);
                }
            }
            if (wave.getState() != WaveState.PASSED || !(waveDistance > this.maxWaveSaveDistance)) continue;
            for (MyNonFiringWaveListener listener : this.myNonFiringWaveListeners) {
                listener.myNonFiringWaveDestroyed(wave);
            }
            iter.remove();
        }
    }

    private void updateOpponentWaves(long time) {
        Snapshot mySnapshot = this.snapshotHistory.getMySnapshot(time);
        Wave nextWaveToHit = null;
        double minToHitDistance = Double.MAX_VALUE;
        Iterator<Wave> iter = this.opponentWaves.iterator();
        while (iter.hasNext()) {
            double distToHit;
            Wave wave = iter.next();
            double waveDistance = wave.getBulletTravelDistance(time);
            double myDistance = RCMath.getDistanceBetweenPoints(wave.getOrigin(), mySnapshot.getLocation());
            if (wave.getState() == WaveState.LEADING && waveDistance >= myDistance - 20.0) {
                wave.state = WaveState.HIT;
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWaveHit(wave);
                }
            }
            if (wave.getState() == WaveState.HIT && waveDistance >= myDistance) {
                wave.state = WaveState.PASSING;
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWavePassing(wave);
                }
            }
            if (wave.getState() == WaveState.PASSING && waveDistance >= myDistance + 20.0) {
                wave.state = WaveState.PASSED;
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWavePassed(wave);
                }
            }
            if (wave.getState() == WaveState.PASSED && waveDistance > this.maxWaveSaveDistance) {
                for (OpponentWaveListener listener : this.oppWaveListeners) {
                    listener.oppWaveDestroyed(wave);
                }
                iter.remove();
            }
            if (wave.getState() != WaveState.LEADING || !((distToHit = myDistance - waveDistance) < minToHitDistance)) continue;
            minToHitDistance = distToHit;
            nextWaveToHit = wave;
        }
        if (nextWaveToHit != this.oppNextWaveToHit) {
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppNextWaveToHit(nextWaveToHit);
            }
            this.oppNextWaveToHit = nextWaveToHit;
        }
    }

    @Override
    public void onTurnBegin() {
        long time = Resources.getTime();
        this.updateMyWaves(time);
        this.updateMyVirtualWaves(time);
        this.updateOpponentWaves(time);
        if (this.processNonFiringWaves) {
            this.updateMyNonFiringWaves(time);
        }
    }

    @Override
    public void onTurnEnd() {
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        XBulletWave wave = (XBulletWave)this.getMatchingWave(this.myWaves, event.getBullet(), event.getTime());
        if (wave != null) {
            for (MyWaveListener listener : this.myWaveListeners) {
                listener.myBulletHit(wave, event);
            }
        }
    }

    private Wave getMatchingWave(List<? extends Wave> waves, Bullet bullet, long time) {
        double closestWaveDist = Double.POSITIVE_INFINITY;
        Wave closestWave = null;
        for (Wave wave : waves) {
            if (!RCMath.differenceLessThan(bullet.getVelocity(), wave.getBulletVelocity(), 0.05)) continue;
            double waveDistance = wave.getBulletTravelDistance(time);
            double bulletAngle = RCMath.getRobocodeAngle(wave.getOriginX(), wave.getOriginY(), bullet.getX(), bullet.getY());
            Point2D.Double wavePoint = RCMath.getLocation(wave.getOriginX(), wave.getOriginY(), waveDistance, bulletAngle);
            double positionDifference = RCMath.getDistanceBetweenPoints(wavePoint.x, wavePoint.y, bullet.getX(), bullet.getY());
            if (!(positionDifference < closestWaveDist)) continue;
            closestWaveDist = positionDifference;
            closestWave = wave;
        }
        if (closestWaveDist <= bullet.getVelocity() * 2.0 + 0.1) {
            return closestWave;
        }
        log.warn("Unable to find matching wave for bullet.");
        log.warn("Bullet: owner=" + bullet.getName() + "; velocity=" + Logger.format(bullet.getVelocity()) + "; closest wave dist=" + closestWaveDist);
        return null;
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent event) {
        Wave oppWave;
        Bullet myBullet = event.getBullet();
        Bullet oppBullet = event.getHitBullet();
        long time = event.getTime();
        XBulletWave myWave = (XBulletWave)this.getMatchingWave(this.myWaves, myBullet, time);
        if (myWave != null) {
            for (MyWaveListener listener : this.myWaveListeners) {
                listener.myWaveHitBullet(myWave, myBullet);
            }
            this.myWaves.remove(myWave);
        }
        if ((oppWave = this.getMatchingWave(this.opponentWaves, oppBullet, time)) != null) {
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppWaveHitBullet(oppWave, oppBullet);
            }
            this.opponentWaves.remove(oppWave);
        }
    }

    @Override
    public void onBulletMissed(BulletMissedEvent event) {
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        Wave wave = this.getMatchingWave(this.opponentWaves, event.getBullet(), event.getTime());
        if (wave != null) {
            for (OpponentWaveListener listener : this.oppWaveListeners) {
                listener.oppBulletHit(wave, event);
            }
        }
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        if (this.processNonFiringWaves) {
            Snapshot opponentSnapshot = this.snapshotHistory.getLastOpponentScanned();
            this.addNonFiringWave(opponentSnapshot);
        }
    }
}

