/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.bot;

import java.util.Iterator;
import pedersen.debug.Debug;
import pedersen.divination.WaveData;
import pedersen.misc.CalculatedValue;
import pedersen.misc.RollingAverage;
import pedersen.misc.TrueAverage;
import pedersen.tactics.bot.BearingOffsetRange;
import pedersen.tactics.bot.BearingOffsetTracker;

public class BearingOffsetTrackerRollingAverageImpl
implements BearingOffsetTracker {
    private CalculatedValue bearingOffset = new RollingAverage(5.0, 1.0);

    public double getBearingOffset() {
        return this.bearingOffset.value();
    }

    public void addWaveData(WaveData waveData) {
        TrueAverage averageOffset = new TrueAverage();
        Iterator iterator = waveData.getBearingOffsetRangeIterator();
        while (iterator.hasNext()) {
            BearingOffsetRange bearingOffsetRange = (BearingOffsetRange)iterator.next();
            averageOffset.add(bearingOffsetRange.min());
            averageOffset.add(bearingOffsetRange.max());
        }
        this.bearingOffset.add(averageOffset.value());
    }

    public void onFire() {
    }

    public void debug() {
        Debug.debug("BearingOffsettracker: bearingOffset = " + this.bearingOffset.value());
    }
}

