/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.movement;

import pedersen.debug.Debug;
import pedersen.tactics.movement.MovementMethod;

public abstract class MovementMethodBase
implements MovementMethod {
    private int persistenceId;
    private int timeInUse = 0;
    private int hitTally = 0;
    protected boolean exclusive = false;

    public MovementMethodBase(int newPersistenceId) {
        this.persistenceId = newPersistenceId;
    }

    public void recordTime() {
        ++this.timeInUse;
    }

    public void recordHit() {
        ++this.hitTally;
    }

    public void onEnemyFire() {
    }

    public void activate() {
    }

    protected double calculateMagnitude(double force, double distance) {
        double ratio = force / distance;
        return ratio * Math.abs(ratio);
    }

    public void debug() {
        if (this.timeInUse == 0) {
            Debug.debug(String.valueOf(this.getClass().getSimpleName()) + " has not been not used.");
        } else if (this.hitTally == 0) {
            Debug.debug(String.valueOf(this.getClass().getSimpleName()) + "has not been hit over " + this.timeInUse + " ticks.");
        } else {
            Debug.debug(String.valueOf(this.getClass().getSimpleName()) + " Hits: " + this.hitTally + ", Time in Use: " + this.timeInUse + ", Average t/h: " + Debug.trim((double)this.timeInUse / (double)this.hitTally));
        }
    }

    public int getPersistenceId() {
        return this.persistenceId;
    }

    public int getTimeInUse() {
        return this.timeInUse;
    }

    public int getHitTally() {
        return this.hitTally;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }
}

