/*
 * Decompiled with CFR 0.152.
 */
package rtk;

import java.awt.geom.Point2D;
import rtk.Aiming;
import rtk.Tachikoma;

public class PredictPosData {
    private boolean checking = true;
    private long startTime;
    private int timeLength;
    private Aiming.AimType aimType;
    private double howFarOff = Double.MAX_VALUE;
    private Point2D pos;
    private int roundNum;
    private double hitRate;

    public PredictPosData(Aiming.AimType aimType, int timeLength, Point2D pos, long robotTime, int roundNum) {
        this.aimType = aimType;
        this.timeLength = timeLength;
        this.pos = pos;
        this.startTime = robotTime;
        this.roundNum = roundNum;
    }

    public void tick(Point2D ePos, long robotTime) {
        if (this.checking && this.startTime + (long)Aiming.PREDICT_POS_DATA_TIME_DISTANCES[this.timeLength] <= robotTime) {
            this.checking = false;
            this.howFarOff = this.pos.distance(ePos);
            this.hitRate = Math.pow(1.0 / (double)((int)(this.howFarOff / (double)((int)(Tachikoma.TANK_SIZE / 10.0))) + 1), 2.0);
        }
    }

    public double getHowFarOff() {
        return this.howFarOff;
    }

    public boolean getChecking() {
        return this.checking;
    }

    public int getTimeLength() {
        return this.timeLength;
    }

    public Aiming.AimType getAimType() {
        return this.aimType;
    }

    public double getHitRate() {
        return this.hitRate;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getRoundNum() {
        return this.roundNum;
    }
}

