/*
 * Decompiled with CFR 0.152.
 */
package agd;

import agd.intel.ChessBoard;
import agd.predict.Footprint;
import agd.predict.TargetPrediction;
import agd.predict.Trackable;
import agd.radar.MultipleTargetRadarLock;
import agd.radar.RadarStrategy;
import agd.radar.SingleTargetRadarLock;
import agd.util.AdvancedRobotListener;
import agd.util.Aim;
import agd.util.AimStrategy;
import agd.util.ChessStrategy;
import agd.util.CleverTargetSelector;
import agd.util.Compass;
import agd.util.Coord;
import agd.util.Enemy;
import agd.util.FinishWave;
import agd.util.IterativeAimStrategy;
import agd.util.Navigation;
import agd.util.NavigationStrategy;
import agd.util.Navigator;
import agd.util.RobotInformation;
import agd.util.RobotLogEntry;
import agd.util.RobotLogger;
import agd.util.RobotSighting;
import agd.util.RollingAverage;
import agd.util.Stats;
import agd.util.Stopwatch;
import agd.util.TargetSelectionStrategy;
import agd.util.World;
import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Mooserwirt2
extends AdvancedRobot
implements RobotInformation,
Navigator,
Trackable {
    RadarStrategy radarStrategy = null;
    NavigationStrategy navStrat = null;
    AimStrategy aimStrat = null;
    TargetSelectionStrategy targetSelector = null;
    Vector listenerList = new Vector();
    Enemy target = null;
    Map enemies = new HashMap();
    Map ourBulletsInFlight = new HashMap();
    List enemiesByDistance = new LinkedList();
    private SortedMap ourHistory = new TreeMap();
    private List ourHistoryList = new LinkedList();
    private static int HISTORY_MEMORY = 10;
    RollingAverage avTurnProcessingTime = Stats.STATS.getAverageTurnProcessingTime();
    Thread robotThread;
    int skippedTurns = 0;
    private static final int SQUARE_SIZE_FEW_ENEMIES = 100;
    private static final int SQUARE_SIZE_MANY_ENEMIES = 50;
    private static final int SQUARE_SIZE_CHANGE_THRESHOLD = 1;
    ChessBoard chessBoard;
    Comparator enemyDistanceComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            RobotSighting s1 = ((Enemy)o1).getLastSighting();
            RobotSighting s2 = ((Enemy)o2).getLastSighting();
            return (int)(s1.getScannedRobotEvent().getDistance() - s2.getScannedRobotEvent().getDistance());
        }
    };

    public void run() {
        World.registerAdvancedRobot(this);
        this.robotThread = Thread.currentThread();
        Stats.STATS.registerEventSource(this);
        if (this.getOthers() <= 1) {
            this.chessBoard = ChessBoard.constructInstance(100);
            if (World.isDebug()) {
                System.out.println("Created with few opponents parameters.");
            }
        } else {
            this.chessBoard = ChessBoard.constructInstance(50);
            if (World.isDebug()) {
                System.out.println("Created with many opponents parameters.");
            }
        }
        this.chessBoard.registerEventSource(this);
        Aim aim = null;
        Navigation movement = null;
        this.enemiesByDistance = new LinkedList();
        this.roundStartInitialisation();
        this.onRoundStart(this);
        this.setNavigationStrategy(new ChessStrategy(this, 0));
        this.targetSelector = new CleverTargetSelector(this);
        this.setRadarStrategy(new MultipleTargetRadarLock(this, 10));
        this.aimStrat = new IterativeAimStrategy(this);
        try {
            RobotLogger logger = new RobotLogger(this.getDataDirectory(), this.getRoundNum());
            this.addListener(logger);
        }
        catch (IOException ioe) {
            System.out.println("Unable to log other robot movements. Error was: " + ioe);
        }
        double power = 0.0;
        double radarBearing = 0.0;
        while (true) {
            Stopwatch turnTimer = new Stopwatch();
            Footprint lastFootprint = null;
            if (this.ourHistoryList.size() > 0) {
                lastFootprint = (Footprint)this.ourHistoryList.get(this.ourHistoryList.size() - 1);
            }
            RobotLogEntry thisTurn = new RobotLogEntry(this, lastFootprint);
            this.ourHistory.put(new Long(this.getTime()), thisTurn);
            this.ourHistoryList.add(thisTurn);
            Long removeKey = new Long(this.getTime() - (long)HISTORY_MEMORY);
            if (this.ourHistory.containsKey(removeKey)) {
                this.ourHistory.remove(removeKey);
            }
            ListIterator lit = this.ourHistoryList.listIterator(0);
            while (lit.hasNext()) {
                RobotLogEntry oldest = (RobotLogEntry)lit.next();
                if (oldest.getTime() >= this.getTime() - (long)HISTORY_MEMORY) break;
                lit.remove();
            }
            this.onTickStart();
            Enemy newtarget = this.targetSelector.getTarget();
            if (newtarget != null && newtarget != this.target) {
                if (World.isDebug()) {
                    System.out.println("Now targetting " + newtarget);
                }
                this.setTarget(newtarget);
                this.radarStrategy.setPrimaryTarget(newtarget);
            }
            movement = this.navStrat.navigate();
            movement.execute(this);
            aim = this.aimStrat.aimAtTarget(this.target);
            if (aim.getGunBearing() != null) {
                this.setTurnGunRight(aim.getGunBearing());
            }
            if ((radarBearing = this.radarStrategy.getRadarBearing()) != 0.0) {
                this.setTurnRadarRight(radarBearing);
            }
            this.avTurnProcessingTime.nextValue(turnTimer.stop());
            if (aim != null && aim.getPower() > 0.0) {
                Bullet bullet = this.fireBullet(aim.getPower());
                if (bullet == null || this.target == null) continue;
                this.ourBulletsInFlight.put(bullet, this.target);
                Stats.STATS.fired(this.target, bullet);
                this.target.onBulletFired(bullet);
                continue;
            }
            this.execute();
        }
    }

    public void debugEstimate() {
        RobotSighting lastSighting = this.target.getLastSighting();
        List recentFootprints = this.target.getRecentFootprints();
        System.out.println("Turn " + this.getTime() + ": lastSighting of " + this.target + " = " + lastSighting);
        ListIterator lit = recentFootprints.listIterator(recentFootprints.size());
        Footprint back1 = (Footprint)lit.previous();
        Footprint back2 = (Footprint)lit.previous();
        System.out.println("Last 2 footprints :\n1) " + back1 + "\n2) " + back2);
        Coord predict50 = TargetPrediction.CIRCULAR.predictTarget(this.target, this.getTime() + 50L);
        System.out.println("At turn " + (this.getTime() + 50L) + "Target predicted to be at " + predict50);
    }

    public void debugEstimate2(RobotSighting s, Enemy e) {
        ScannedRobotEvent ev = s.getScannedRobotEvent();
        System.out.println("Turn " + this.getTime() + ": " + e + " sighted during turn " + ev.getTime() + " at " + s.getTheirPosition());
        Coord retroPrediction = TargetPrediction.CIRCULAR.retrospectivelyPredict(e, this.getTime(), this.getTime() - 50L);
        System.out.println("Retrospective prediction: If we'd guessed at time " + (this.getTime() - 50L) + ", we'd have thought the target would be at " + retroPrediction + " at turn " + this.getTime());
    }

    public void setNavigationStrategy(NavigationStrategy newStrat) {
        if (World.isDebug()) {
            System.out.println("Switching from " + this.navStrat + " to " + newStrat);
        }
        this.navStrat = newStrat;
    }

    public void setRadarStrategy(RadarStrategy newStrat) {
        if (World.isDebug()) {
            System.out.println("Switching radar strategy from " + this.radarStrategy + " to " + newStrat);
        }
        this.radarStrategy = newStrat;
    }

    public NavigationStrategy getNavigationStrategy() {
        return this.navStrat;
    }

    void roundStartInitialisation() {
        this.setColors(new Color(159, 85, 178), new Color(221, 129, 244), new Color(242, 204, 252));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setMaxVelocity(8.0);
        this.setMaxTurnRate(10.0);
        if (World.isDebug()) {
            System.out.println("Round start:\n\tlistenerList contains " + this.listenerList.size() + " listeners");
            System.out.println("\tenemies contains " + this.enemies.size() + " enemies");
        }
    }

    void evaluateBestTarget() {
        long targetLostFor;
        if (this.target != null && (targetLostFor = this.getTime() - this.target.getLastSighting().getScannedRobotEvent().getTime()) > 100L) {
            this.setTarget(null);
        }
    }

    public void addListener(AdvancedRobotListener l) {
        this.listenerList.add(l);
    }

    public void removeListener(AdvancedRobotListener l) {
        ListIterator lit = this.listenerList.listIterator();
        AdvancedRobotListener check = null;
        boolean deleted = false;
        while (!deleted && lit.hasNext()) {
            check = (AdvancedRobotListener)lit.next();
            if (check != l) continue;
            lit.remove();
            deleted = true;
        }
    }

    public void onTickStart() {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onTickStart();
        }
    }

    public void onRoundStart(AdvancedRobot ar) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onRoundStart(ar);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this.enemies.containsKey(e.getName())) {
            Enemy enemyHit = (Enemy)this.enemies.get(e.getName());
            enemyHit.onBulletHit(e);
        }
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onBulletHit(e);
        }
        Enemy aimedAt = (Enemy)this.ourBulletsInFlight.get(e.getBullet());
        if (aimedAt != null) {
            aimedAt.onBulletOutOfPlay(e.getBullet());
        }
        this.ourBulletsInFlight.remove(e.getBullet());
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onBulletHitBullet(e);
        }
        Enemy aimedAt = (Enemy)this.ourBulletsInFlight.get(e.getBullet());
        if (aimedAt != null) {
            aimedAt.onBulletOutOfPlay(e.getBullet());
        }
        this.ourBulletsInFlight.remove(e.getBullet());
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onBulletMissed(e);
        }
        Bullet b = e.getBullet();
        if (b != null) {
            Enemy aimedAt = (Enemy)this.ourBulletsInFlight.get(b);
            if (aimedAt != null) {
                aimedAt.onBulletOutOfPlay(b);
            }
            this.ourBulletsInFlight.remove(b);
        } else {
            System.out.println("BulletMissedEvent " + e + " has given us a null bullet.");
        }
    }

    public void onCustomEvent(CustomEvent e) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onCustomEvent(e);
        }
    }

    public void onHitWall(HitWallEvent e) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onHitWall(e);
        }
    }

    public void onHitRobot(HitRobotEvent hre) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onHitRobot(hre);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        Enemy enemy = null;
        if (this.enemies.containsKey(e.getName())) {
            enemy = (Enemy)this.enemies.get(e.getName());
        } else {
            enemy = new Enemy(e.getName());
            this.enemies.put(e.getName(), enemy);
            this.enemiesByDistance.add(enemy);
        }
        enemy.onScannedRobot(e);
        Collections.sort(this.enemiesByDistance, this.enemyDistanceComparator);
        if (this.target == null) {
            this.setTarget(enemy);
            this.radarStrategy.setPrimaryTarget(enemy);
        }
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            AdvancedRobotListener r = (AdvancedRobotListener)lit.next();
            r.onScannedRobot(e);
            r.onEnemySighted(enemy);
        }
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        ++this.skippedTurns;
    }

    public Coord getPosition() {
        return new Coord(this.getX(), this.getY());
    }

    public void setTarget(Enemy target) {
        this.target = target;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (this.enemies.containsKey(e.getName())) {
            Enemy enemyHit = (Enemy)this.enemies.get(e.getName());
            enemyHit.onHitByBullet(e);
        }
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onHitByBullet(e);
        }
    }

    public void onRobotDeath(RobotDeathEvent death) {
        Enemy enemy = null;
        if (this.enemies.containsKey(death.getName())) {
            enemy = (Enemy)this.enemies.get(death.getName());
            if (this.target != null && this.target.getName().equals(enemy.getName())) {
                this.setTarget(null);
            }
            this.enemies.remove(death.getName());
        }
        this.enemiesByDistance.remove(enemy);
        if (this.getOthers() == 1) {
            this.chessBoard.discard();
            this.chessBoard = ChessBoard.constructInstance(100);
            this.chessBoard.registerEventSource(this);
            if (World.isDebug()) {
                System.out.println("Switched to few opponents parameters.");
            }
        }
        if (this.getOthers() == 1) {
            this.setRadarStrategy(new SingleTargetRadarLock(this));
        } else if (this.getOthers() == 0) {
            this.setNavigationStrategy(new FinishWave(this));
            this.aimStrat = new FinishWave(this);
        }
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onRobotDeath(death);
        }
    }

    public void onDeath(DeathEvent de) {
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onDeath(de);
        }
        System.out.println("Aaauugghhhhhh!   (" + this.getOthers() + " robots still alive when we died.)");
        this.roundEndCleanup();
    }

    public void onWin(WinEvent we) {
        System.out.println("Yippeeee!!!!");
        ListIterator lit = this.listenerList.listIterator();
        while (lit.hasNext()) {
            ((AdvancedRobotListener)lit.next()).onWin(we);
        }
        this.roundEndCleanup();
    }

    void roundEndCleanup() {
        if (this.skippedTurns > 0) {
            Stats.STATS.getTurnsPerSkippedTurn().nextValue(this.getTime() / (long)this.skippedTurns);
        }
        Stats.STATS.getSkippedTurnsPerRound().nextValue(this.skippedTurns);
        Stats.STATS.createReport();
        if (World.isDebug()) {
            System.out.println("Round end:\n\tlistenerList contains " + this.listenerList.size() + " listeners");
            System.out.println("\tenemies contains " + this.enemies.size() + " enemies");
        }
        this.chessBoard.discard();
        System.gc();
    }

    void reportScanFrequencies() {
        Iterator i = this.enemies.values().iterator();
        while (i.hasNext()) {
            Enemy e = (Enemy)i.next();
            long timeSince = this.getTime() - e.getLastSighting().getTime();
            System.out.println(String.valueOf(this.getTime()) + ": " + e.toString() + " " + timeSince);
        }
    }

    public Map getEnemies() {
        return this.enemies;
    }

    public List getClosestEnemies(int number) {
        if (number == 0 || number >= this.enemiesByDistance.size()) {
            return this.enemiesByDistance;
        }
        return this.enemiesByDistance.subList(0, number);
    }

    public AdvancedRobot getAdvancedRobot() {
        return this;
    }

    public List getRecentFootprints() {
        return this.ourHistoryList;
    }

    static void testCoords() {
        Coord centre = new Coord(100.0, 100.0);
        Coord ne = new Coord(130.0, 140.0);
        Coord se = new Coord(130.0, 60.0);
        Coord sw = new Coord(70.0, 60.0);
        Coord nw = new Coord(70.0, 140.0);
        System.out.println("NE distance = " + (int)centre.distanceTo(ne) + " @ " + centre.headingTo(ne));
        System.out.println("SE distance = " + (int)centre.distanceTo(se) + " @ " + centre.headingTo(se));
        System.out.println("SW distance = " + (int)centre.distanceTo(sw) + " @ " + centre.headingTo(sw));
        System.out.println("NW distance = " + (int)centre.distanceTo(nw) + " @ " + centre.headingTo(nw));
    }

    static void testApplyVector() {
        Coord centre = new Coord(100.0, 100.0);
        Coord ne = centre.applyVector(new Compass(45.0), 50.0);
        Coord nw = centre.applyVector(new Compass(315.0), 50.0);
        Coord se = centre.applyVector(new Compass(135.0), 50.0);
        Coord sw = centre.applyVector(new Compass(225.0), 50.0);
        System.out.println("Centre is at " + centre);
        System.out.println("50 ne is " + ne);
        System.out.println("50 nw is " + nw);
        System.out.println("50 se is " + se);
        System.out.println("50 sw is " + sw);
    }

    static void testCompass() {
        Compass n = new Compass(0.0);
        Compass ne = new Compass(45.0);
        Compass e = new Compass(90.0);
        Compass se = new Compass(135.0);
        Compass s = new Compass(180.0);
        Compass sw = new Compass(225.0);
        Compass w = new Compass(270.0);
        Compass nw = new Compass(315.0);
        System.out.println("Fastest should be CLOCKWISE for following:");
        System.out.println(n.fastestTurnTo(ne));
        System.out.println(n.fastestTurnTo(e));
        System.out.println(n.fastestTurnTo(se));
        System.out.println(ne.fastestTurnTo(e));
        System.out.println(ne.fastestTurnTo(se));
        System.out.println(ne.fastestTurnTo(s));
        System.out.println(e.fastestTurnTo(se));
        System.out.println(e.fastestTurnTo(s));
        System.out.println(e.fastestTurnTo(sw));
        System.out.println(se.fastestTurnTo(s));
        System.out.println(se.fastestTurnTo(sw));
        System.out.println(se.fastestTurnTo(w));
        System.out.println(s.fastestTurnTo(sw));
        System.out.println(s.fastestTurnTo(w));
        System.out.println(s.fastestTurnTo(nw));
        System.out.println(w.fastestTurnTo(nw));
        System.out.println(w.fastestTurnTo(n));
        System.out.println(w.fastestTurnTo(ne));
        System.out.println("Fastest should be ANTI-CLOCKWISE for following:");
        System.out.println(n.fastestTurnTo(nw));
        System.out.println(n.fastestTurnTo(w));
        System.out.println(n.fastestTurnTo(sw));
        System.out.println(ne.fastestTurnTo(n));
        System.out.println(ne.fastestTurnTo(nw));
        System.out.println(ne.fastestTurnTo(w));
        System.out.println(e.fastestTurnTo(ne));
        System.out.println(e.fastestTurnTo(n));
        System.out.println(e.fastestTurnTo(nw));
        System.out.println(se.fastestTurnTo(e));
        System.out.println(se.fastestTurnTo(ne));
        System.out.println(se.fastestTurnTo(n));
        System.out.println(s.fastestTurnTo(se));
        System.out.println(s.fastestTurnTo(e));
        System.out.println(s.fastestTurnTo(ne));
        System.out.println(w.fastestTurnTo(se));
        System.out.println(w.fastestTurnTo(s));
        System.out.println(w.fastestTurnTo(sw));
        System.out.println("Gun heading 48, Target at 358");
        Compass gun = new Compass(48.0);
        Compass target = new Compass(358.0);
        System.out.println("Bearing from gun to target is " + gun.bearingTo(target) + " (" + gun.fastestTurnTo(target) + ")");
        System.out.println("Bearing from target to gun is " + target.bearingTo(gun) + " (" + target.fastestTurnTo(gun) + ")");
        System.out.println("n to n is " + n.bearingTo(n));
        System.out.println("n to ne is " + n.bearingTo(ne));
        System.out.println("n to nw is " + n.bearingTo(nw));
        System.out.println("n to e is " + n.bearingTo(e));
        System.out.println("n to w is " + n.bearingTo(w));
        System.out.println("n to se is " + n.bearingTo(se));
        System.out.println("n to sw is " + n.bearingTo(sw));
        System.out.println("n to s is " + n.bearingTo(s));
        System.out.println("e to n is " + e.bearingTo(n));
        System.out.println("e to ne is " + e.bearingTo(ne));
        System.out.println("e to nw is " + e.bearingTo(nw));
        System.out.println("e to e is " + e.bearingTo(e));
        System.out.println("e to w is " + e.bearingTo(w));
        System.out.println("e to se is " + e.bearingTo(se));
        System.out.println("e to sw is " + e.bearingTo(sw));
        System.out.println("e to s is " + e.bearingTo(s));
        System.out.println("w to n is " + w.bearingTo(n));
        System.out.println("w to ne is " + w.bearingTo(ne));
        System.out.println("w to nw is " + w.bearingTo(nw));
        System.out.println("w to e is " + w.bearingTo(e));
        System.out.println("w to w is " + w.bearingTo(w));
        System.out.println("w to se is " + w.bearingTo(se));
        System.out.println("w to sw is " + w.bearingTo(sw));
        System.out.println("w to s is " + w.bearingTo(s));
        System.out.println("s to n is " + s.bearingTo(n));
        System.out.println("s to ne is " + s.bearingTo(ne));
        System.out.println("s to nw is " + s.bearingTo(nw));
        System.out.println("s to e is " + s.bearingTo(e));
        System.out.println("s to w is " + s.bearingTo(w));
        System.out.println("s to se is " + s.bearingTo(se));
        System.out.println("s to sw is " + s.bearingTo(sw));
        System.out.println("s to s is " + s.bearingTo(s));
    }

    public static void testCoordCompass() {
        Random rand = new Random();
        int i = 0;
        while (i < 100) {
            Coord p1 = new Coord(1000.0 * rand.nextDouble(), 1000.0 * rand.nextDouble());
            Coord p2 = new Coord(1000.0 * rand.nextDouble(), 1000.0 * rand.nextDouble());
            Compass heading = p1.headingTo(p2);
            double distance = p1.distanceTo(p2);
            Coord p3 = p1.applyVector(heading, distance);
            String result = null;
            result = (int)p2.getX() == (int)p3.getX() && (int)p2.getY() == (int)p3.getY() ? "CORRECT:  " : "ERROR  :  ";
            System.out.println(result + "p1 = " + p1 + ", p2=" + p2 + ", p3=" + p3 + "\t" + heading + " " + distance);
            ++i;
        }
    }

    public static void main(String[] argv) {
        Mooserwirt2.testCoords();
        Mooserwirt2.testCompass();
        Mooserwirt2.testApplyVector();
        Mooserwirt2.testCoordCompass();
    }

    static {
        SQUARE_SIZE_FEW_ENEMIES = 100;
        SQUARE_SIZE_MANY_ENEMIES = 50;
        SQUARE_SIZE_CHANGE_THRESHOLD = 1;
    }
}

