/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class AutoBot
extends AdvancedRobot {
    static final int MOVE_STRATEGY_G2 = 0;
    static final int MOVE_STRATEGY_NORMAL = 1;
    static final int MOVE_STRATEGY_DODGE = 2;
    static final int MOVE_STRATEGY_ATTACK = 3;
    static final int MOVE_STRATEGY_CIRCLE = 4;
    static final int MOVE_STRATEGY_FLOOD = 5;
    static final int MOVE_STRATEGY_FORWARD = 6;
    static final int MOVE_STRATEGY_RAM = 7;
    static final int MOVE_STRATEGY_SPRIAL = 8;
    static final int MOVE_STRATEGY_WAVE = 9;
    static final int MOVE_STRATEGY_WALL = 10;
    static final int MOVE_STRATEGY_WIN = 11;
    static final int NUM_MOVES = 10;
    static final double MAX_VELOCITY = 8.0;
    static final double MAX_WALL_SMOOTH_TRIES = 150.0;
    static final int DISTANCE_BINS = 5;
    static final int VELOCITY_BINS = 5;
    static final int WALL_INDEXES = 4;
    static final int VCHANGE_TIME_INDEXES = 6;
    static final int FACTORS = 31;
    static final int MIDDLE_FACTOR = 15;
    static int enemyHits = 100;
    static int[][][][][][] gunFactors = new int[5][5][5][6][4][31];
    static int[][][][] moveFactors = new int[5][5][5][31];
    static int[] locationBins = new int[31];
    static double dangerForward;
    static double dangerReverse;
    static EnemyBulletBin currentShot;
    static final int SEARCH_DEPTH = 30;
    static final int MOVEMENT_LENGTH = 150;
    static final int BULLET_SPEED = 11;
    static final int MAX_RANGE = 800;
    static final int SEARCH_END_BUFFER = 102;
    static final int AWAY = 0;
    static final int GO = 1;
    Enemy target;
    static final double PI = Math.PI;
    int direction = 1;
    double firePower;
    int circleTics = 20;
    long contact_time;
    double maxField;
    Random generator = new Random();
    int nextTime = 2;
    double deltaEnergy = 0.0;
    double right = 1.0;
    double totalScans = 0.0;
    boolean restartMove = true;
    Rectangle2D.Double fireField;
    int floodRel = 90;
    double atackAngle = 1.0471975511965976;
    double atackAngleR = 1.5707963267948966;
    boolean isRight = false;
    double turnTime;
    double tAngle;
    int turnTimes = 30;
    int atackMode = 0;
    double powerGained;
    double powerLost;
    double waveTurnAngle = 1.0;
    double fieldWidth;
    double fieldHeight;
    static Rectangle2D fieldRectangle;
    RoundRectangle2D.Double playField;
    double posx;
    double posy;
    double newposx;
    double newposy;
    double myHeading;
    double mySpeed;
    double myDistance;
    double myCheckDistance;
    double myDeltaX;
    double myDeltaY;
    double myTurnAngle;
    double distance;
    double jiggleOffset;
    static double tWidth;
    static int lastRobotVelocityIndex;
    static double robotVelocity;
    private final int WALLAVOID = 30;
    private final double BLINDMANSTICK = 120.0;
    private final double MINSPEED = 2.0;
    private final double MEDSPEED = 4.0;
    private final double MAXSPEED = 8.0;
    static double[] percentMove;
    static double[] moveGoodBad;
    static int roundNumber;
    static Point2D robotLocation;
    static Point2D enemyLocation;
    static double enemyAbsoluteBearing;
    static double enemyDistance;
    static int distanceIndex;
    static int velocityIndex;
    static int enemyTimeSinceVChange;
    static double enemyBearingDirection;
    static int hitTime;
    static int distanceindex;
    static double lastv;
    static double[] benefit;
    static double[] penalty;
    static double[] arcLength;
    static int historyIndex;
    static StringBuffer patternMatcher;
    int movementStrategy = 0;
    int defaultStrategy = 0;
    static long totalShots;
    static long totalHits;

    public void run() {
        this.turnTime = this.getTime();
        this.powerLost = 0.0;
        this.powerGained = 0.0;
        if (++roundNumber == 1) {
            for (int ndx2 = 0; ndx2 < 10; ++ndx2) {
                AutoBot.percentMove[ndx2] = 10.0;
            }
            AutoBot.moveGoodBad[0] = 10.0;
            AutoBot.moveGoodBad[1] = 10.0;
            AutoBot.moveGoodBad[2] = 10.0;
            AutoBot.moveGoodBad[3] = 30.0;
            AutoBot.moveGoodBad[4] = 30.0;
            AutoBot.moveGoodBad[5] = 10.0;
            AutoBot.moveGoodBad[6] = 30.0;
            AutoBot.moveGoodBad[7] = 30.0;
            AutoBot.moveGoodBad[8] = 20.0;
            AutoBot.moveGoodBad[9] = 10.0;
        }
        this.fireField = new Rectangle2D.Double(17.0, 17.0, this.getBattleFieldWidth() - 34.0, this.getBattleFieldHeight() - 34.0);
        this.fieldWidth = this.getBattleFieldWidth();
        this.fieldHeight = this.getBattleFieldHeight();
        this.playField = new RoundRectangle2D.Double(30.0, 30.0, this.fieldWidth - 60.0, this.fieldHeight - 60.0, 50.0, 50.0);
        fieldRectangle = new Rectangle2D.Double(tWidth, tWidth, this.fieldWidth - tWidth * 2.0, this.fieldHeight - tWidth * 2.0);
        currentShot = null;
        if (locationBins[15] == 0) {
            AutoBot.locationBins[15] = enemyHits;
        }
        this.target = new Enemy();
        this.target.distance = 100000.0;
        this.setColors(Color.red, Color.orange, Color.yellow);
        this.maxField = Math.max(this.getBattleFieldHeight(), this.getBattleFieldWidth()) / 2.0;
        double testVal = Math.random() * 100.0;
        for (int ndx2 = 0; ndx2 < 10; ++ndx2) {
            if (!((testVal -= percentMove[ndx2]) < 0.0)) continue;
            this.movementStrategy = ndx2;
            break;
        }
        this.defaultStrategy = this.movementStrategy;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.doMovement();
            this.doFirePower();
            this.doScanner();
            this.doGun();
            if (this.getGunHeat() == 0.0 && this.target.distance != 100000.0 && this.firePower > 0.0 && this.getGunTurnRemaining() < 10.0) {
                this.setFire(this.firePower);
                int n = distanceindex;
                penalty[n] = penalty[n] + this.firePower;
                ++totalShots;
            }
            this.execute();
        }
    }

    void doFirePower() {
        this.firePower = Math.min(this.target.energy / 2.0, this.getEnergy() / 8.0);
        if (this.firePower > 3.0) {
            this.firePower = 3.0;
        }
    }

    int determineHowToMove() {
        int method = this.movementStrategy;
        if (method < 10 && method != 0 && method != 9 && (this.getY() < 75.0 || this.getY() > this.getBattleFieldHeight() - 75.0 || this.getX() < 75.0 || this.getX() > this.getBattleFieldWidth() - 75.0)) {
            method = 10;
            double tmpbearing = 1.5707963267948966 - Math.atan2(this.maxField - this.target.myY, this.maxField - this.target.myX);
            double turnAngle = this.normalRelativeAngle(tmpbearing - this.getHeadingRadians());
            double myTurnAngle = Math.atan(Math.tan(turnAngle));
            this.setTurnRightRadians(myTurnAngle);
            this.direction = 1;
            if (Math.cos(turnAngle) < 0.0) {
                this.direction = -1;
            }
            this.setAhead(50.0 * Math.cos(turnAngle));
            this.movementStrategy = 10;
            this.contact_time = this.getTime();
        }
        return method;
    }

    void doMovement() {
        this.movementStrategy = this.determineHowToMove();
        switch (this.movementStrategy) {
            case 5: {
                this.setTurnRightRadians(this.target.bearing - (double)this.floodRel * 0.0174532);
                --this.nextTime;
                --hitTime;
                if (this.deltaEnergy > 0.0 && this.deltaEnergy <= 3.0) {
                    int n = distanceindex;
                    benefit[n] = benefit[n] + this.deltaEnergy;
                    if (this.nextTime <= 0) {
                        this.direction = Math.random() < 0.5 ? -1 : 1;
                        hitTime = (int)(this.target.distance / (20.0 - 3.0 * this.deltaEnergy));
                        this.nextTime = hitTime >> 1;
                        this.setMaxVelocity(2.0 + Math.random() * 15.0);
                    }
                }
                if (this.out(this.target.myX, this.target.myY, this.getHeadingRadians(), this.direction * 30)) {
                    this.direction = -this.direction;
                }
                this.setAhead(this.direction * 30);
                break;
            }
            case 9: {
                this.setAhead(Math.cos(this.waveTurnAngle) * 100.0);
                this.setTurnRightRadians(Math.tan(this.waveTurnAngle));
                break;
            }
            case 0: {
                double myTurnAngle;
                if (Math.abs(this.getDistanceRemaining()) < 1.0) {
                    this.restartMove = true;
                }
                if (this.restartMove) {
                    this.distance = Math.sin(this.getTime() / 11L) * Math.cos(this.getTime() / 29L) * 270.0 + (Math.random() * 100.0 - 50.0);
                    this.direction = this.distance > 0.0 ? 1 : -1;
                    this.setAhead(this.distance);
                    this.jiggleOffset = Math.toRadians(Math.random() * 46.0 - 23.0);
                    myTurnAngle = Math.atan(Math.tan(this.normalRelativeAngle(this.target.bearing + 1.5707963267948966 + this.jiggleOffset)));
                    this.setTurnRightRadians(myTurnAngle);
                    this.restartMove = false;
                }
                this.myHeading = this.getHeadingRadians();
                this.mySpeed = this.getVelocity();
                this.myDistance = Math.abs(this.getDistanceRemaining());
                this.myCheckDistance = Math.min(120.0, this.myDistance) * (double)this.direction;
                this.posx = this.getX();
                this.posy = this.getY();
                this.myDeltaX = Math.sin(this.myHeading) * this.myCheckDistance;
                this.myDeltaY = Math.cos(this.myHeading) * this.myCheckDistance;
                this.newposx = this.posx + this.myDeltaX;
                this.newposy = this.posy + this.myDeltaY;
                if (!this.playField.contains(this.newposx, this.newposy)) {
                    myTurnAngle = Math.atan(Math.tan(this.calcAngleToWall()));
                    this.setTurnRightRadians(myTurnAngle);
                }
                if (!this.playField.contains(this.posx, this.posy)) {
                    this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 15.0 ? 2.0 : 8.0);
                    break;
                }
                this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 45.0 ? 4.0 : 8.0);
                break;
            }
            case 7: {
                double tmpbearing = 1.5707963267948966 - Math.atan2(this.target.shotY - this.target.myY, this.target.shotX - this.target.myX);
                double turnAngle = this.normalRelativeAngle(tmpbearing - this.getHeadingRadians());
                double myTurnAngle = Math.atan(Math.tan(turnAngle));
                this.setTurnRightRadians(myTurnAngle);
                this.setAhead(Double.POSITIVE_INFINITY * Math.cos(turnAngle));
                this.setMaxVelocity(8.0);
                break;
            }
            case 3: {
                if (this.getDistanceRemaining() == 0.0) {
                    this.setAhead((double)(125 * this.direction) * (Math.random() + 0.75));
                    this.direction *= -1;
                }
                this.right = this.target.bearing > 0.0 ? -1.0 : 1.0;
                this.setTurnRightRadians(this.target.bearing + (1.5707963267948966 + 0.5235987755982988 * (double)this.direction) * this.right);
                break;
            }
            case 2: {
                if (this.nextTime-- <= 0 && this.deltaEnergy > 0.0 && this.deltaEnergy <= 3.0) {
                    this.setMaxVelocity(2.0 + Math.random() * 20.0);
                    this.direction = Math.random() < 0.5 ? -1 : 1;
                    this.nextTime = 10;
                }
                this.setTurnRightRadians(this.target.bearing + 1.5707963267948966);
                this.setAhead(this.direction * 90);
                break;
            }
            case 8: {
                if ((double)this.getTime() - this.turnTime > (double)this.turnTimes) {
                    this.turnTime = this.getTime();
                    this.isRight = !this.isRight;
                    this.setMaxVelocity(2.0 + Math.random() * 15.0);
                }
                if (this.target.distance > 200.0) {
                    this.setTurnAndAheadValue(this.atackAngle);
                    break;
                }
                this.setTurnAndAheadValue(this.atackAngleR);
                break;
            }
            case 6: {
                if (this.getTime() % (long)this.circleTics == 0L || this.getDistanceRemaining() == 0.0) {
                    if (this.generator.nextInt(100) > 94) {
                        this.direction *= -1;
                    }
                    this.setAhead(this.direction * 400);
                    this.circleTics = 15 + this.generator.nextInt(10 + (int)this.target.distance / 50);
                    this.setMaxVelocity(2.0 + Math.random() * 15.0);
                }
                this.setTurnRightRadians(this.target.bearing + 1.5707963267948966);
                if (this.getTurnRemaining() != 0.0) break;
                if (this.generator.nextInt(100) > 50) {
                    this.setTurnRightRadians(this.target.bearing + 0.7853981633974483);
                    break;
                }
                this.setTurnRightRadians(this.target.bearing + Math.PI);
                break;
            }
            case 4: {
                double myHeading = this.getHeading();
                double newSpeed = 8.0;
                if (-1 == this.direction) {
                    myHeading = (myHeading + 180.0) % 360.0;
                }
                double posx = this.getX();
                double posy = this.getY();
                if (posx < 110.0 && myHeading > 180.0) {
                    newSpeed = 4.0;
                }
                if (posx > this.getBattleFieldWidth() - 110.0 && myHeading < 180.0) {
                    newSpeed = 4.0;
                }
                if (posy < 110.0 && myHeading > 90.0 && myHeading < 270.0) {
                    newSpeed = 4.0;
                }
                if (posy > this.getBattleFieldHeight() - 110.0 && (myHeading > 270.0 || myHeading < 90.0)) {
                    newSpeed = 4.0;
                }
                this.setMaxVelocity(newSpeed);
                if (!this.restartMove) break;
                this.setTurnRight(Double.POSITIVE_INFINITY);
                this.setAhead((double)this.direction * Double.POSITIVE_INFINITY);
                this.restartMove = false;
                break;
            }
            case 1: {
                if (this.getTime() % (long)this.circleTics == 0L || this.getDistanceRemaining() == 0.0) {
                    if (Math.random() > 0.5) {
                        this.direction *= -1;
                    }
                    this.setAhead(this.direction * 400);
                    this.circleTics = 15 + this.generator.nextInt(10 + (int)(this.target.distance / 35.0));
                    this.setMaxVelocity(2.0 + Math.random() * 10.0);
                }
                this.setTurnRightRadians(this.target.bearing + 1.5707963267948966);
                break;
            }
            case 10: {
                this.setMaxVelocity(8.0);
                if (this.contact_time + 100L >= this.getTime() && !(this.getDistanceRemaining() < 2.0)) break;
                this.movementStrategy = this.defaultStrategy;
                this.restartMove = true;
                this.setAhead(this.direction * 400);
                break;
            }
            case 11: {
                this.setMaxVelocity(8.0);
                if (this.getTime() % 10L == 0L) {
                    this.direction *= -1;
                    this.setAhead(this.direction * 400);
                }
                this.setTurnRightRadians(1.5707963267948966);
            }
        }
    }

    void doScanner() {
        double radarOffset;
        if (this.getTime() - this.target.ctime > 4L) {
            radarOffset = Math.PI * 4;
        } else {
            radarOffset = this.getRadarHeadingRadians() - (1.5707963267948966 - Math.atan2(this.target.y - this.getY(), this.target.x - this.getX()));
            radarOffset = (radarOffset = this.NormaliseBearing(radarOffset)) < 0.0 ? (radarOffset -= 0.15707963267948966) : (radarOffset += 0.15707963267948966);
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    double getGunOffset() {
        double tmpx = this.target.x;
        double tmpy = this.target.y;
        double myX = this.getX();
        double myY = this.getY();
        Point2D.Double p = new Point2D.Double(this.target.x, this.target.y);
        double head = this.target.head;
        long nextTime = 0L;
        do {
            ++nextTime;
            if (!this.fireField.contains(tmpx += Math.sin(head += this.target.changehead) * this.target.speed, tmpy += Math.cos(head) * this.target.speed)) {
                double bspeed = p.distance(myX, myY) / (double)nextTime;
                if (bspeed < 19.7) {
                    this.firePower = (20.0 - bspeed) / 3.0;
                    break;
                }
                if (p.distance(myX, myY) / 19.7 > (double)(nextTime + 5L)) {
                    this.firePower = 0.0;
                    break;
                }
                this.firePower = 0.2;
                break;
            }
            p.setLocation(tmpx, tmpy);
        } while ((long)((int)Math.round(p.distance(myX, myY) / (20.0 - 3.0 * this.firePower))) > nextTime);
        this.target.shotX = p.x;
        this.target.shotY = p.y;
        double gunOffset = this.getGunHeadingRadians() - (1.5707963267948966 - Math.atan2(p.y - this.getY(), p.x - this.getX()));
        return gunOffset;
    }

    void doGun() {
        double gunOffset = this.getGunOffset();
        int matchIndex = 0;
        int searchDepth = 30;
        double bspeed = 20.0 - 3.0 * this.firePower;
        while ((matchIndex = patternMatcher.lastIndexOf(patternMatcher.substring(historyIndex - --searchDepth), historyIndex - 102)) < 0) {
        }
        matchIndex += searchDepth;
        if (searchDepth > 0) {
            this.setTurnGunRightRadians(Math.sin((arcLength[matchIndex + (int)(this.target.distance / bspeed)] - arcLength[matchIndex]) / this.target.distance + this.target.targetBearing - this.getGunHeadingRadians()));
        } else {
            this.setTurnGunLeftRadians(this.NormaliseBearing(gunOffset));
        }
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
        double power = e.getBullet().getPower();
        double damage = Math.max(4.0 * power, 6.0 * power - 2.0);
        this.target.energy -= damage;
        int n = distanceindex;
        benefit[n] = benefit[n] + (damage + power * 3.0);
        ++totalHits;
        this.powerGained += power;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        this.target.energy += power * 3.0;
        int n = distanceindex;
        penalty[n] = penalty[n] + Math.max(power * 7.0, power * 9.0 - 2.0);
        this.atackMode = 1;
        this.powerLost += power;
        EnemyBulletBin wave = currentShot;
        if (wave != null) {
            wave.registerVisits(++enemyHits);
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (e.isMyFault()) {
            this.restartMove = true;
            this.direction = -this.direction;
        }
        this.atackMode = 0;
    }

    public void onHitWall(HitWallEvent e) {
        this.setMaxVelocity(8.0);
        if (this.movementStrategy < 10) {
            double b0 = this.getAngleToXYCoord(this.maxField, this.maxField);
            this.direction *= -1;
            double b1 = this.getAngleToXYCoord(this.maxField, this.maxField);
            if (Math.abs(b0) < Math.abs(b1)) {
                this.direction *= -1;
            }
            this.setTurnRightRadians(this.getAngleToXYCoord(this.maxField, this.maxField));
            this.setAhead(200 * this.direction);
            this.movementStrategy = 10;
            this.contact_time = this.getTime();
        }
    }

    void adjust_percent(double d) {
        double adj = moveGoodBad[this.defaultStrategy] * d;
        if (adj > 100.0) {
            adj = 100.0;
        }
        if (adj < -100.0) {
            adj = -100.0;
        }
        int n = this.defaultStrategy;
        percentMove[n] = percentMove[n] + adj;
        adj /= 9.0;
        for (int ndx2 = 0; ndx2 < 10; ++ndx2) {
            if (ndx2 == this.defaultStrategy) continue;
            int n2 = ndx2;
            percentMove[n2] = percentMove[n2] - adj;
        }
    }

    public void onWin(WinEvent e) {
        this.adjust_percent(1.0 * this.powerGained / (this.powerLost + 1.0));
        this.movementStrategy = 11;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.target.name != e.getName() && e.getDistance() < this.target.distance) {
            this.target.name = e.getName();
        }
        if (this.target.name == e.getName()) {
            double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            double h = this.NormaliseBearing(e.getHeadingRadians() - this.target.head);
            this.deltaEnergy = this.target.energy - e.getEnergy();
            this.target.deltaEnergy = this.target.energy - e.getEnergy();
            this.target.energy = e.getEnergy();
            this.target.deltaTime = this.getTime() - this.target.ctime;
            this.target.changehead = h /= (double)this.target.deltaTime;
            this.target.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
            this.target.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
            this.target.myX = this.getX();
            this.target.myY = this.getY();
            this.target.bearing = e.getBearingRadians();
            this.target.head = e.getHeadingRadians();
            this.target.ctime = this.getTime();
            historyIndex = patternMatcher.length();
            double targetBearing = e.getBearingRadians() + this.getHeadingRadians();
            double arcMovement = e.getVelocity() * Math.sin(e.getHeadingRadians() - targetBearing);
            AutoBot.arcLength[AutoBot.historyIndex + 1] = arcLength[historyIndex] + arcMovement;
            patternMatcher.append((char)arcMovement);
            this.target.targetBearing = targetBearing;
            this.target.speedDelta = this.target.speed - e.getVelocity();
            this.target.speed = e.getVelocity();
            this.target.distance = e.getDistance();
            this.target.timeToHit = this.target.distance / (20.0 - 3.0 * this.firePower);
            double absbearing = this.getHeadingRadians() + e.getBearingRadians();
            double latvel = Math.sin(e.getHeadingRadians() - absbearing) * lastv;
            distanceindex = (int)this.target.distance / 50;
            this.floodRel = 90;
            if (this.target.distance < (double)(this.findDistanceBracket() - 120)) {
                this.floodRel = 90 + this.direction * 30;
            }
            if (this.out(this.target.myX, this.target.myY, Math.PI + absbearing, 50.0) || this.target.distance > (double)this.findDistanceBracket() || this.getEnergy() / this.target.energy >= 7.0 || this.closeToCorner()) {
                this.floodRel = 90 - this.direction * 30;
            }
            if (hitTime < 0 && this.target.energy == 0.0) {
                this.floodRel = 90 - this.direction * 30 * 3;
            }
            this.enemyCalculation(e);
            this.totalScans += 1.0;
        }
    }

    void enemyCalculation(ScannedRobotEvent e) {
        BulletBin wave = new BulletBin();
        EnemyBulletBin ew = new EnemyBulletBin();
        ew.gunLocation = new Point2D.Double(enemyLocation.getX(), enemyLocation.getY());
        ew.startBearing = ew.gunBearing(robotLocation);
        if (this.target.deltaEnergy > 0.0 && this.target.deltaEnergy <= 3.0) {
            this.target.firePower = this.target.deltaEnergy;
            ew.dodgeThisScan = true;
            int n = distanceIndex;
            benefit[n] = benefit[n] + this.target.deltaEnergy;
        }
        ew.bulletVelocity = 20.0 - 3.0 * this.target.firePower;
        double direction = this.robotBearingDirection(ew.startBearing);
        ew.bearingDirection = Math.asin(8.0 / ew.bulletVelocity) * direction / 15.0;
        distanceIndex = (int)Math.min(4.0, enemyDistance / 160.0);
        int[][] nArray = moveFactors[distanceIndex][lastRobotVelocityIndex];
        lastRobotVelocityIndex = (int)Math.abs(robotVelocity / 2.0);
        ew.visits = nArray[lastRobotVelocityIndex];
        robotVelocity = this.getVelocity();
        ew.targetLocation = robotLocation;
        robotLocation.setLocation(new Point2D.Double(this.getX(), this.getY()));
        enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        wave.gunLocation = new Point2D.Double(this.getX(), this.getY());
        enemyLocation.setLocation(AutoBot.project(wave.gunLocation, enemyAbsoluteBearing, enemyDistance));
        wave.targetLocation = enemyLocation;
        enemyDistance = e.getDistance();
        ew.advance(2);
        this.addCustomEvent(ew);
        if (this.target.speedDelta != 0.0) {
            enemyTimeSinceVChange = 0;
        }
        wave.bulletVelocity = 20.0 - 3.0 * this.firePower;
        if (this.target.speed != 0.0) {
            enemyBearingDirection = 0.7 * (double)AutoBot.sign(this.target.speed * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        }
        wave.bearingDirection = enemyBearingDirection / 15.0;
        wave.startBearing = enemyAbsoluteBearing;
        int wallIndex = 0;
        while (++wallIndex < 4 && fieldRectangle.contains(AutoBot.project(wave.gunLocation, wave.startBearing + wave.bearingDirection * ((double)wallIndex * 5.5), enemyDistance))) {
        }
        int[][][][] nArray2 = gunFactors[distanceIndex][velocityIndex];
        velocityIndex = (int)Math.abs(this.target.speed / 2.0);
        wave.visits = nArray2[velocityIndex][(int)AutoBot.minMax(Math.pow(enemyTimeSinceVChange++, 0.45) - 1.0, 0.0, 5.0)][--wallIndex];
        this.addCustomEvent(wave);
        if (dangerReverse < dangerForward) {
            direction = -direction;
        }
        dangerReverse = 0.0;
        dangerForward = 0.0;
        this.waveTurnAngle = wave.gunBearing(AutoBot.wallSmoothedDestination(robotLocation, direction)) - this.getHeadingRadians();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.name) {
            this.target.distance = 100000.0;
        }
        this.debugPrint();
    }

    public void onDeath(DeathEvent e) {
        this.adjust_percent(-1.0 * this.powerLost / (this.powerGained + 1.0));
        this.debugPrint();
    }

    public void debugPrint() {
    }

    public double calcAngleToWall() {
        double di;
        double py = 0.0;
        double px = 0.0;
        double oldangle = this.normalRelativeAngle(this.getHeadingRadians());
        double kant = this.direction;
        for (di = 0.0; di < Math.PI && !this.playField.contains(px = this.posx + Math.sin(oldangle + di * kant) * this.myCheckDistance, py = this.posy + Math.cos(oldangle + di * kant) * this.myCheckDistance) && !this.playField.contains(px = this.posx + Math.sin(oldangle + di * (kant = -kant)) * this.myCheckDistance, py = this.posy + Math.cos(oldangle + di * kant) * this.myCheckDistance); di += 0.08726646259971647) {
            kant = -kant;
        }
        return di * kant;
    }

    private void setTurnAndAheadValue(double angle) {
        if (this.isRight) {
            this.tAngle = this.normalRelativeAngle(this.target.bearing - angle);
            if (this.tAngle > 1.5707963267948966 || this.tAngle < -1.5707963267948966) {
                this.direction = -1;
                this.setTurnLeftRadians(this.normalRelativeAngle(Math.PI - this.tAngle));
            } else {
                this.direction = 1;
                this.setTurnRightRadians(this.tAngle);
            }
        } else {
            this.tAngle = this.normalRelativeAngle(-this.target.bearing - angle);
            if (this.tAngle > 1.5707963267948966 || this.tAngle < -1.5707963267948966) {
                this.direction = -1;
                this.setTurnRightRadians(this.normalRelativeAngle(Math.PI - this.tAngle));
            } else {
                this.direction = 1;
                this.setTurnLeftRadians(this.tAngle);
            }
        }
        this.setAhead(100 * this.direction);
    }

    private boolean closeToCorner() {
        int i = 0;
        do {
            if (!(Point2D.distance(this.getX(), this.getY(), (double)(i & true) * this.getBattleFieldWidth(), (double)(i >> 1) * this.getBattleFieldHeight()) < 200.0)) continue;
            return true;
        } while (++i < 4);
        return false;
    }

    public int findDistanceBracket() {
        int bestindex = 4;
        int i = 4;
        do {
            if (!(this.findBenefit(i) > this.findBenefit(bestindex))) continue;
            bestindex = i;
        } while (++i <= 14);
        return bestindex * 50 + 85;
    }

    public double findBenefit(int index) {
        return (benefit[index] - penalty[index]) / (benefit[index] + penalty[index]);
    }

    public boolean out(double x, double y, double angle, double c) {
        return !new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0).contains(Math.sin(angle) * c + x, Math.cos(angle) * c + y);
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * 2.0, this.getBattleFieldHeight() - margin * 2.0, 75.0, 75.0);
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    static double absoluteBearing(double sx, double sy, double tx, double ty) {
        return Math.atan2(tx - sx, ty - sy);
    }

    double NormaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double normalRelativeAngle(double angle) {
        double mod = angle % (Math.PI * 2);
        if (mod <= -Math.PI) {
            return Math.PI + mod % Math.PI;
        }
        if (mod > Math.PI) {
            return -Math.PI + mod % Math.PI;
        }
        return mod;
    }

    public double normalAbsoluteAngle(double in_angle) {
        if (in_angle < 0.0) {
            return Math.PI * 2 + in_angle % (Math.PI * 2);
        }
        if (in_angle >= Math.PI * 2) {
            return in_angle % (Math.PI * 2);
        }
        return in_angle;
    }

    public double normalAbsoluteAngleRadians(double in_angle) {
        double wholeCircle = Math.PI * 2;
        if (in_angle < 0.0) {
            return wholeCircle + in_angle % wholeCircle;
        }
        if (in_angle >= wholeCircle) {
            return in_angle % wholeCircle;
        }
        return in_angle;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double getAngleToXYCoord(double in_x, double in_y) {
        return this.getAngleToXYCoord(this.getX(), this.getY(), this.getHeadingRadians(), in_x, in_y, this.direction);
    }

    public double getAngleToXYCoord(double tankX, double tankY, double headingRadians, double in_x, double in_y, int dir) {
        double theta = -1.0;
        double currentX = tankX;
        double currentY = tankY;
        theta = Math.atan(Math.abs(currentX - in_x) / Math.abs(currentY - in_y));
        if (currentX >= in_x && currentY >= in_y) {
            theta = Math.PI + theta;
        } else if (currentX >= in_x && currentY < in_y) {
            theta = Math.PI * 2 - theta;
        } else if (currentX < in_x && currentY >= in_y) {
            theta = Math.PI - theta;
        } else if (!(currentX < in_x) || currentY < in_y) {
            // empty if block
        }
        if (dir == -1) {
            return this.normalRelativeAngle(theta - this.normalAbsoluteAngle(headingRadians + Math.PI));
        }
        return this.normalRelativeAngle(theta - headingRadians);
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return AutoBot.vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }

    static Point2D wallSmoothedDestination(Point2D location, double direction) {
        Point2D destination;
        double smoothing;
        int i = 1;
        do {
            for (smoothing = 0.0; !fieldRectangle.contains(destination = AutoBot.project(location, AutoBot.absoluteBearing(location, enemyLocation) - direction * ((1.25 - smoothing / 100.0) * Math.PI / 2.0), 135.0)) && smoothing < 150.0; smoothing += 1.0) {
            }
            direction = -direction;
        } while (i-- > 0 && distanceIndex < 1 && smoothing > 27.0);
        return destination;
    }

    void updateDirectionStats(EnemyBulletBin wave) {
        dangerReverse += wave.danger(this.waveImpactLocation(wave, -1.0, 5.0));
        dangerForward += wave.danger(this.waveImpactLocation(wave, 1.0, 0.0));
    }

    Point2D waveImpactLocation(EnemyBulletBin wave, double direction, double timeOffset) {
        Point2D impactLocation = new Point2D.Double(this.getX(), this.getY());
        double time = timeOffset;
        while (wave.distanceFromTarget(impactLocation = AutoBot.project(impactLocation, AutoBot.absoluteBearing(impactLocation, AutoBot.wallSmoothedDestination(impactLocation, direction * this.robotBearingDirection(wave.gunBearing(robotLocation)))), 8.0), (int)(time += 1.0)) > -10.0) {
        }
        return impactLocation;
    }

    double robotBearingDirection(double enemyBearing) {
        return AutoBot.sign(this.getVelocity() * Math.sin(this.getHeadingRadians() - enemyBearing));
    }

    static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
    }

    static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    static double minMax(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }

    static {
        tWidth = 18.5;
        percentMove = new double[10];
        moveGoodBad = new double[10];
        roundNumber = 0;
        robotLocation = new Point2D.Double();
        enemyLocation = new Point2D.Double();
        lastv = 0.0;
        benefit = new double[26];
        penalty = new double[26];
        arcLength = new double[100000];
        historyIndex = 0;
        patternMatcher = new StringBuffer("\u0000\u0003\u0006\u0001\u0004\u0007\u0002\u0005\b\uffff\ufffc\ufff9\ufffe\ufffb\ufff8\ufffd\ufffaThis space filler for end buffer.The numbers up top assure a 1 length match every time.  This string must be longer than SEARCH_END_BUFFER. - Mike Dorgan");
        totalShots = 0L;
        totalHits = 0L;
    }

    class EnemyBulletBin
    extends BulletBin {
        boolean dodgeThisScan;

        EnemyBulletBin() {
        }

        public boolean test() {
            this.advance(1);
            if (this.passed(-18.0)) {
                this.dodgeThisScan = false;
                currentShot = this;
            }
            if (this.passed(18.0)) {
                AutoBot.this.removeCustomEvent(this);
            }
            if (this.dodgeThisScan) {
                AutoBot.this.updateDirectionStats(this);
            }
            return false;
        }

        double danger(Point2D destination) {
            double smoothed = 0.0;
            int i = 0;
            do {
                smoothed += ((double)locationBins[i] + (double)this.visits[i] * 200.0) / Math.sqrt((double)Math.abs(this.visitingIndex(destination) - i) + 1.0);
            } while (++i < 31);
            return smoothed / Math.sqrt(Math.abs(this.distanceFromTarget(this.targetLocation, 0)) / this.bulletVelocity);
        }
    }

    class BulletBin
    extends Condition {
        double bulletVelocity;
        Point2D gunLocation;
        Point2D targetLocation;
        double startBearing;
        double bearingDirection;
        int[] visits;
        double distanceFromGun;

        BulletBin() {
        }

        public boolean test() {
            this.advance(1);
            if (this.passed(-18.0)) {
                if (AutoBot.this.getOthers() > 0) {
                    this.registerVisits(1);
                }
                AutoBot.this.removeCustomEvent(this);
            }
            return false;
        }

        public boolean passed(double distanceOffset) {
            return this.distanceFromGun > this.gunLocation.distance(this.targetLocation) + distanceOffset;
        }

        void advance(int ticks) {
            this.distanceFromGun += (double)ticks * this.bulletVelocity;
        }

        int visitingIndex(Point2D target) {
            return (int)AutoBot.minMax(Math.round(Utils.normalRelativeAngle((double)(this.gunBearing(target) - this.startBearing)) / this.bearingDirection + 15.0), 0.0, 30.0);
        }

        void registerVisits(int count) {
            int index;
            int n = index = this.visitingIndex(this.targetLocation);
            this.visits[n] = this.visits[n] + count;
            int n2 = index;
            locationBins[n2] = locationBins[n2] + count;
        }

        double gunBearing(Point2D target) {
            return AutoBot.absoluteBearing(this.gunLocation, target);
        }

        double distanceFromTarget(Point2D location, int timeOffset) {
            return this.gunLocation.distance(location) - this.distanceFromGun - (double)timeOffset * this.bulletVelocity;
        }

        int mostVisited() {
            int mostVisited = 15;
            int i = 30;
            do {
                if (this.visits[--i] <= this.visits[mostVisited]) continue;
                mostVisited = i;
            } while (i > 0);
            return mostVisited;
        }
    }

    class Enemy {
        String name;
        public double energy = 100.0;
        public double targetBearing;
        public double deltaEnergy;
        public double bearing;
        public double head;
        public long ctime;
        public long deltaTime;
        public double speed;
        public double x;
        public double y;
        public double myX;
        public double myY;
        public double shotX;
        public double shotY;
        public double distance;
        public double changehead;
        public double timeToHit;
        public double firePower;
        public double speedDelta;

        Enemy() {
        }
    }
}

