/*
 * Decompiled with CFR 0.152.
 */
package learn;

import java.util.ArrayList;
import java.util.List;
import learn.Neuron;

class Net {
    private ArrayList<Neuron> Layer = new ArrayList();
    private List<ArrayList<Neuron>> m_Layers = new ArrayList<ArrayList<Neuron>>();
    private double m_error;
    private double m_recentAverageError;
    private double m_recentAverageSmoothingFactor;

    Net(List<Integer> topology) {
        int numLayers = topology.size();
        int layerNum = 0;
        while (layerNum < numLayers) {
            this.m_Layers.add(new ArrayList());
            int numOutputs = layerNum == topology.size() - 1 ? 0 : topology.get(layerNum + 1);
            int neuronNum = 0;
            while (neuronNum <= topology.get(layerNum)) {
                Neuron newNeuron = new Neuron(numOutputs, neuronNum);
                this.m_Layers.get(this.m_Layers.size() - 1).add(newNeuron);
                System.out.println("made a neuron!");
                ++neuronNum;
            }
            this.m_Layers.get(layerNum).get(topology.get(layerNum)).setOutputVal(1.0);
            ++layerNum;
        }
    }

    public void feedForward(List<Double> inputVals) {
        assert (inputVals.size() == this.m_Layers.get(0).size() - 1);
        int i = 0;
        while (i < inputVals.size()) {
            this.m_Layers.get(0).get(i).setOutputVal(inputVals.get(i));
            ++i;
        }
        int layerNum = 1;
        while (layerNum < this.m_Layers.size()) {
            List prevLayer = this.m_Layers.get(layerNum - 1);
            int n = 0;
            while (n < this.m_Layers.get(layerNum).size() - 1) {
                this.m_Layers.get(layerNum).get(n).feedForward(prevLayer);
                ++n;
            }
            ++layerNum;
        }
    }

    public void backProp(List<Double> targetVals) {
        int n;
        List outputLayer = this.m_Layers.get(this.m_Layers.size() - 1);
        this.m_error = 0.0;
        int n2 = 0;
        while (n2 < outputLayer.size() - 1) {
            double delta = targetVals.get(n2) - ((Neuron)outputLayer.get(n2)).getOutputVal();
            this.m_error += delta * delta;
            ++n2;
        }
        this.m_error /= (double)(outputLayer.size() - 1);
        this.m_error = Math.sqrt(this.m_error);
        this.m_recentAverageError = (this.m_recentAverageError * this.m_recentAverageSmoothingFactor + this.m_error) / (this.m_recentAverageSmoothingFactor + 1.0);
        n2 = 0;
        while (n2 < outputLayer.size() - 1) {
            ((Neuron)outputLayer.get(n2)).calcOutputGradients(targetVals.get(n2));
            ++n2;
        }
        int layerNum = this.m_Layers.size() - 2;
        while (layerNum > 0) {
            List hiddenLayer = this.m_Layers.get(layerNum);
            List nextLayer = this.m_Layers.get(layerNum + 1);
            n = 0;
            while (n < hiddenLayer.size()) {
                ((Neuron)hiddenLayer.get(n)).calcHiddenGradients(nextLayer);
                ++n;
            }
            --layerNum;
        }
        layerNum = this.m_Layers.size() - 1;
        while (layerNum > 0) {
            List layer = this.m_Layers.get(layerNum);
            List prevLayer = this.m_Layers.get(layerNum - 1);
            n = 0;
            while (n < layer.size() - 1) {
                ((Neuron)layer.get(n)).updateInputWeights(prevLayer);
                ++n;
            }
            --layerNum;
        }
    }

    public final void getResults(List<Double> resultVals) {
        resultVals.clear();
        int n = 0;
        while (n < this.m_Layers.get(this.m_Layers.size() - 1).size() - 1) {
            resultVals.add(this.m_Layers.get(this.m_Layers.size() - 1).get(n).getOutputVal());
            ++n;
        }
    }
}

