/*
 * Decompiled with CFR 0.152.
 */
package tkt.util;

import java.awt.geom.Point2D;
import robocode.Robot;
import robocode.ScannedRobotEvent;

public class RobotInfo {
    public double energy = -1.0;
    public double x;
    public double y;
    public double absoluteBearing;
    public boolean justFired;
    public int shotsFired;
    public int shotsHit;

    public RobotInfo(Robot robot, ScannedRobotEvent event) {
        this.updateInfo(robot, event);
    }

    public final void updateInfo(Robot robot, ScannedRobotEvent event) {
        double previousEnergy = this.energy;
        this.energy = event.getEnergy();
        this.absoluteBearing = robot.getHeading() + event.getBearing();
        this.absoluteBearing = Math.toRadians(this.absoluteBearing);
        double targetX = robot.getX() + Math.sin(this.absoluteBearing) * event.getDistance();
        double targetY = robot.getY() + Math.cos(this.absoluteBearing) * event.getDistance();
        Point2D.Double position = new Point2D.Double(targetX, targetY);
        this.x = position.getX();
        this.y = position.getY();
        double energyChange = previousEnergy - this.energy;
        if (energyChange >= 0.1 && energyChange <= 3.0) {
            this.justFired = true;
            ++this.shotsFired;
        } else {
            this.justFired = false;
        }
    }

    public double getAccuracy() {
        return (double)this.shotsHit / (double)(this.shotsFired + this.shotsHit);
    }
}

