/*
 * Decompiled with CFR 0.152.
 */
package nosteel.Modules.Data;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import nosteel.Basics.Vector;
import nosteel.Modules.Data.FiredBullet;
import nosteel.Modules.Data.ScanData;
import robocode.Bullet;
import robocode.ScannedRobotEvent;

public class EnemyData {
    public static boolean FRONT_OF_LIST = true;
    public static boolean END_OF_LIST = false;
    private String name = "";
    private boolean detected = false;
    private boolean alive = false;
    private List<ScanData> scans = new ArrayList<ScanData>();
    private List<FiredBullet> fired = new ArrayList<FiredBullet>();

    public void enemyDetected(String name_) {
        this.name = name_;
        this.detected = true;
        this.alive = true;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnemy(String name_) {
        return this.name.equals(name_);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public boolean isDetected() {
        return this.detected;
    }

    public void setDead() {
        this.alive = false;
    }

    public void addScan(ScannedRobotEvent event, Vector myPos, double myHeadingRad, long time) {
        this.scans.add(new ScanData(event, myPos, myHeadingRad, time));
    }

    public ListIterator<ScanData> getScanIterator(boolean pos) {
        return this.scans.listIterator(pos == FRONT_OF_LIST ? 0 : this.scans.size());
    }

    public ListIterator<ScanData> getScanIterator(int index) {
        return this.scans.listIterator(index);
    }

    public ScanData getLastScan() {
        if (this.scans.isEmpty()) {
            return null;
        }
        return this.scans.get(this.scans.size() - 1);
    }

    public ScanData getScanByIndex(int index) {
        if (this.scans.isEmpty()) {
            return null;
        }
        if (this.scans.size() <= index) {
            return null;
        }
        return this.scans.get(index);
    }

    public int getNumOfScans() {
        return this.scans.size();
    }

    public void drawScans(Graphics2D g) {
        for (ScanData s : this.scans) {
            s.drawScan(g);
        }
    }

    public void addBullet(FiredBullet e) {
        e.hitAnotherTarget = false;
        e.hitTheTarget = false;
        e.isOnTheWay = true;
        this.fired.add(e);
    }

    public FiredBullet getFiredBullet(Bullet b) {
        FiredBullet found = null;
        Iterator<FiredBullet> iterator = this.fired.iterator();
        while (iterator.hasNext()) {
            FiredBullet fb;
            found = fb = iterator.next();
        }
        return found;
    }

    public ListIterator<FiredBullet> getFiredBulletIterator() {
        return this.fired.listIterator();
    }
}

