/*
 * Decompiled with CFR 0.152.
 */
package spinnercat;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.TurnCompleteCondition;
import robocode.util.Utils;
import spinnercat.EnemyBot;
import spinnercat.Wave;

public class Robovirus
extends AdvancedRobot {
    public static int BINS = 47;
    public static int distFactors = 10;
    public static double[] dangerValues = new double[BINS];
    public Point2D.Double myLocation;
    public Point2D.Double enemyLocation;
    public ArrayList enemyWaves;
    public ArrayList surfDirections;
    public ArrayList surfAbsBearings;
    public static double oppEnergy = 100.0;
    public int moveDir = 100;
    public int scanDir = 1;
    public double moveAngle;
    public int fieldCols;
    public int fieldRows;
    public double[] zoneDanger;
    public static Rectangle2D.Double field;
    public static double WALL_STICK;
    private Hashtable targets = new Hashtable();
    private RobotPart[] parts = new RobotPart[3];
    private static String pattern;
    private static final int RADAR = 0;
    private static final int GUN = 1;
    private static final int TANK = 2;
    private static EnemyBot enemy;
    private EnemyBot curEn = new EnemyBot();
    int counter = 0;
    double absoluteBearing;
    private int direction = 1;
    private static ArrayList<Wave> waves;
    public static int[][] guessFactorStats;
    public static Gun[] virtualGunArray;
    public int activeGunIndex;

    static {
        WALL_STICK = 160.0;
        pattern = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\uffff\ufffe\ufffd\ufffc\ufffb\ufffa\ufff9\ufff8\ufffa\ufffc\ufffe\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u0006\u0004\u0002\u0000";
        enemy = new EnemyBot();
        waves = new ArrayList();
        guessFactorStats = new int[13][31];
        virtualGunArray = new Gun[4];
    }

    public void run() {
        Robovirus.virtualGunArray[0] = new HOGun();
        Robovirus.virtualGunArray[1] = new LTGun();
        Robovirus.virtualGunArray[2] = new GFGun();
        this.enemyWaves = new ArrayList();
        this.surfDirections = new ArrayList();
        this.surfAbsBearings = new ArrayList();
        field = new Rectangle2D.Double(18.0, 18.0, this.getBattleFieldWidth() - 36.0, this.getBattleFieldHeight() - 36.0);
        Random r = new Random();
        this.setColors(new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256)), new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256)), new Color(r.nextInt(256), r.nextInt(256), r.nextInt(256)));
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setBulletColor(new Color(255, 255, 255));
        if (this.getOthers() > 1) {
            this.parts[0] = new MeleeRadar();
            this.parts[1] = new MeleeGun();
            this.parts[2] = new MeleeTank();
        } else {
            this.parts[0] = new Radar();
            this.parts[1] = new GFGun();
            this.activeGunIndex = 3;
            this.parts[2] = new Tank();
        }
        int i = 0;
        while (i < this.parts.length) {
            this.parts[i].init();
            ++i;
        }
        i = 0;
        while (true) {
            this.parts[i].move();
            if (i == 0) {
                this.execute();
            }
            i = (i + 1) % this.parts.length;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (this.targets.contains(e.getName())) {
            this.targets.remove(e.getName());
        }
        if (this.curEn.getName().equals(e.getName())) {
            this.curEn = new EnemyBot();
            this.curEn.setDistance(10000.0);
        }
        if (this.getOthers() > 1 || this.getOthers() == 0) {
            return;
        }
        this.parts[1] = new GFGun();
        this.parts[2] = new Tank();
        this.parts[0] = new Radar();
        Enumeration enu = this.targets.elements();
        EnemyBot cur = new EnemyBot();
        while (enu.hasMoreElements()) {
            cur = (EnemyBot)enu.nextElement();
            if (cur.energy > 0.0) break;
        }
        if (enemy.getName() == null) {
            return;
        }
        if (!enemy.getName().equals(cur.getName())) {
            guessFactorStats = new int[13][31];
            enemy = cur;
            dangerValues = new double[BINS];
        }
    }

    public void setTurnGunRightRadians(double d) {
        super.setTurnGunRightRadians(d);
    }

    public void pickGun() {
        double max = 0.0;
        int maxIndex = this.activeGunIndex;
        int i = 0;
        while (i < 4) {
            if (Robovirus.virtualGunArray[i].percent > max) {
                maxIndex = i;
                max = Robovirus.virtualGunArray[i].percent;
            }
            ++i;
        }
        this.out.println(maxIndex);
        switch (maxIndex) {
            case 0: {
                this.parts[1] = new HOGun();
                break;
            }
            case 1: {
                this.parts[1] = new LTGun();
                break;
            }
            case 2: {
                this.parts[1] = new GFGun();
                break;
            }
            case 3: {
                this.parts[1] = new PMGun();
                break;
            }
            default: {
                this.parts[1] = new GFGun();
            }
        }
        this.out.println("set new gun");
    }

    public void setFire(double power) {
        if (this.getEnergy() < 3.1) {
            return;
        }
        if (super.setFireBullet(power) == null) {
            return;
        }
    }

    public Bullet setFireBullet(double power) {
        if (this.getEnergy() < 3.1) {
            return null;
        }
        Bullet b = super.setFireBullet(power);
        if (b == null) {
            return null;
        }
        return b;
    }

    public void fireVirtuals() {
        this.out.println("Firing Virtuals");
        int i = 0;
        while (i < virtualGunArray.length) {
            virtualGunArray[i].moveVirtual();
            ++i;
        }
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        int i = 0;
        while (i < 100) {
            pattern = pattern.substring(10);
            ++i;
        }
        this.out.println("Turn Skipped!");
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        EnemyBot en;
        double absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
        if (this.getOthers() == 1) {
            this.myLocation = new Point2D.Double(this.getX(), this.getY());
            double lateralV = this.getVelocity() * Math.sin(e.getBearingRadians());
            double absBearing = e.getBearingRadians() + this.getHeadingRadians();
            this.surfDirections.add(0, new Integer(lateralV >= 0.0 ? 1 : -1));
            this.surfAbsBearings.add(0, new Double(absBearing + Math.PI));
            double bulletPower = oppEnergy - e.getEnergy();
            if (bulletPower < 3.01 && bulletPower > 0.09 && this.surfDirections.size() > 2) {
                EnemyWave ew = new EnemyWave();
                ew.fireTime = this.getTime() - 1L;
                ew.bulletVelocity = Robovirus.bulletVelocity(bulletPower);
                ew.distanceTraveled = Robovirus.bulletVelocity(bulletPower);
                ew.direction1 = (Integer)this.surfDirections.get(2);
                ew.directAngle = (Double)this.surfAbsBearings.get(2);
                ew.fireLocation = new Point2D.Double(Robovirus.enemy.x, Robovirus.enemy.y);
                this.enemyWaves.add(ew);
            }
            oppEnergy = e.getEnergy();
            this.updateWaves();
            this.doSurfing();
            enemy.update(e, (Robot)this);
            double lateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - e.getBearing() - this.getHeadingRadians());
            pattern = String.valueOf((char)lateralVelocity).concat(pattern);
            absoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
            double radarTurn = Utils.normalRelativeAngle((double)(absoluteBearing - this.getRadarHeadingRadians()));
            double arcToScan = Math.min(Math.atan(36.0 / e.getDistance()), 0.7853981633974483);
            radarTurn = radarTurn < 0.0 ? (radarTurn += -arcToScan) : (radarTurn += arcToScan);
            this.setTurnRadarRightRadians(radarTurn);
            return;
        }
        if (this.targets.containsKey(e.getName())) {
            en = (EnemyBot)this.targets.get(e.getName());
        } else {
            en = new EnemyBot();
            this.targets.put(e.getName(), en);
        }
        en.update(e, (Robot)this);
        if (en.distance < this.curEn.distance - 100.0) {
            this.curEn = en;
        }
    }

    public void updateWaves() {
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
            ew.distanceTraveled = (double)(this.getTime() - ew.fireTime) * ew.bulletVelocity;
            if (ew.distanceTraveled > this.myLocation.distance(ew.fireLocation) + 50.0) {
                this.enemyWaves.remove(x);
                --x;
            }
            ++x;
        }
    }

    public EnemyWave getClosestSurfableWave() {
        double closestDistance = 50000.0;
        EnemyWave surfWave = null;
        int x = 0;
        while (x < this.enemyWaves.size()) {
            EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
            double distance = this.myLocation.distance(ew.fireLocation) - ew.distanceTraveled;
            if (distance > ew.bulletVelocity + 5.0 && distance < closestDistance) {
                surfWave = ew;
                closestDistance = distance;
            }
            ++x;
        }
        return surfWave;
    }

    public static int getFactorIndex(EnemyWave ew, Point2D.Double targetLocation) {
        double offsetAngle = Robovirus.absoluteBearing(ew.fireLocation, targetLocation) - ew.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / Robovirus.maxEscapeAngle(ew.bulletVelocity) * (double)ew.direction1;
        return (int)Robovirus.limit(0.0, factor * (double)((BINS - 1) / 2) + (double)((BINS - 1) / 2), BINS - 1);
    }

    public void logHit(EnemyWave ew, Point2D.Double targetLocation) {
        int index = Robovirus.getFactorIndex(ew, targetLocation);
        int d = (int)Robovirus.enemy.distance / 10;
        int x = 0;
        while (x < BINS) {
            int n = x;
            dangerValues[n] = dangerValues[n] + 1.0 / (Math.pow(index - x, 2.0) + 1.0);
            ++x;
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double hitBulletLocation = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this.enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - this.myLocation.distance(ew.fireLocation)) < 50.0 && Math.round(Robovirus.bulletVelocity(e.getBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, hitBulletLocation);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        if (!this.enemyWaves.isEmpty()) {
            Point2D.Double blastPoint = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
            EnemyWave hitWave = null;
            int x = 0;
            while (x < this.enemyWaves.size()) {
                EnemyWave ew = (EnemyWave)this.enemyWaves.get(x);
                if (Math.abs(ew.distanceTraveled - blastPoint.distance(ew.fireLocation)) < 50.0 && Math.round(Robovirus.bulletVelocity(e.getHitBullet().getPower()) * 10.0) == Math.round(ew.bulletVelocity * 10.0)) {
                    hitWave = ew;
                    break;
                }
                ++x;
            }
            if (hitWave != null) {
                this.logHit(hitWave, blastPoint);
                this.enemyWaves.remove(this.enemyWaves.lastIndexOf(hitWave));
            }
        }
    }

    public Point2D.Double predictPosition(EnemyWave surfWave, int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)this.myLocation.clone();
        double predictedVelocity = this.getVelocity();
        double predictedHeading = this.getHeadingRadians();
        int counter = 0;
        boolean intercepted = false;
        do {
            double moveAngle = this.wallSmoothing(predictedPosition, Robovirus.absoluteBearing(surfWave.fireLocation, predictedPosition) + (double)direction * 1.5707963267948966, direction) - predictedHeading;
            double moveDir = 1.0;
            if (Math.cos(moveAngle) < 0.0) {
                moveAngle += Math.PI;
                moveDir = -1.0;
            }
            moveAngle = Utils.normalRelativeAngle((double)moveAngle);
            double maxTurning = 0.004363323129985824 * (40.0 - 3.0 * Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle((double)(predictedHeading + Robovirus.limit(-maxTurning, moveAngle, maxTurning)));
            predictedVelocity += predictedVelocity * moveDir < 0.0 ? 2.0 * moveDir : moveDir;
            predictedVelocity = Robovirus.limit(-8.0, predictedVelocity, 8.0);
            predictedPosition = Robovirus.project(predictedPosition, predictedHeading, predictedVelocity);
            ++counter;
            if (!(predictedPosition.distance(surfWave.fireLocation) < surfWave.distanceTraveled + (double)counter * surfWave.bulletVelocity + surfWave.bulletVelocity)) continue;
            intercepted = true;
        } while (!intercepted && counter < 500);
        return predictedPosition;
    }

    public double checkDanger(EnemyWave surfWave, int direction) {
        int index = Robovirus.getFactorIndex(surfWave, this.predictPosition(surfWave, direction));
        return dangerValues[index];
    }

    public void doSurfing() {
        EnemyWave surfWave = this.getClosestSurfableWave();
        if (surfWave == null) {
            return;
        }
        double dangerLeft = this.checkDanger(surfWave, -1);
        double dangerRight = this.checkDanger(surfWave, 1);
        double goAngle = Robovirus.absoluteBearing(surfWave.fireLocation, this.myLocation);
        goAngle = dangerLeft < dangerRight ? this.wallSmoothing(this.myLocation, goAngle - (Robovirus.enemy.energy > this.getEnergy() + 5.0 ? 1.4 : 1.6), -1) : this.wallSmoothing(this.myLocation, goAngle + (Robovirus.enemy.energy > this.getEnergy() + 5.0 ? 1.4 : 1.6), 1);
        Robovirus.setBackAsFront(this, goAngle);
    }

    public double wallSmoothing(Point2D.Double p, double startAngle, int orientation) {
        double angle = startAngle;
        double x = p.x;
        double y = p.y;
        double testX = x + Math.sin(angle += Math.PI * 4) * WALL_STICK;
        double testY = y + Math.cos(angle) * WALL_STICK;
        double wallDistanceX = Math.min(x - 18.0, this.getBattleFieldWidth() - x - 18.0);
        double wallDistanceY = Math.min(y - 18.0, this.getBattleFieldHeight() - y - 18.0);
        double testDistanceX = Math.min(testX - 18.0, this.getBattleFieldWidth() - testX - 18.0);
        double testDistanceY = Math.min(testY - 18.0, this.getBattleFieldHeight() - testY - 18.0);
        double adjacent = 0.0;
        int g = 0;
        while (!field.contains(testX, testY) && g++ < 25) {
            if (testDistanceY < 0.0 && testDistanceY < testDistanceX) {
                angle = (double)((int)((angle + 1.5707963267948966) / Math.PI)) * Math.PI;
                adjacent = Math.abs(wallDistanceY);
            } else if (testDistanceX < 0.0 && testDistanceX <= testDistanceY) {
                angle = (double)((int)(angle / Math.PI)) * Math.PI + 1.5707963267948966;
                adjacent = Math.abs(wallDistanceX);
            }
            testX = x + Math.sin(angle += (double)orientation * (Math.abs(Math.acos(adjacent / WALL_STICK)) + 0.005)) * WALL_STICK;
            testY = y + Math.cos(angle) * WALL_STICK;
            testDistanceX = Math.min(testX - 18.0, this.getBattleFieldWidth() - testX - 18.0);
            testDistanceY = Math.min(testY - 18.0, this.getBattleFieldHeight() - testY - 18.0);
        }
        return angle;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public double getRisk(Point2D.Double point) {
        if (!new Rectangle2D.Double(36.0, 36.0, this.getBattleFieldWidth() - 72.0, this.getBattleFieldHeight() - 72.0).contains(point)) {
            return Double.POSITIVE_INFINITY;
        }
        double risk = 0.0;
        Enumeration e = this.targets.elements();
        while (e.hasMoreElements()) {
            EnemyBot en = (EnemyBot)e.nextElement();
            double dist = Point2D.distance(en.getX(), en.getY(), point.x, point.y);
            risk += (200.0 + 4.0 * en.getEnergy()) / (dist * dist);
        }
        return risk;
    }

    public Point2D.Double findSafePoint() {
        Point2D.Double safePoint = new Point2D.Double(0.0, 0.0);
        double lowRisk = Double.POSITIVE_INFINITY;
        int i = (int)this.getX() - 10;
        while ((double)i < this.getX() + 11.0) {
            int j = (int)this.getY() - 10;
            while ((double)j < this.getY() + 11.0) {
                double risk;
                if (field.contains(new Point2D.Double(i, j)) && (risk = this.getRisk(new Point2D.Double(i, j))) < lowRisk) {
                    lowRisk = risk;
                    safePoint = new Point2D.Double(i, j);
                }
                j += 5;
            }
            i += 5;
        }
        return safePoint;
    }

    public void moveTo(Point2D.Double p) {
        double distance = p.distance(new Point2D.Double(this.getX(), this.getY()));
        double dx = p.x - this.getX();
        double dy = p.y - this.getY();
        double absAngle = Math.toDegrees(Math.atan(dy / dx));
        if (dx < 0.0) {
            absAngle -= 180.0;
        }
        absAngle = 90.0 - absAngle;
        this.setTurnRightRadians(Utils.normalRelativeAngle((double)Math.toRadians(absAngle - this.getHeading())));
        this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)this));
        if (this.getTurnRemaining() < 5.0) {
            this.setAhead(distance);
        }
    }

    public double angleTo(double x, double y) {
        return 1.5707963267948966 - Math.atan2(y - this.getY(), x - this.getX());
    }

    class EnemyWave {
        Point2D.Double fireLocation;
        long fireTime;
        double bulletVelocity;
        double directAngle;
        double distanceTraveled;
        int direction1;
    }

    private class GFGun
    extends Gun
    implements RobotPart {
        private GFGun() {
        }

        public void init() {
        }

        public void update() {
            this.index = 2;
            if (enemy.energy == 0.0) {
                this.bearing = enemy.getBearingRadians() + Robovirus.this.getHeadingRadians();
                this.firepower = 0.8;
                return;
            }
            this.firepower = enemy.energy > Robovirus.this.getEnergy() + 20.0 && Robovirus.this.getEnergy() < 20.0 ? (Robovirus.this.getTime() % 3L == 0L ? 1.1 : 0.0) : (enemy.energy > Robovirus.this.getEnergy() && Robovirus.this.getEnergy() < 30.0 ? (Robovirus.this.getTime() % 2L == 0L ? 2.0 : 0.0) : Math.min(enemy.energy / 4.0, 3.0));
            int[] currentStats = guessFactorStats[(int)(enemy.getDistance() / 100.0)];
            double absBearing = Utils.normalRelativeAngle((double)(Robovirus.this.getHeadingRadians() + enemy.getBearingRadians()));
            if (enemy.getVelocity() != 0.0) {
                if (Math.sin(Math.toRadians(enemy.getHeading()) - absBearing) * enemy.getVelocity() < 0.0) {
                    Robovirus.this.direction = -1;
                } else {
                    Robovirus.this.direction = 1;
                }
            }
            Wave newWave = new Wave(Robovirus.this.getX(), Robovirus.this.getY(), absBearing, 3.0, Robovirus.this.getTime(), Robovirus.this.direction, currentStats);
            int bestindex = 15;
            int i = 0;
            while (i < waves.size()) {
                Wave currentWave = (Wave)waves.get(i);
                if (currentWave.checkHit(enemy.getX(), enemy.getY(), Robovirus.this.getTime())) {
                    waves.remove(currentWave);
                    --i;
                }
                ++i;
            }
            i = 0;
            while (i < currentStats.length) {
                if (currentStats[bestindex] < currentStats[i]) {
                    bestindex = i;
                }
                ++i;
            }
            double guessfactor = (double)(bestindex * 2) / (double)(currentStats.length - 1) - 1.0;
            double angleOffset = guessfactor / (double)Robovirus.this.direction * newWave.maxEscapeAngle();
            this.bearing = Utils.normalRelativeAngle((double)(absBearing + angleOffset));
            waves.add(newWave);
        }
    }

    abstract class Gun
    implements RobotPart {
        int hits;
        int miss;
        int index;
        double percent;
        double bearing;
        double firepower;

        Gun() {
        }

        public void moveVirtual() {
            this.update();
            Robovirus.this.addCustomEvent(new VGun(Robovirus.this.myLocation, this.bearing, this.firepower, this));
        }

        public void move() {
            Robovirus.this.out.println(this.index);
            if (enemy.getDistance() == 0.0) {
                return;
            }
            this.update();
            this.percent();
            Robovirus.this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.bearing - Robovirus.this.getGunHeadingRadians())));
            if (Robovirus.this.getGunTurnRemaining() < 3.0 && Robovirus.this.getGunHeat() == 0.0) {
                this.fire();
            }
        }

        public Bullet fire() {
            return Robovirus.this.setFireBullet(this.firepower);
        }

        public abstract void init();

        public abstract void update();

        public void percent() {
            this.percent = 100.0 * (double)this.hits / (double)(this.hits + this.miss);
        }
    }

    public class HOGun
    extends Gun
    implements RobotPart {
        public void init() {
            this.index = 0;
        }

        public void update() {
            this.firepower = 3.0;
            this.bearing = Robovirus.this.getHeadingRadians() + Math.toRadians(enemy.bearing);
        }
    }

    class LTGun
    extends Gun
    implements RobotPart {
        LTGun() {
        }

        public void init() {
            this.index = 1;
        }

        public void update() {
            if (enemy.pos == null) {
                return;
            }
            double heading = enemy.getHeadingRadians();
            double velocity = enemy.getVelocity();
            double dy = velocity * Math.cos(heading);
            double dx = velocity * Math.sin(heading);
            this.firepower = 3.0;
            Wave w = new Wave(Robovirus.this.getX(), Robovirus.this.getY(), this.firepower);
            EnemyBot temp = enemy.clone();
            long i = 0L;
            while (true) {
                w.expand();
                if (w.hasBroken(temp)) break;
                temp.x += dx;
                temp.y += dy;
                ++i;
            }
            double time = i;
            Point2D.Double pos = Robovirus.project(enemy.pos, heading, velocity * time);
            this.bearing = Robovirus.absoluteBearing(Robovirus.this.myLocation, pos);
        }
    }

    private class MeleeGun
    implements RobotPart {
        private MeleeGun() {
        }

        public void init() {
            Robovirus.this.curEn.setDistance(10000.0);
        }

        public void move() {
            if (Robovirus.this.curEn.getName() == null) {
                return;
            }
            double heading = Robovirus.this.curEn.getHeadingRadians();
            double velocity = Robovirus.this.curEn.getVelocity();
            double dy = velocity * Math.cos(heading);
            double dx = velocity * Math.sin(heading);
            Wave w = new Wave(Robovirus.this.getX(), Robovirus.this.getY(), 3.0);
            EnemyBot temp = Robovirus.this.curEn.clone();
            long i = 0L;
            while (true) {
                w.expand();
                if (w.hasBroken(temp)) break;
                temp.x += dx;
                temp.y += dy;
                ++i;
            }
            double time = i;
            Point2D.Double pos = Robovirus.project(((Robovirus)Robovirus.this).curEn.pos, heading, velocity * time);
            Robovirus.this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Robovirus.absoluteBearing(new Point2D.Double(Robovirus.this.getX(), Robovirus.this.getY()), pos) - Robovirus.this.getGunHeadingRadians())));
            if (Math.abs(Robovirus.this.getGunTurnRemaining()) < 10.0 && Robovirus.this.getGunHeat() == 0.0) {
                Robovirus.this.setFire(Math.min(Robovirus.this.getEnergy() / 13.0, 3.0));
            }
        }

        public double pointGunAt(Point2D.Double p) {
            Robovirus.this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Robovirus.absoluteBearing(new Point2D.Double(Robovirus.this.getX(), Robovirus.this.getY()), p) - Robovirus.this.getGunHeadingRadians())));
            return Utils.normalRelativeAngle((double)Robovirus.absoluteBearing(new Point2D.Double(Robovirus.this.getX(), Robovirus.this.getY()), p));
        }
    }

    private class MeleeRadar
    implements RobotPart {
        private MeleeRadar() {
        }

        public void init() {
            Robovirus.this.setTurnRadarRightRadians(Math.PI * 4);
        }

        public void move() {
            Robovirus.this.setTurnRadarRightRadians(Math.PI * 2);
        }
    }

    private class MeleeTank
    implements RobotPart {
        boolean turning;
        boolean moving;

        private MeleeTank() {
        }

        public void init() {
            Robovirus.this.setTurnRight(90.0 - Robovirus.this.getHeading());
            Robovirus.this.waitFor((Condition)new TurnCompleteCondition((AdvancedRobot)Robovirus.this));
            this.turning = true;
            this.moving = false;
        }

        public void move() {
            if (this.moving && Robovirus.this.getDistanceRemaining() == 0.0) {
                double rightRisk;
                Point2D.Double leftPoint = new Point2D.Double(Robovirus.this.getX() - 100.0 * Math.cos(Robovirus.this.getHeadingRadians()), Robovirus.this.getY() + 100.0 * Math.sin(Robovirus.this.getHeadingRadians()));
                Point2D.Double rightPoint = new Point2D.Double(Robovirus.this.getX() + 100.0 * Math.cos(Robovirus.this.getHeadingRadians()), Robovirus.this.getY() - 100.0 * Math.sin(Robovirus.this.getHeadingRadians()));
                double leftRisk = Robovirus.this.getRisk(leftPoint);
                if (leftRisk < (rightRisk = Robovirus.this.getRisk(rightPoint))) {
                    Robovirus.this.setTurnLeft(90.0);
                } else {
                    Robovirus.this.setTurnRight(90.0);
                }
                this.moving = false;
                this.turning = true;
            } else if (this.turning && Robovirus.this.getTurnRemaining() == 0.0) {
                Robovirus.this.setAhead(100.0);
                this.moving = true;
                this.turning = false;
            }
        }
    }

    private class PMGun
    implements RobotPart {
        private PMGun() {
        }

        public void init() {
        }

        public void moveVirtual() {
        }

        public void move() {
            if (enemy.getName() == null) {
                return;
            }
            double targetBearing = enemy.getBearingRadians();
            int searchlength = 30;
        }
    }

    private class Radar
    implements RobotPart {
        private Radar() {
        }

        public void init() {
            Robovirus.this.setTurnRadarRightRadians(Math.PI * 6);
        }

        public void move() {
        }
    }

    public static interface RobotPart {
        public void init();

        public void move();
    }

    private class Tank
    implements RobotPart {
        private Tank() {
        }

        public void init() {
        }

        public void move() {
        }
    }

    class VGun
    extends Condition {
        Point2D.Double start;
        Point2D.Double location;
        double bearing;
        double firepower;
        double velocity;
        Gun gun;

        VGun(Point2D.Double start, double bearing, double firepower, Gun gun) {
            this.setName("Used by " + gun + " at time " + Robovirus.this.getTime());
            this.start = start;
            this.location = start;
            this.bearing = bearing;
            this.firepower = firepower;
            this.velocity = 20.0 - 3.0 * firepower;
            this.gun = gun;
        }

        public boolean test() {
            this.location = Robovirus.project(this.location, this.bearing, this.velocity);
            Robovirus.this.out.println("Testing VBullet " + this.location.x + " " + this.location.y + "Bearing: " + this.bearing + "Velocity: " + this.velocity);
            if (this.location.distance(enemy.x, enemy.y) <= 24.0) {
                Robovirus.this.out.println("VIRTUAL HIT");
                ++this.gun.hits;
                Robovirus.this.removeCustomEvent(this);
                return true;
            }
            if (!new Rectangle2D.Double(0.0, 0.0, Robovirus.this.getBattleFieldWidth(), Robovirus.this.getBattleFieldHeight()).contains(this.location)) {
                Robovirus.this.out.println("VIRTUAL MISS");
                ++this.gun.miss;
                Robovirus.this.removeCustomEvent(this);
            }
            return false;
        }
    }
}

