/*
 * Decompiled with CFR 0.152.
 */
package apc.utils;

import apc.utils.HelperMethods;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Bullet;

public class EmData {
    private static final double TYPICAL_DISTANCE = 465.0;
    private static final double TYPICAL_ESCAPE_RANGE = 0.98;
    private static final double NON_ZERO_VELOCITY_THRESHOLD = 0.1;
    private static final double DIRECTION_CHANGE_THRESHOLD = 1.5707963267948966;
    private StringBuffer history = new StringBuffer("000000000000000000000000000000000000000");
    private double _previousHeading;
    private double _currentHeading;
    private long _timeSinceReverseDirection;
    private long _timeSinceVelocityChange;
    private double _lastVelocity;
    private double _previousVelocity;
    private double _lastNonZeroVelocity;
    private String _botName = new String();
    private double _heading = 0.0;
    private double _scans = 0.0;
    private double _bearing = 0.0;
    private Bullet _bullet = null;
    private double _currentDistance = 0.0;
    private double _energy = 100.0;
    private Point2D.Double _location = new Point2D.Double(0.0, 0.0);
    private Point2D.Double _lastLocation = new Point2D.Double(0.0, 0.0);
    private double _changeInBotHeading = 0.0;
    private double _aveVelocity = 0.0;
    private double _sumVelocity;
    private double _absoluteBearing;
    private int _countVelocity;
    private long _time;
    private long _lastTime = 0L;
    private HelperMethods _calculations;
    private ArrayList<Integer> _surfDirections = new ArrayList();
    private ArrayList<Double> _surfAbsBearings = new ArrayList();

    public EmData(String name) {
        this._botName = name;
    }

    public void updateBotData(double botHeading, double botSpeed, Point2D.Double location, double botDistance, double botBearing, long scanTime, double absoluteBearing, double energy) {
        this._changeInBotHeading = botHeading - this._heading;
        this._heading = botHeading;
        this._lastVelocity = botSpeed;
        this._currentDistance = botDistance;
        this._bearing = botBearing;
        this._location.x = location.x;
        this._location.y = location.y;
        this._scans += 1.0;
        this._time = scanTime - this._lastTime;
        this._lastTime = scanTime;
        this._absoluteBearing = absoluteBearing;
        this._energy = energy;
        if (botSpeed != 0.0) {
            this._sumVelocity += botSpeed;
            ++this._countVelocity;
            this._aveVelocity = this._sumVelocity / (double)this._countVelocity;
        }
    }

    public void updateDistance(Point2D.Double myLocation) {
        this._currentDistance = HelperMethods.distanceSq(myLocation, this._location);
    }

    public double distance() {
        return this._currentDistance;
    }

    public Point2D.Double location() {
        return this._location;
    }

    public double energy() {
        return this._energy;
    }

    public void setScans() {
        this._scans = 0.0;
    }

    public double bearing() {
        return this._bearing;
    }

    public String name() {
        return this._botName;
    }

    public double heading() {
        return this._heading;
    }

    public double velocity() {
        return this._lastVelocity;
    }

    public double aveVelocity() {
        return this._aveVelocity;
    }

    public double changeInHeading() {
        return this._changeInBotHeading;
    }

    public StringBuffer pattern() {
        return this.history;
    }

    public double scans() {
        return this._scans;
    }

    public double time() {
        return this._time;
    }

    public double absoluteBearing() {
        return this._absoluteBearing;
    }

    public void setPrediction(Point2D.Double location) {
        this._location = location;
    }

    public void setPattern(StringBuffer history) {
        this.history = history;
    }

    public void addSurfDierc(double latVel) {
        this._surfDirections.add(0, new Integer(latVel >= 0.0 ? 1 : -1));
    }

    public void addSurfBearings(double absBearing) {
        this._surfAbsBearings.add(0, new Double(absBearing + Math.PI));
    }

    public Integer getSurfDierc() {
        return (int)this._surfDirections.get(2);
    }

    public double getSurfBearings() {
        return this._surfAbsBearings.get(2);
    }

    public void setLastLocation(Point2D.Double location) {
        this._lastLocation = location;
    }

    public Point2D.Double lastLocation() {
        return this._lastLocation;
    }
}

