/*
 * Decompiled with CFR 0.152.
 */
package Krabb.sliNk;

import Krabb.sliNk.Bot;
import Krabb.sliNk.MessageBulletHit;
import Krabb.sliNk.MessageHitByBullet;
import Krabb.sliNk.MessageHitRobot;
import Krabb.sliNk.MessageScan;
import Krabb.sliNk.MyBullet;
import Krabb.sliNk.Scan;
import Krabb.sliNk.Stats;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Data
extends Scan {
    public static HashMap<String, Bot> _enemies_map = new HashMap();
    public static ArrayList<Bot> _enemies_array = new ArrayList();
    public static HashMap<String, Bot> _mates_map = new HashMap();
    public static ArrayList<Bot> _mates_array = new ArrayList();
    public static ArrayList<MyBullet> _bullets = new ArrayList();
    protected static Stats stats_my = null;
    protected static Stats stats_my_last = null;
    protected static Stats stats_my_lastlast = null;

    @Override
    public void newRound() {
        stats_my = null;
        stats_my_last = null;
        stats_my_lastlast = null;
        _bullets.clear();
        super.newRound();
    }

    @Override
    protected void step() {
        this.createNewMyStats();
        this.updateBullets();
        this.updateWaves();
        super.step();
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent event) {
        this.createNewMyStats();
        this.newStats(new Stats(event, (AdvancedRobot)this));
        super.onScannedRobot(event);
    }

    @Override
    public void newTeamScan(MessageScan scan) {
        super.newTeamScan(scan);
        this.newStats(new Stats(scan));
    }

    private void newStats(Stats stats) {
        if (this.isTeammate(stats.name)) {
            if (!_mates_map.containsKey(stats.name)) {
                Bot bot_new = new Bot(stats.name, this);
                _mates_map.put(stats.name, bot_new);
                _mates_array.add(bot_new);
                bot_new.arrayindex = _mates_array.indexOf(bot_new);
                System.out.println("new Mate: " + stats.name);
            }
            _mates_map.get(stats.name).newStats(stats, stats_my);
        } else {
            if (!_enemies_map.containsKey(stats.name)) {
                Bot bot_new = new Bot(stats.name, this);
                _enemies_map.put(stats.name, bot_new);
                _enemies_array.add(bot_new);
                bot_new.arrayindex = _enemies_array.indexOf(bot_new);
                System.out.println("new Enemy: " + stats.name + " [" + bot_new.arrayindex + "]");
            }
            _enemies_map.get(stats.name).newStats(stats, stats_my);
        }
    }

    protected void newBullet(MyBullet bullet_new) {
        _bullets.add(bullet_new);
        if (!bullet_new.virtual) {
            int b = 0;
            while (b < _enemies_array.size()) {
                Data.getEnemy(b).newBullet(bullet_new);
                ++b;
            }
        }
    }

    private void updateBullets() {
        Stats[] enemies_stats = new Stats[_enemies_array.size()];
        int i = 0;
        while (i < _enemies_array.size()) {
            enemies_stats[i] = Data.getEnemy(i).getNewestStats();
            ++i;
        }
        int i2 = 0;
        while (i2 < _bullets.size()) {
            MyBullet bullet = Data.getBullet(i2);
            if (!bullet.step(this.getTime(), enemies_stats)) {
                _bullets.remove(i2);
                --i2;
            }
            ++i2;
        }
    }

    private void updateWaves() {
        int i = 0;
        while (i < _enemies_array.size()) {
            Data.getEnemy(i).updateWave(this.getTime(), this);
            ++i;
        }
    }

    public void onRobotDeath(RobotDeathEvent ev) {
        if (this.isTeammate(ev.getName())) {
            Bot mate = Data.getMate(ev.getName());
            if (mate != null) {
                mate.death = true;
            } else {
                System.out.println("bot not known!! (onRobotDeath)");
            }
        } else {
            Bot bot = Data.getEnemy(ev.getName());
            if (bot != null) {
                bot.death = true;
            } else {
                System.out.println("bot not known!! (onRobotDeath)");
            }
        }
    }

    @Override
    public void onHitRobot(HitRobotEvent event) {
        super.onHitRobot(event);
        if (!this.isTeammate(event.getName())) {
            Bot bot = Data.getEnemy(event.getName());
            if (bot != null) {
                bot.newEnergy(event.getEnergy(), 0.6, event.getTime());
            } else {
                System.out.println("bot not known!! (onHitRobot)");
            }
        }
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent event) {
        if (!this.isTeammate(event.getHitBullet().getName())) {
            Bot bot = Data.getEnemy(event.getHitBullet().getName());
            if (bot != null) {
                bot.bulletHitBullet(event);
            } else {
                System.out.println("bot not known!! (onBulletHitBullet)");
            }
        }
        if (Data.getBullet(event.getBullet()) != null) {
            Data.getBullet(event.getBullet()).newBulletHitBullet();
        }
        super.onBulletHitBullet(event);
    }

    public static MyBullet getBullet(int i) {
        return _bullets.get(i);
    }

    public static MyBullet getBullet(Bullet bullet) {
        for (MyBullet b : _bullets) {
            if (b.bullet != bullet) continue;
            return b;
        }
        return null;
    }

    public static Bot getBot(String name) {
        if (_enemies_map.containsKey(name)) {
            return Data.getEnemy(name);
        }
        if (_mates_map.containsKey(name)) {
            return Data.getMate(name);
        }
        return null;
    }

    public static Bot getEnemy(int i) {
        if (i >= _enemies_array.size()) {
            return null;
        }
        return _enemies_array.get(i);
    }

    public static Bot getEnemy(String name) {
        return _enemies_map.get(name);
    }

    public static double getNearestEnemyDistance(Point2D.Double location) {
        double dist = Double.MAX_VALUE;
        for (Bot enemy : _enemies_array) {
            if (enemy.getNewestStats() == null || enemy.death || !(enemy.getNewestStats().location.distance(location) > 18.0)) continue;
            dist = Math.min(dist, enemy.getNewestStats().location.distance(location));
        }
        return dist;
    }

    public static ArrayList<Bot> getLivingEnemies() {
        ArrayList<Bot> botlist_living = new ArrayList<Bot>();
        int i = 0;
        while (i < _enemies_array.size()) {
            if (!Data.getEnemy((int)i).death) {
                botlist_living.add(Data.getEnemy(i));
            }
            ++i;
        }
        return botlist_living;
    }

    public static ArrayList<Bot> getLivingMates() {
        ArrayList<Bot> botlist_living = new ArrayList<Bot>();
        int i = 0;
        while (i < _mates_array.size()) {
            if (!Data.getMate((int)i).death) {
                botlist_living.add(Data.getMate(i));
            }
            ++i;
        }
        return botlist_living;
    }

    public static ArrayList<Bot> getLivingEnemiesWithStats() {
        ArrayList<Bot> botlist_living = new ArrayList<Bot>();
        int i = 0;
        while (i < _enemies_array.size()) {
            if (!Data.getEnemy((int)i).death && Data.getEnemy(i).getNewestStats() != null) {
                botlist_living.add(Data.getEnemy(i));
            }
            ++i;
        }
        return botlist_living;
    }

    public static Bot getMate(int i) {
        return _mates_array.get(i);
    }

    public static Bot getMate(String name) {
        return _mates_map.get(name);
    }

    public static Bot getLastScannedEnemy() {
        long oldest = Long.MAX_VALUE;
        Bot bot_best = null;
        int i = 0;
        while (i < _enemies_array.size()) {
            Bot bot_current = Data.getEnemy(i);
            if (!bot_current.death && bot_current.enemy && bot_current.getNewestStats() != null && bot_current.getNewestStats().time <= oldest) {
                oldest = bot_current.getNewestStats().time;
                bot_best = bot_current;
            }
            ++i;
        }
        return bot_best;
    }

    public static Bot[] getLastScannedEnemies(long time) {
        Bot[] bot_best = new Bot[]{null, null};
        long oldest = time;
        int i = 0;
        while (i < _enemies_array.size()) {
            Bot bot_current = Data.getEnemy(i);
            if (!bot_current.death && bot_current.enemy && bot_current.getNewestStats().time <= oldest) {
                oldest = bot_current.getNewestStats().time;
                bot_best[1] = bot_best[0];
                bot_best[0] = bot_current;
            }
            ++i;
        }
        return bot_best;
    }

    public static Bot getFirstLivingEnemy() {
        int i = 0;
        while (i < _enemies_array.size()) {
            if (!Data.getEnemy((int)i).death) {
                return Data.getEnemy(i);
            }
            ++i;
        }
        return null;
    }

    public static Bot getFirstBot() {
        int i = 0;
        if (i < _enemies_array.size()) {
            return Data.getEnemy(i);
        }
        return null;
    }

    private void createNewMyStats() {
        if (stats_my == null || Data.stats_my.time < this.getTime()) {
            Stats stats_new = new Stats((AdvancedRobot)this);
            stats_new.update(stats_my);
            stats_my_lastlast = stats_my_last;
            stats_my_last = stats_my;
            stats_my = stats_new;
        }
    }

    @Override
    public void onBulletHit(BulletHitEvent event) {
        super.onBulletHit(event);
        if (!this.isTeammate(event.getName())) {
            Bot bot = Data.getEnemy(event.getName());
            if (bot != null) {
                bot.hitByBullet(event);
            } else {
                System.out.println("bot not known!! (onBulletHit)");
            }
        }
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        super.onHitByBullet(event);
        if (!this.isTeammate(event.getName())) {
            Bot bot = Data.getEnemy(event.getName());
            if (bot != null) {
                bot.hitRobot(event);
            } else {
                System.out.println("bot not known!! (hitRobot)");
            }
        }
    }

    @Override
    public void newTeamBulletHit(MessageBulletHit bullet) {
    }

    @Override
    public void newTeamHitByBullet(MessageHitByBullet bullet) {
    }

    @Override
    public void newTeamRam(MessageHitRobot event) {
    }
}

