/*
 * Decompiled with CFR 0.152.
 */
package ds.gun.linear;

import ds.Hud;
import ds.gun.AbstractGun;
import ds.gun.FireSolution;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class LinearGun
extends AbstractGun {
    public LinearGun(AdvancedRobot owner, ITargetManager targetManager) {
        super("linear", owner, targetManager, Color.green);
    }

    @Override
    protected FireSolution computeFireSolution(double bulletPower) {
        try {
            IVirtualBot target = this.getTargetManager().getCurrentTarget();
            double myX = this.getOwner().getX();
            double myY = this.getOwner().getY();
            double enemyX = target.getX();
            double enemyY = target.getY();
            double enemyHeading = target.getHeadingRadians();
            double enemyVelocity = target.getVelocity();
            double deltaTime = 0.0;
            double battleFieldHeight = this.getOwner().getBattleFieldHeight();
            double battleFieldWidth = this.getOwner().getBattleFieldWidth();
            double predictedX = enemyX;
            double predictedY = enemyY;
            while ((deltaTime += 1.0) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)) {
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
                if (!((predictedX += Math.sin(enemyHeading) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0)) continue;
                predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
                predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
                break;
            }
            double theta = Utils.normalAbsoluteAngle((double)Math.atan2(predictedX - this.getOwner().getX(), predictedY - this.getOwner().getY()));
            double angle = Utils.normalRelativeAngle((double)(theta - this.getOwner().getGunHeadingRadians()));
            double absoluteAngle = Utils.normalRelativeAngle((double)theta);
            return new FireSolution(angle, absoluteAngle, 1.0);
        }
        catch (TargetException te) {
            return new FireSolution(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void paint(Hud hud, long tick) {
    }
}

