/*
 * Decompiled with CFR 0.152.
 */
package ds.radar;

import ds.Hud;
import ds.IComponent;
import ds.IEventListener;
import ds.Math2;
import ds.Versatile;
import ds.constant.ConstantManager;
import ds.targeting.ITargetManager;
import ds.targeting.IVirtualBot;
import ds.targeting.TargetException;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Radar
implements Hud.Painter,
IComponent,
IEventListener.ScannedRobot {
    private boolean m_bRadarCorrection;
    private Versatile m_owner;
    private ITargetManager m_targetManager;
    private double m_focus;

    public Radar(Versatile owner, ITargetManager targetManager) {
        this.m_owner = owner;
        this.m_targetManager = targetManager;
        this.m_focus = Math2.degToRad(ConstantManager.getInstance().getIntegerConstant("radar.focus").longValue());
        this.m_bRadarCorrection = false;
    }

    @Override
    public void Act() {
        this.m_owner.setAdjustRadarForGunTurn(true);
        this.m_owner.setAdjustRadarForRobotTurn(true);
        double radarOffset = 0.0;
        try {
            radarOffset = !this.m_targetManager.HasTarget() ? 360.0 : ((radarOffset = Utils.normalRelativeAngle((double)(this.m_owner.getRadarHeadingRadians() - this.absbearing(this.m_owner.getX(), this.m_owner.getY(), this.m_targetManager.getCurrentTarget().getX(), this.m_targetManager.getCurrentTarget().getY())))) < 0.0 ? (radarOffset -= 0.09817477042468103) : (radarOffset += 0.09817477042468103));
        }
        catch (TargetException targetException) {
            // empty catch block
        }
        this.m_owner.setTurnRadarLeftRadians(Utils.normalRelativeAngle((double)radarOffset));
    }

    @Override
    public void OnScannedRobot(ScannedRobotEvent event) {
        this.m_targetManager.OnScannedRobot(event);
    }

    @Override
    public void paint(Hud hud, long tick) {
        IVirtualBot target = null;
        try {
            target = this.m_targetManager.getCurrentTarget();
            hud.setColor(Color.red);
            hud.drawRect(target.getBottomLeftCorner().getX(), target.getBottomLeftCorner().getY(), target.getSize(), target.getSize());
        }
        catch (TargetException targetException) {
            // empty catch block
        }
    }

    private double absbearing(double x1, double y1, double x2, double y2) {
        Point2D.Double pt1 = new Point2D.Double(x1, y1);
        Point2D.Double pt2 = new Point2D.Double(x2, y2);
        double xo = ((Point2D)pt2).getX() - ((Point2D)pt1).getX();
        double yo = ((Point2D)pt2).getY() - ((Point2D)pt1).getY();
        double h = pt1.distance(pt2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }
}

