/*
 * Decompiled with CFR 0.152.
 */
package sng.arco;

import java.awt.Color;
import robocode.AdvancedRobot;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import sng.BotMath;

public class Arco
extends AdvancedRobot {
    private static final long SCAN_INTERVAL_LIMIT = 4L;
    private static final double SCAN_ARC_HALF = 0.19634954084936207;
    private static final int CAN_FIRE = 0;
    private static final int MAY_FIRE = 1;
    private static final int MAY_NOT_FIRE = 2;
    private static final int DO_NOT_FIRE = 3;
    private double energy_conservation_limit = 85.0;
    private long target_scan_time;
    private boolean target_locked;
    private double target_absolute_bearing;
    private double target_x;
    private double target_y;
    private double target_heading;
    private double target_velocity;
    private double distance_to_target;
    private double target_energy;
    private String target_name;
    private boolean backing_off;
    private double ahead;
    private double direction = 1.0;
    private double turn = Math.toRadians(3.0);
    private double min_x;
    private double min_y;
    private double max_x;
    private double max_y;
    private double prev_x;
    private double prev_y;
    private double wall_buffer;
    private double corner_buffer;
    private double center_x;
    private double center_y;

    private void init_round() {
        this.target_scan_time = -5L;
        this.target_locked = false;
        this.target_absolute_bearing = 0.0;
        this.target_x = 0.0;
        this.target_y = 0.0;
        this.target_heading = 0.0;
        this.target_velocity = 0.0;
        this.distance_to_target = 0.0;
        this.target_energy = 0.0;
        this.backing_off = false;
        this.wall_buffer = 50.0;
        this.corner_buffer = 70.0;
        this.min_x = this.wall_buffer;
        this.min_y = this.wall_buffer;
        this.max_x = super.getBattleFieldWidth() - this.wall_buffer;
        this.max_y = super.getBattleFieldHeight() - this.wall_buffer;
        this.center_x = super.getBattleFieldWidth() / 2.0;
        this.center_y = super.getBattleFieldHeight() / 2.0;
        this.prev_x = super.getX();
        this.prev_y = super.getY();
    }

    public void run() {
        this.setColors(Color.ORANGE, Color.BLACK, Color.RED);
        this.init_round();
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        while (true) {
            this.sweep();
            this.steer();
            this.target();
            this.prev_x = super.getX();
            this.prev_y = super.getY();
            this.execute();
        }
    }

    private void sweep() {
        double d;
        if (super.getTime() - this.target_scan_time > 4L) {
            this.target_locked = false;
            d = Math.PI * 2;
        } else {
            d += (d = BotMath.relative_angle_radians(this.target_absolute_bearing, super.getRadarHeadingRadians())) > 0.0 ? 0.19634954084936207 : -0.19634954084936207;
        }
        super.setTurnRadarRightRadians(d);
    }

    private void steer() {
        if (this.in_corner()) {
            this.avoid_corner();
            return;
        }
        this.backing_off = false;
        if (this.nearing_wall()) {
            this.avoid_wall();
        } else {
            this.move();
        }
    }

    private void move() {
        if (Math.abs(super.getDistanceRemaining()) > 0.0) {
            if (Math.abs(super.getTurnRemainingRadians()) <= 0.0) {
                super.setTurnRightRadians(this.turn);
            }
        } else {
            this.direction = -this.direction;
            this.turn = this.get_turn();
            super.setAhead(this.direction * this.get_ahead());
        }
    }

    private void avoid_corner() {
        if (!this.backing_off) {
            super.setAhead(0.0);
            if (super.getVelocity() == 0.0) {
                this.backing_off = true;
                double d = BotMath.heading_radians(super.getX(), super.getY(), this.center_x, this.center_y);
                double d2 = BotMath.relative_angle_radians(d, super.getHeadingRadians());
                if (Math.abs(d2) <= 1.5707963267948966) {
                    this.direction = 1.0;
                } else {
                    this.direction = -1.0;
                    d2 = d2 > 0.0 ? (d2 -= Math.PI) : (d2 += Math.PI);
                }
                super.setTurnRightRadians(d2);
                super.setAhead(this.direction * 100.0);
            }
        }
    }

    private void avoid_wall() {
        super.setAhead(0.0);
        if (super.getVelocity() == 0.0) {
            double d = BotMath.heading_radians(super.getX(), super.getY(), this.center_x, this.center_y);
            double d2 = BotMath.relative_angle_radians(d, super.getHeadingRadians());
            if (Math.abs(d2) <= 1.5707963267948966) {
                this.direction = 1.0;
            } else {
                this.direction = -1.0;
                d2 = d2 > 0.0 ? (d2 -= Math.PI) : (d2 += Math.PI);
            }
            super.setTurnRightRadians(d2);
            super.setAhead(this.direction * 200.0);
        }
    }

    private boolean in_corner() {
        double d = super.getX();
        double d2 = super.getY();
        if (d < this.corner_buffer && d2 < this.corner_buffer) {
            return true;
        }
        if (d < this.corner_buffer && d2 > super.getBattleFieldHeight() - this.corner_buffer) {
            return true;
        }
        if (d > super.getBattleFieldWidth() - this.corner_buffer && d2 < this.corner_buffer) {
            return true;
        }
        return d > super.getBattleFieldWidth() - this.corner_buffer && d2 > super.getBattleFieldHeight() - this.corner_buffer;
    }

    private boolean nearing_wall() {
        double d = super.getX();
        double d2 = super.getY();
        if (d < this.min_x) {
            return d < this.prev_x;
        }
        if (d > this.max_x) {
            return d > this.prev_x;
        }
        if (d2 < this.min_y) {
            return d2 < this.prev_y;
        }
        if (d2 > this.max_y) {
            return d2 > this.prev_y;
        }
        return false;
    }

    private double get_ahead() {
        return 100.0 + Math.random() * 300.0;
    }

    private double get_turn() {
        double d = Math.random() * 10.0 - 5.0;
        if (d == 0.0) {
            d = 4.0;
        }
        return Math.toRadians(d);
    }

    public void target() {
        if (this.target_locked) {
            double d = BotMath.heading_radians(super.getX(), super.getY(), this.target_x, this.target_y);
            double d2 = BotMath.length(super.getX(), super.getY(), this.target_x, this.target_y);
            double d3 = BotMath.relative_angle_radians(d, super.getGunHeadingRadians());
            double d4 = Math.atan(8.0 / d2);
            if (super.getGunHeat() > 0.0) {
                super.setTurnGunRightRadians(d3);
                return;
            }
            if (Math.abs(d3) > d4) {
                super.setTurnGunRightRadians(d3);
                return;
            }
            int n = this.fire_advice(3.0);
            if (n == 3) {
                super.setTurnGunRightRadians(d3);
                return;
            }
            if (n == 0) {
                super.setFire(3.0);
                return;
            }
            if (n == 1) {
                super.setFire(3.0);
                return;
            }
            if (Math.abs(this.target_velocity) <= 1.0) {
                super.setFire(3.0);
                return;
            }
            if (d == this.target_heading || d == this.target_heading - Math.PI) {
                super.setFire(3.0);
                return;
            }
            if (d2 <= 30.0) {
                super.setFire(3.0);
                return;
            }
            super.setTurnGunRightRadians(d3);
            return;
        }
    }

    private int fire_advice(double d) {
        double d2 = super.getEnergy();
        double d3 = this.target_energy;
        if ((d2 -= d) == 0.0) {
            return 3;
        }
        if (d2 >= d3) {
            return 0;
        }
        if (d2 > this.energy_conservation_limit) {
            return 0;
        }
        if ((d2 += Rules.getBulletHitBonus((double)d)) > (d3 -= Rules.getBulletDamage((double)d))) {
            return 1;
        }
        return 2;
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        this.target_scan_time = super.getTime();
        this.target_locked = true;
        this.target_velocity = scannedRobotEvent.getVelocity();
        this.distance_to_target = scannedRobotEvent.getDistance();
        this.target_absolute_bearing = BotMath.absolute_angle_radians(scannedRobotEvent.getBearingRadians(), super.getHeadingRadians());
        this.target_x = super.getX() + this.distance_to_target * Math.sin(this.target_absolute_bearing);
        this.target_y = super.getY() + this.distance_to_target * Math.cos(this.target_absolute_bearing);
        this.target_heading = scannedRobotEvent.getHeadingRadians();
        this.target_energy = scannedRobotEvent.getEnergy();
        this.target_name = scannedRobotEvent.getName();
    }
}

