/*
 * Decompiled with CFR 0.152.
 */
package rdm;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nullable;
import rdm.gunners.Gunner;
import rdm.gunners.SamplerGunner;
import rdm.gunners.dnn.DnnGunner;
import rdm.precepts.GunPrecept;
import rdm.robots.AdvancedRobotExtensionsKt;
import rdm.state.StateCollectorImpl;
import rdm.state.entities.State;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u0006H\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010\u0019\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\b0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lrdm/WallRider;", "Lrobocode/AdvancedRobot;", "()V", "collector", "Lrdm/state/StateCollectorImpl;", "gunner", "Lrdm/gunners/Gunner;", "lastPrecept", "Lkotlin/Pair;", "Lrdm/state/entities/State;", "Lrdm/precepts/GunPrecept;", "points", "", "", "buildHandler", "canFire", "", "fireIfGunRotationDone", "precept", "onBattleEnded", "", "event", "Lrobocode/BattleEndedEvent;", "onBulletHit", "Lrobocode/BulletHitEvent;", "onBulletHitBullet", "Lrobocode/BulletHitBulletEvent;", "onBulletMissed", "Lrobocode/BulletMissedEvent;", "onHitRobot", "Lrobocode/HitRobotEvent;", "onScannedRobot", "Lrobocode/ScannedRobotEvent;", "run", "Constants", "WallRider"})
public final class WallRider
extends AdvancedRobot {
    private final StateCollectorImpl collector = StateCollectorImpl.INSTANCE;
    private Gunner gunner;
    private Pair<State, GunPrecept> lastPrecept;
    private List<Pair<Double, Double>> points = CollectionsKt.shuffled(rdm.WallRider$Constants.access$getPOINTS$p(Constants));
    private static final List<Pair<Double, Double>> POINTS;
    private static boolean SAMPLING;
    public static final Constants Constants;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.gunner = this.buildHandler();
        try {
            try {
                this.setBodyColor(Color.ORANGE);
                this.setGunColor(Color.RED);
                this.setRadarColor(Color.BLACK);
                this.setBulletColor(Color.WHITE);
                this.setAdjustGunForRobotTurn(true);
                this.setAdjustRadarForGunTurn(true);
                this.lastPrecept = null;
                this.setTurnRadarRightRadians(DoubleCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
                while (true) {
                    int residual = (int)(this.getTime() % (long)320);
                    int index = residual / 80;
                    Pair<Double, Double> targetPoint = this.points.get(index);
                    AdvancedRobotExtensionsKt.setMoveTo(this, targetPoint);
                    if ((int)(this.getTime() % (long)5000) == 0) {
                        this.points = CollectionsKt.shuffled(WallRider.Constants.getPOINTS());
                    }
                    this.execute();
                }
            }
            catch (Error error) {
                throw (Throwable)error;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Gunner gunner = this.gunner;
                if (gunner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gunner");
                }
                gunner.dispose();
            }
        }
        catch (Throwable throwable) {
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            gunner.dispose();
            throw throwable;
        }
    }

    public void onHitRobot(@Nullable HitRobotEvent event) {
        this.points = CollectionsKt.shuffled(WallRider.Constants.getPOINTS());
    }

    public void onBattleEnded(@Nullable BattleEndedEvent event) {
        try {
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            gunner.dispose();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onScannedRobot(@Nullable ScannedRobotEvent event) {
        try {
            ScannedRobotEvent scannedRobotEvent = event;
            if (scannedRobotEvent == null) {
                Intrinsics.throwNpe();
            }
            AdvancedRobotExtensionsKt.lockRadarOnTarget(this, scannedRobotEvent);
            State state = this.collector.collect(AdvancedRobotExtensionsKt.instantStateOf(this, event));
            Gunner gunner = this.gunner;
            if (gunner == null) {
                Intrinsics.throwUninitializedPropertyAccessException("gunner");
            }
            GunPrecept precept = gunner.handle(state);
            Pair<State, GunPrecept> finalLastPrecept = this.lastPrecept;
            if (finalLastPrecept == null) {
                boolean shouldFire;
                boolean bl = shouldFire = this.canFire() && precept.getShouldFire();
                if (shouldFire) {
                    AdvancedRobotExtensionsKt.lockGunOnTarget(this, event, precept.getRotation());
                    this.lastPrecept = new Pair<State, GunPrecept>(state, precept);
                } else {
                    AdvancedRobotExtensionsKt.lockGunOnTarget(this, event, 0.0);
                }
            } else if (this.fireIfGunRotationDone(finalLastPrecept)) {
                this.lastPrecept = null;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void onBulletHit(@Nullable BulletHitEvent event) {
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        BulletHitEvent bulletHitEvent = event;
        if (bulletHitEvent == null) {
            Intrinsics.throwNpe();
        }
        Bullet bullet = bulletHitEvent.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event!!.bullet");
        gunner.saveShotResult(bullet, true);
    }

    public void onBulletHitBullet(@Nullable BulletHitBulletEvent event) {
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        BulletHitBulletEvent bulletHitBulletEvent = event;
        if (bulletHitBulletEvent == null) {
            Intrinsics.throwNpe();
        }
        Bullet bullet = bulletHitBulletEvent.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event!!.bullet");
        gunner.saveShotResult(bullet, null);
    }

    public void onBulletMissed(@Nullable BulletMissedEvent event) {
        Gunner gunner = this.gunner;
        if (gunner == null) {
            Intrinsics.throwUninitializedPropertyAccessException("gunner");
        }
        BulletMissedEvent bulletMissedEvent = event;
        if (bulletMissedEvent == null) {
            Intrinsics.throwNpe();
        }
        Bullet bullet = bulletMissedEvent.getBullet();
        Intrinsics.checkExpressionValueIsNotNull(bullet, "event!!.bullet");
        gunner.saveShotResult(bullet, false);
    }

    private final boolean fireIfGunRotationDone(Pair<State, GunPrecept> precept) {
        if (Utils.isNear((double)this.getGunTurnRemaining(), (double)0.0)) {
            Bullet bullet;
            Bullet bullet2 = bullet = this.setFireBullet(precept.getSecond().getBulletPower());
            if (bullet2 != null) {
                Bullet bullet3;
                Bullet it = bullet3 = bullet2;
                Gunner gunner = this.gunner;
                if (gunner == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("gunner");
                }
                gunner.saveShot(bullet, precept.getFirst(), precept.getSecond());
            }
            return bullet != null;
        }
        return false;
    }

    private final boolean canFire() {
        return !(this.getGunHeat() > 0.0);
    }

    private final Gunner buildHandler() {
        Gunner gunner;
        if (WallRider.Constants.getSAMPLING()) {
            try {
                File file;
                File file2 = file = this.getDataFile("dataset.csv");
                Intrinsics.checkExpressionValueIsNotNull(file2, "file");
                gunner = new SamplerGunner(file2);
            }
            catch (IOException exception) {
                System.err.println(exception.getMessage());
                throw (Throwable)exception;
            }
        } else {
            gunner = new DnnGunner();
        }
        return gunner;
    }

    static {
        Constants = new Constants(null);
        POINTS = CollectionsKt.listOf(new Pair[]{new Pair<Double, Double>(60.0, 60.0), new Pair<Double, Double>(60.0, 540.0), new Pair<Double, Double>(740.0, 540.0), new Pair<Double, Double>(740.0, 60.0)});
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lrdm/WallRider$Constants;", "", "()V", "POINTS", "", "Lkotlin/Pair;", "", "getPOINTS", "()Ljava/util/List;", "SAMPLING", "", "getSAMPLING", "()Z", "setSAMPLING", "(Z)V", "WallRider"})
    public static final class Constants {
        private final List<Pair<Double, Double>> getPOINTS() {
            return POINTS;
        }

        private final boolean getSAMPLING() {
            return SAMPLING;
        }

        private final void setSAMPLING(boolean bl) {
            SAMPLING = bl;
        }

        private Constants() {
        }

        public static final /* synthetic */ void access$setSAMPLING$p(Constants $this, boolean bl) {
            $this.setSAMPLING(bl);
        }

        public /* synthetic */ Constants(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

