/*
 * Decompiled with CFR 0.152.
 */
package cuoq.targeting;

import cuoq.Utils;
import robocode.Rules;

public class DCGFFrame {
    double manhattanDistance;
    double headingChange;
    double velocity;
    double latVelocity;
    double acceleration;
    double distance;
    double heading;
    int timeSinceLastStop;
    int timeSinceLastDir;
    Double guessFactor = null;

    public DCGFFrame(double headingDelta, double heading, double velocity, double lateralVelocity, double acceleration, double distance, int timeSinceLastStop, int timeSinceLastDir) {
        this.velocity = velocity;
        this.headingChange = headingDelta;
        this.heading = heading;
        this.latVelocity = lateralVelocity;
        this.distance = distance;
        this.timeSinceLastStop = timeSinceLastStop;
        this.timeSinceLastDir = timeSinceLastDir;
        this.acceleration = acceleration;
        this.manhattanDistance = this.normalizeVelocity(velocity) + this.normalizeHeadingDelta(headingDelta) + this.normalizeVelocity(lateralVelocity) + this.normalizeDistance(distance) + this.normalizeLastStopTime(this.getTimeSinceLastStop()) + this.normalizeAcceleration(acceleration) + this.normalizeLastDirChange(this.getTimeSinceDirChange());
    }

    public Double getGuessFactor() {
        return this.guessFactor;
    }

    public void setGuessFactor(double guessFactor) {
        this.guessFactor = Utils.limit(-1.0, guessFactor, 1.0);
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double normalizeVelocity(double velocity) {
        return (velocity + 8.0) / 16.0;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double normalizeAcceleration(double acceleration) {
        return (acceleration + 2.0) / 3.0;
    }

    public double getTimeSinceLastStop() {
        return Math.min(9.0, (double)this.timeSinceLastStop / 5.0);
    }

    public double normalizeLastStopTime(double stopTimeIndex) {
        return stopTimeIndex / 9.0;
    }

    public double getTimeSinceDirChange() {
        return Math.min(9.0, (double)this.timeSinceLastDir / 5.0);
    }

    public double normalizeLastDirChange(double changeDirIndex) {
        return changeDirIndex / 9.0;
    }

    public double getHeading() {
        return this.heading;
    }

    public double normalizeHeading(double heading) {
        return (heading + Math.PI * 2) / (Math.PI * 4);
    }

    public double getHeadingDelta() {
        return this.headingChange;
    }

    public double normalizeHeadingDelta(double delta) {
        return (delta + Rules.MAX_TURN_RATE_RADIANS) / (Rules.MAX_TURN_RATE_RADIANS * 2.0);
    }

    public double getDistance() {
        return this.distance;
    }

    public double normalizeDistance(double dist) {
        return dist / 1200.0;
    }

    public double getLateralVelocity() {
        return this.latVelocity;
    }

    public double getManhattanDistance() {
        return this.manhattanDistance;
    }

    public double calculateEuclidean(DCGFFrame f) {
        return Math.pow(this.normalizeVelocity(this.velocity) - this.normalizeVelocity(f.getVelocity()), 2.0) + Math.pow(this.normalizeHeadingDelta(this.headingChange) - this.normalizeHeadingDelta(f.getHeadingDelta()), 2.0) + Math.pow(this.normalizeVelocity(this.latVelocity) - this.normalizeVelocity(f.getLateralVelocity()), 2.0) + Math.pow(this.normalizeDistance(this.distance) - this.normalizeDistance(f.getDistance()), 2.0) + Math.pow(this.normalizeLastStopTime(this.getTimeSinceLastStop()) - this.normalizeLastStopTime(f.getTimeSinceLastStop()), 2.0) + Math.pow(this.normalizeLastDirChange(this.getTimeSinceDirChange()) - this.normalizeLastDirChange(f.getTimeSinceDirChange()), 2.0) + Math.pow(this.normalizeAcceleration(this.acceleration) - this.normalizeAcceleration(f.getAcceleration()), 2.0);
    }
}

