/*
 * Decompiled with CFR 0.152.
 */
package mcb.guns;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Vector;
import mcb.guns.Beretta;
import mcb.guns.Condor;
import mcb.guns.Glock;
import mcb.interfaces.AGun;
import mcb.tools.BotWrapper;
import mcb.tools.FieldPoint;
import mcb.tools.RobotState;
import mcb.tools.VirtualBullet;

public class MultiGun
extends AGun {
    private static Vector<AGun> guns = new Vector();
    private static Vector<VirtualBullet> vbullets = new Vector();
    private static Rectangle2D.Double battlefield;
    private AGun bestGun = null;

    public MultiGun(BotWrapper botWrapper) {
        super(botWrapper);
        guns.add(new Beretta(botWrapper));
        guns.add(new Glock(botWrapper));
        guns.add(new Condor(botWrapper));
        this.bestGun = guns.get(0);
    }

    public double getFiringAngle(RobotState robotState, RobotState robotState2, double d) {
        if (battlefield == null) {
            battlefield = new Rectangle2D.Double(0.0, 0.0, this.bot.getBattleFieldWidth(), this.bot.getBattleFieldHeight());
        }
        Iterator<VirtualBullet> iterator = vbullets.iterator();
        while (iterator.hasNext()) {
            Iterator<AGun> iterator2 = iterator.next();
            ((Point2D)((Object)iterator2)).setLocation(((FieldPoint)((Object)iterator2)).project(((VirtualBullet)((Object)iterator2)).heading, ((VirtualBullet)((Object)iterator2)).velocity));
            if (((Point2D)((Object)iterator2)).distance(robotState2) < 25.0) {
                ++((VirtualBullet)((Object)iterator2)).gunUsed.hit;
                iterator.remove();
                continue;
            }
            if (battlefield.contains((Point2D)((Object)iterator2))) continue;
            iterator.remove();
        }
        for (AGun aGun : guns) {
            VirtualBullet virtualBullet = new VirtualBullet();
            virtualBullet.setLocation(robotState);
            virtualBullet.heading = aGun.getFiringAngle(robotState, robotState2, d);
            virtualBullet.velocity = 20.0 - 3.0 * d;
            virtualBullet.gunUsed = aGun;
            vbullets.add(virtualBullet);
        }
        long l = -1L;
        for (AGun aGun : guns) {
            if ((long)aGun.hit <= l) continue;
            l = aGun.hit;
            this.bestGun = aGun;
        }
        double d2 = this.bestGun.getFiringAngle(robotState, robotState2, d);
        return d2;
    }

    public void onPaint(Graphics2D graphics2D) {
        for (VirtualBullet virtualBullet : vbullets) {
            graphics2D.setColor(virtualBullet.gunUsed.getColor());
            graphics2D.fillOval((int)virtualBullet.x - 3, (int)virtualBullet.y - 3, 6, 6);
        }
        int n = guns.size();
        int n2 = 0;
        while (n2 < n) {
            AGun aGun = guns.elementAt(n2);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(String.valueOf(aGun.getName()) + ": " + aGun.hit, 20, 5 + n2 * 15);
            graphics2D.setColor(aGun.getColor());
            graphics2D.fillOval(5, 5 + n2 * 15, 10, 10);
            ++n2;
        }
    }

    public Color getColor() {
        return this.bestGun.getColor();
    }
}

