/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import origin.Analysis;
import origin.Enemy;
import origin.EnemyML;
import origin.SelfWave;
import origin.SleepSiphon;
import origin.Util;
import robocode.Bullet;
import robocode.Rules;
import robocode.util.Utils;

public class Gun {
    private SleepSiphon self;
    private LinkedList<Bullet> bullets;
    private LinkedList<SelfWave> selfWaves;
    private ConcurrentHashMap<String, Enemy> enemies;
    HashMap<String, EnemyML> enemiesml;

    public Gun(SleepSiphon s, LinkedList<Bullet> b, LinkedList<SelfWave> sw, ConcurrentHashMap<String, Enemy> enemies, HashMap<String, EnemyML> enemiesml) {
        this.self = s;
        this.bullets = b;
        this.selfWaves = sw;
        this.enemies = enemies;
        this.enemiesml = enemiesml;
    }

    public double firePowerByDist(Enemy target) {
        double currentDist = Math.sqrt(Math.pow(target.getX() - this.self.getX(), 2.0) + Math.pow(target.getY() - this.self.getY(), 2.0));
        double power = Util.limitValueBounds(1.0 / (currentDist / Math.min(Math.max(this.self.getBattleFieldWidth(), this.self.getBattleFieldHeight()), 1000.0)), 1.5, 3.0);
        return power;
    }

    public void aimToCoordinate(double x, double y) {
        this.self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(x - this.self.getX(), y - this.self.getY()) - this.self.getGunHeadingRadians())));
    }

    public void aimToCoordinate(Point2D.Double coords) {
        this.self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(coords.getX() - this.self.getX(), coords.getY() - this.self.getY()) - this.self.getGunHeadingRadians())));
    }

    public void setFireBullet(double bulletPower) {
        Bullet nBullet;
        if (this.self.getGunHeat() == 0.0 && (nBullet = this.self.setFireBullet(bulletPower)) != null) {
            this.bullets.add(nBullet);
            this.selfWaves.add(new SelfWave(this.self.getX(), this.self.getY(), this.self.getTime(), nBullet.getPower(), this.enemies, this.enemiesml));
        }
    }

    public void basic(Enemy target, double BULLET_POWER) {
        if (this.self.getGunTurnRemaining() == 0.0 && target != null) {
            double targetAbsoluteBearing = this.self.getHeadingRadians() + target.getBearing();
            this.self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetAbsoluteBearing - this.self.getGunHeadingRadians())));
            this.setFireBullet(BULLET_POWER);
        }
    }

    public double[] linearPredictionFire(Enemy target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double eVelocityY;
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - this.self.getX();
        double eY = target.getY() - this.self.getY();
        double eVelocityX = target.getVelocity() * Math.sin(target.getHeading());
        double b = 2.0 * (eX * eVelocityX + eY * (eVelocityY = target.getVelocity() * Math.cos(target.getHeading())));
        double discrim = b * b - 4.0 * (a = eVelocityX * eVelocityX + eVelocityY * eVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = (Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2)) + (double)(this.self.getTime() - target.getTime());
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + this.self.getX() + eVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + this.self.getY() + eVelocityY * time, bounds[2], bounds[3]);
            this.self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(endX - this.self.getX(), endY - this.self.getY()) - this.self.getGunHeadingRadians())));
            this.setFireBullet(BULLET_POWER);
        }
        return new double[]{endX, endY, time};
    }

    public Point2D.Double constantTurnPredict(Enemy target, double BULLET_POWER) {
        double turnRate = target.getLatestTurnRate();
        double relX = target.getX() - this.self.getX();
        double relY = target.getY() - this.self.getY();
        double cHeading = target.getHeading();
        double velocity = target.getVelocity();
        double selfX = this.self.getX();
        double selfY = this.self.getY();
        double deltaTime = 0.0;
        double bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER);
        while (bulletVelocity * deltaTime < Math.abs(Point2D.distance(0.0, 0.0, relX, relY))) {
            relX += velocity * Math.sin(cHeading + turnRate);
            relY += velocity * Math.cos(cHeading + turnRate);
            cHeading += turnRate;
            deltaTime += 1.0;
        }
        Point2D.Double targetCoord = Util.limitCoordinateToMap(new Point2D.Double(relX + selfX, relY + selfY));
        this.aimToCoordinate(targetCoord);
        this.setFireBullet(BULLET_POWER);
        return targetCoord;
    }

    public Point2D.Double averageMovementGun(Enemy target, double BULLET_POWER) {
        double c;
        double bulletVelocity;
        double a2;
        double a;
        double avgVelocityY;
        double avgVelocity = Analysis.getAvgVelocity(target);
        double avgHeading = Analysis.getAvgHeading(target);
        double time = -1.0;
        double endX = 0.0;
        double endY = 0.0;
        double eX = target.getX() - this.self.getX();
        double eY = target.getY() - this.self.getY();
        double avgVelocityX = avgVelocity * Math.sin(avgHeading);
        double b = 2.0 * (eX * avgVelocityX + eY * (avgVelocityY = avgVelocity * Math.cos(avgHeading)));
        double discrim = b * b - 4.0 * (a = avgVelocityX * avgVelocityX + avgVelocityY * avgVelocityY - (a2 = (bulletVelocity = Rules.getBulletSpeed((double)BULLET_POWER)) * bulletVelocity)) * (c = eX * eX + eY * eY);
        if (discrim >= 0.0) {
            double t2;
            double t1 = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
            time = (Math.min(t1, t2 = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a)) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2)) + (double)(this.self.getTime() - target.getTime());
            double[] bounds = Util.getFieldBoundsxXyY();
            endX = Util.limitValueBounds(eX + this.self.getX() + avgVelocityX * time, bounds[0], bounds[1]);
            endY = Util.limitValueBounds(eY + this.self.getY() + avgVelocityY * time, bounds[2], bounds[3]);
            this.self.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(Math.atan2(endX - this.self.getX(), endY - this.self.getY()) - this.self.getGunHeadingRadians())));
            this.setFireBullet(BULLET_POWER);
        }
        return new Point2D.Double(endX, endY);
    }
}

