package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class MyFirstAdvancedRobot extends AdvancedRobot {
    private static int moveAmount = 50;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	turnRadarRightRadians(Double.POSITIVE_INFINITY);
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	setTurnRadarLeftRadians(getRadarTurnRemainingRadians());
	
	setTurnGunRightRadians(Utils.normalRelativeAngle(getHeadingRadians() + e.getBearingRadians() - getGunHeadingRadians()));
	setFire(1);
	
	setTurnRightRadians(e.getBearingRadians() + Math.PI/2);
	setAhead(moveAmount);
    }
    
    @Override
    public void onHitWall(HitWallEvent e) {
	moveAmount = -moveAmount;
    }
}
