package wiki.twin;

import robocode.*;
import robocode.util.Utils;
import java.awt.geom.*;
import java.util.LinkedList;
import java.awt.Color;

/**
 * KomariLeader - a TwinDuel bot by Voidious, David Alves
 *
 * Bot initially derived from Komarious, a MiniBot by Voidious, later
 * receiving much more polishing by David Alves.
 *
 * CREDITS:
 *   Jamougha - gun is lifted from RaikoMicro 1.44
 *   rozu - mini-sized PrecisePrediction from Apollon
 *   Iiley - small codesize BackAsFront method
 *   PEZ - iterative WallSmoothing algorithm
 *
 * Code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */

public class KomariLeader extends TeamRobot {
	protected static double _surfStats[][][][] = new double[2][3][5][47];
    protected static Point2D.Double _myLocation;
    protected static Point2D.Double _enemyLocation;
    protected static Point2D.Double _teammateLocation = new Point2D.Double(400, 400);
    protected static LinkedList _enemyWaves;
    protected static double _oppEnergy;

    protected static EnemyWave _surfWave;
    protected static double _lastDistance;
    protected static double _surfDistance;

    protected static int _lastLastOrientation;
    protected static double _lastLatVel;
    protected static double _lastLastAbsBearingRadians;
    protected static double _lastAbsBearingRadians;
    protected static double _lastPredictedDistance;

    protected static double _goAngle;
    //protected static int _ramCounter;
    
    protected static double _targetDistance;
    protected static java.awt.geom.Rectangle2D.Double _fieldRect
    //    = new java.awt.geom.Rectangle2D.Double(18, 18, 764, 564); 
			= new java.awt.geom.Rectangle2D.Double(18, 18, 764, 764); //Dave: TwinDuel is on an 800x800 field! tsk tsk Voidious.

    // Math.PI/2 would be perpendicular movement, less will keep moving
    // further away
    //protected static final double A_LITTLE_LESS_THAN_HALF_PI = 1.35; Dave: Replaced with dynamic distancing!
    protected static final double HALF_PI = Math.PI / 2.0;
    protected static final double DESIRED_DISTANCE = 300;
    protected static final double WALL_STICK = 140;
    protected static final int SURF_MIDDLE_BIN = 23;

    ////////////////////////////////////////////////////////
    // RaikoMicro's gun

    protected static double lastVChangeTime;
    protected static int enemyVelocity;
    protected static final int GF_ZERO = 23;
    protected static final int GF_ONE = 46;
    protected static double[][][][][] _gunStats = new double[5][5][2][4][GF_ONE+1];

    ////////////////////////////////////////////////////////

    protected String _targetName = "";
    protected boolean _teammateAlive = true;
    
    public void run() {
        setColors(Color.black, null, Color.white);

        _enemyWaves = new LinkedList();
        setAdjustGunForRobotTurn(true);
        setAdjustRadarForGunTurn(true);
        _targetDistance = Double.POSITIVE_INFINITY;
        
        do {
            turnRadarRightRadians(Double.POSITIVE_INFINITY);
        } while (true);

    }

    public void onScannedRobot(ScannedRobotEvent e) {
    	// Don't process scan for teammate
    	if (isTeammate(e.getName())) { return; }
    	
    	if (e.getDistance() <= _targetDistance 
        		|| _targetName.equals(e.getName())) {
        		_targetName = e.getName();
    			_targetDistance = e.getDistance();
        }
    	
    	// If this is our team's target, or there's only 1 opponent left,
    	// process this one.
    	if (!(_targetName.equals(e.getName()) 
    		|| getOthers() == 1 + (_teammateAlive?1:0))) {
    		return;
    	}
    	   	
        double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
        setTurnRadarRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()) * 2);

        double bulletPower;
        if ((bulletPower = _oppEnergy - e.getEnergy()) <= 3
            && bulletPower > 0) {
            EnemyWave ew;
            addCustomEvent(ew = new EnemyWave());
            ew.bulletVelocity = bulletVelocity(bulletPower);
            ew.directAngle = _lastLastAbsBearingRadians;
            ew.sourceLocation = _enemyLocation;
            ew.orientation = _lastLastOrientation;
            ew.waveGuessFactors = _surfStats[_fieldRect.contains(project(_enemyLocation, _lastLastAbsBearingRadians + (_lastLastOrientation*maxEscapeAngle(ew.bulletVelocity)/2), _lastDistance))?0:1][(int)(Math.min(_lastDistance/250, 2))][(int)((Math.abs(_lastLatVel))/2)];
            _enemyWaves.add(ew);
        }

//        _oppEnergy = e.getEnergy(); // MC (done in gun normally)

        _enemyLocation =
            project((_myLocation = new Point2D.Double(getX(), getY())),
            enemyAbsoluteBearing, _lastDistance = e.getDistance());

        try {
        	broadcastMessage(new KomariLocation(getX(), getY()));;
        } catch (Exception ex) { }
        
        // WaveSurfing /////////////////////////////////////////////////////////
        int direction = (_lastLastOrientation = sign(_lastLatVel));
        if (!_enemyWaves.isEmpty()) {
            double angleFromWaveSource = absoluteBearing(
                (_surfWave = (EnemyWave)(_enemyWaves.getFirst())).sourceLocation,
                _myLocation);

            _goAngle = angleFromWaveSource +
                directedGoAngle(direction = (sign(checkDanger(-1) - checkDanger(1))));
        }

        moveWithBackAsFront(wallSmoothing(_myLocation, _goAngle, direction));

        ////////////////////////////////////////////////////////
        // CREDIT: RaikoMicro's gun, by Jamougha
        // http://robowiki.net?RaikoMicro

        /////
        // TC
/*
        _enemyLocation =
            project((_myLocation = new Point2D.Double(getX(), getY())),
            enemyAbsoluteBearing, _lastDistance = e.getDistance());
*/
        /////

        // ------------- Fire control -------
        double theta;
        MicroWave w;
        addCustomEvent(w = new MicroWave());
        w.orientation = sign((theta = e.getVelocity())*Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing));
        w.bulletVelocity = 14.3;
//        w.bulletVelocity = 11D; // TC

        int bestGF = Math.min(3, (int)(Math.sqrt(253D*lastVChangeTime++/_lastDistance)))+1;
//        int bestGF = Math.min(4, (int)(Math.sqrt(195D*lastVChangeTime++/_lastDistance)))+1; // TC
        if (enemyVelocity > (enemyVelocity = (int)Math.abs(theta))){
            lastVChangeTime = 0;
            bestGF = 0;
        }
        w.sourceLocation = _myLocation;
        w.directAngle = enemyAbsoluteBearing;
        w.waveGuessFactors = _gunStats[bestGF][(int)((enemyVelocity+1)/2)][_fieldRect.contains(project(_myLocation, enemyAbsoluteBearing + (w.orientation*.395807), _lastDistance)) ? 0 : 1][(int)(_lastDistance+100)/275];
//        w.waveGuessFactors = _gunStats[bestGF][(int)((enemyVelocity+1)/2)][_fieldRect.contains(project(_myLocation, enemyAbsoluteBearing + (w.orientation*.542892), _lastDistance)) ? 0 : 1][(int)(_lastDistance+100)/275]; // TC

        bestGF = GF_ZERO;

        for (int gf = GF_ONE; gf >= 0 && (_oppEnergy = e.getEnergy()) > 0; gf--) //Saves one byte compared to going up, weird
            if (w.waveGuessFactors[gf] > w.waveGuessFactors[bestGF])
                bestGF = gf;

        setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() + ((w.orientation*.0258135)*(bestGF-GF_ZERO)) ));
//        setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() + ((w.orientation*.035406)*(bestGF-GF_ZERO)) )); // TC

        //if (getEnergy() > 2 && Math.abs(getGunTurnRemaining()) < 3 && setFireBullet(1.9 + (_ramCounter / (3*getRoundNum()+1))) != null) {
        if (getEnergy() > 2 && Math.abs(getGunTurnRemaining()) < 3 && setFireBullet(_lastDistance < 175?3:1.9) != null) { //Dave: We use distance 175 to correspond with the border of our distance segmentation
//        if (Math.abs(getGunTurnRemaining()) < 3 && setFireBullet(3) != null) { // TC
            w.weight = 4;
        }

        ////////////////////////////////////////////////////////

        _lastLatVel = getVelocity()*Math.sin(e.getBearingRadians());
        _lastLastAbsBearingRadians = _lastAbsBearingRadians;
        _goAngle = _lastAbsBearingRadians = enemyAbsoluteBearing + Math.PI;
    }
    
    public void onMessageReceived(MessageEvent e) {
    	/*
    	if (e.getMessage() instanceof String) {
    		_targetName = (String)e.getMessage();
    	} else {
    		KomariLocation loc = (KomariLocation)e.getMessage();
    		_teammateLocation = new Point2D.Double(loc.x, loc.y);
    	}*/
    	try{ //Dave: try/catch is smaller than if/else.
    		_targetName = (String)e.getMessage();
    	} catch(Exception ex){
    		KomariLocation loc = (KomariLocation)e.getMessage();
    		_teammateLocation = new Point2D.Double(loc.x, loc.y);
    	}
    }

    public void onHitByBullet(HitByBulletEvent e) {

        if (!_enemyWaves.isEmpty() && (_surfDistance < 100)) {

            // The waves are removed quickly enough that it's possible
            // I could be hit by a bullet on a wave that's been removed...
            // logging that could really screw up the stats.
            logHit(_surfWave, _myLocation, 2);
        }
    }
    /* Dave: Don't need this in teams. Not a lot of good ramming teams out there.
    public void onHitRobot(HitRobotEvent event) {
        _ramCounter++;
    }*/
    
    public void onRobotDeath(RobotDeathEvent e) {
    	if (isTeammate(e.getName())) {
    		_teammateAlive = false;
    	}
    	_targetDistance = Double.POSITIVE_INFINITY;
    	_targetName = "";
    }

    public void logHit(Wave w, Point2D.Double targetLocation, int rollingDepth) {
        for (int x = 46; x >= 0; x--) {
            w.waveGuessFactors[x] = ((w.waveGuessFactors[x] * rollingDepth)
                + ((1 + w.weight) / (Math.pow(x - getFactorIndex(w, targetLocation), 2) + 1)))
                / (rollingDepth + 1 + w.weight);
        }
    }

    protected static int getFactorIndex(Wave w, Point2D.Double botLocation) {
        return (int)limit(0,
            ((((Utils.normalRelativeAngle(
            absoluteBearing(w.sourceLocation, botLocation)
            - w.directAngle) * w.orientation)
            / maxEscapeAngle(w.bulletVelocity))
            * (SURF_MIDDLE_BIN)) + (SURF_MIDDLE_BIN)), 46);
    }

    protected double checkDanger(int direction) {
    	Point2D.Double predictedPosition;
        int index = getFactorIndex(_surfWave, 
        	predictedPosition = predictPosition(direction));

        return (_surfWave.waveGuessFactors[index]
            + (.01 / (Math.abs(index - SURF_MIDDLE_BIN) + 1)))
            * Math.pow(_lastDistance/_lastPredictedDistance, 4)
            * (predictedPosition.distance(_teammateLocation) < 200?5:1); //Dave: changed teammate danger distance to 200 
    }

    protected double directedGoAngle(int direction) {
        //return (direction * A_LITTLE_LESS_THAN_HALF_PI);
    	return direction * (HALF_PI + (getTime() < 25?1:.35) * sign(_lastDistance - DESIRED_DISTANCE));
    }

    // CREDIT: mini sized predictor from Apollon, by rozu
    // http://robowiki.net?Apollon
    protected Point2D.Double predictPosition(int direction) {
        Point2D.Double predictedPosition = (Point2D.Double)_myLocation.clone();
        double predictedVelocity = getVelocity();
        double predictedHeading = getHeadingRadians();
        double maxTurning, moveAngle, moveDir;

        // - actual distance traveled so far needs +bullet_velocity,
        //    because it's detected one after being fired
        // - another +bullet_velocity b/c bullet advances before collisions
        // ...So start the counter at 2.
        int counter = 2;

        do {
            moveAngle =
                wallSmoothing(predictedPosition, absoluteBearing(_surfWave.sourceLocation,
                //predictedPosition) + (direction * (A_LITTLE_LESS_THAN_HALF_PI)), direction) //This should use directedGoAngle()
                predictedPosition) + (directedGoAngle(direction)), direction)
                - predictedHeading;
            moveDir = 1;

            if (Math.cos(moveAngle) < 0) {
                moveAngle += Math.PI;
                moveDir = -1;
            }

            moveAngle = Utils.normalRelativeAngle(moveAngle);

            // maxTurning is built in like this, you can't turn more then this in one tick
            maxTurning = Math.PI/720d*(40d - 3d*Math.abs(predictedVelocity));
            predictedHeading = Utils.normalRelativeAngle(predictedHeading + limit(-maxTurning, moveAngle, maxTurning));

            // this one is nice ;). if predictedVelocity and moveDir have different signs you want to breack down
            // otherwise you want to accelerate (look at the factor "2")
//            predictedVelocity += (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir);
//            predictedVelocity = limit(-8,
//                predictedVelocity + (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir),
//                8);

            // calculate the new predicted position
            predictedPosition = project(predictedPosition, predictedHeading,
                (predictedVelocity = limit(-8,
                predictedVelocity + (predictedVelocity * moveDir < 0 ? 2*moveDir : moveDir),
                8)));

            if ((_lastPredictedDistance =
                predictedPosition.distance(_surfWave.sourceLocation)) - 15 <
                _surfWave.distance + ((++counter) * _surfWave.bulletVelocity)) {
                break;
            }
    	} while(true);

        return predictedPosition;
    }

    protected static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    protected static double bulletVelocity(double power) {
        return (20.0 - (3.0*power));
    }

    protected static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0/velocity);
    }

    // CREDIT: ganked from CassiusClay, by PEZ
    // http://robowiki.net?CassiusClay
    protected static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
            sourceLocation.y + Math.cos(angle) * length);
    }

    protected static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    static int sign(double d) {
        return (d >= 0) ? 1 : -1;
    }

    // CREDIT: code by Iiley,
    // http://robowiki.net?BackAsFront
    void moveWithBackAsFront(double bearing) {
        double angle = Utils.normalRelativeAngle(bearing - getHeadingRadians());
        double turnAngle;
        setTurnRightRadians(turnAngle = Math.atan(Math.tan(angle)));
        setAhead((angle == turnAngle) ? 100 : -100);
    }

    // CREDIT: Iterative WallSmoothing by PEZ
    // http://robowiki.net?WallSmoothing
    public double wallSmoothing(Point2D.Double botLocation, double angle, int orientation) {
        while (!_fieldRect.contains(project(botLocation, angle, WALL_STICK))) {
            angle += orientation*0.05;
        }
        return angle;
    }

    abstract class Wave extends Condition {
        Point2D.Double sourceLocation;
        double[] waveGuessFactors;
        double bulletVelocity, directAngle, distance;
        int orientation, weight;
    }
    
    class EnemyWave extends Wave {
        public boolean test(){
            if ((KomariLeader._myLocation).distance(sourceLocation)
                <= (distance+=bulletVelocity) + (2*bulletVelocity)) {
//                logHit((Wave)_enemyWaves.removeFirst(),
//                    KomariLeader._myLocation, 500);
                _enemyWaves.removeFirst();
                removeCustomEvent(this);
            }
            return false;
        }
    }

    class MicroWave extends Wave {
        public boolean test(){
            if ((KomariLeader._enemyLocation).distance(sourceLocation)
                <= (distance+=bulletVelocity) + 7.15){
//                <= (distance+=bulletVelocity) + 8.25){ // TC
                logHit(this, KomariLeader._enemyLocation, 600);
                removeCustomEvent(this);
            }
            return false;
        }
    }
}



