package ph;
import java.awt.geom.*;

public abstract class utils {
    
    public static double battlefieldWidth;
    public static double battlefieldHeight;
    
    public static double normalRelativeAngleDiff(double angle1, double angle2) {
        double diff1=Math.abs(angle1-angle2);
        double diff2=0;
        if(angle1>angle2)
            diff2=Math.abs((angle1-360)-angle2);
        else
            diff2=Math.abs(angle1-(angle2-360));
        
        if(diff1<diff2) {
            if(angle1>angle2)
                return -diff1;
            else
                return diff1;
        } else {
            if(angle1>angle2) {
                return diff2;
            } else {
                return -diff2;
            }
        }
    }
    
    public static double normalAngle(double angle) {
        while(angle<0) angle +=360;
        angle %= 360;
        return angle;
    }
    
    public static double normalRelativeAngle(double angle) {
        if (angle > -180 && angle <= 180)
            return angle;
        double fixedAngle = angle;
        while (fixedAngle <= -180)
            fixedAngle += 360;
        while (fixedAngle > 180)
            fixedAngle -= 360;
        return fixedAngle;
    }
    
    public static long gunTurnTime(double enemyBearing, double gunHeading) {
        return Math.round(Math.abs(normalRelativeAngle(enemyBearing-gunHeading)/20));
    }
    
    public static long bulletTravelTime(double distance, double power) {
        return Math.round(distance/(20-3*power));
    }
    
    public static long timeToHit(double enemyBearing, double enemyDistance, 
    double gunHeading, double bulletPower) {
        
        double t=gunTurnTime(enemyBearing,gunHeading)
        +bulletTravelTime(enemyDistance,bulletPower);
        return (long)t;
    }
    
    public static double firePowerToHit(double enemyBearing, 
    double enemyDistance, double gunHeading, long timeToHit) {
       long gunTurnTime=gunTurnTime(enemyBearing, gunHeading);
       if(gunTurnTime>=timeToHit) return -1;
       double power= 60-((3*enemyDistance)/(timeToHit-gunTurnTime));
       if(power>3) return -1;
       return power;
    }
    
    /**return the distance between (x1,y1) and (x2,y2)
     * @author Hanji */
    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1-x2)*(x1-x2)+(y1-y2)*(y1-y2));
    }
    
    /**returns the bearing from (x1,y1) to (x2,y2) in degrees
     * @author Hanji*/
    public static double getBearing( double x1,double y1, double x2,double y2 ) {
        double xo = x2-x1;
        double yo = y2-y1;
        return Math.toDegrees(Math.atan2(xo,yo));
    }
    
    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.toDegrees(Math.atan2(target.getX() - source.getX(), target.getY() - source.getY()));
    }
    
    public static Point2D.Double guessPositionCL(long when, long time, double x, double y, double speed, double heading, double changehead) {
        /**time is when our scan data was produced.  when is the time
         * that we think the bullet will reach the target.  diff is the
         * difference between the two **/
        double diff = when - time;
        double newX, newY;
        /**if there is a significant change in heading, use circular
         * path prediction**/
        if (Math.abs(changehead) > 0.00001) {
            double radius = speed/changehead;
            double tothead = diff * changehead;
            newY = y + (Math.sin(heading + tothead) * radius) -
            (Math.sin(heading) * radius);
            newX = x + (Math.cos(heading) * radius) -
            (Math.cos(heading + tothead) * radius);
        }
        /**if the change in heading is insignificant, use linear
         * path prediction**/
        else {
            newY = y + Math.cos(heading) * speed * diff;
            newX = x + Math.sin(heading) * speed * diff;
        }
        return new Point2D.Double(newX, newY);
    }
    
    public static double damageByBullet(double firePower) {
        //4 * firepower. If firepower > 1, it does an additional 2 * (power - 1).
        double damage;
        if(firePower>1) damage=(6*firePower)-2; else damage=4*firePower;
        return damage;
    }
    
    public static double normaliseFirePower(double firePower) {
        if(firePower<0.1)
            return 0.1;
        else if (firePower>3)
            return 3;
        else
            return firePower;
    }
    
    public static double neededFirePower(double desiredDamage) {
        double power1=normaliseFirePower(0.25*desiredDamage);
        double power2=normaliseFirePower((desiredDamage+1)/6);
        if(power2>1)
            return Math.min(power1,power2);
        else
            return power1;
    }
    
    /** @author nano */
    public static double pointToLineDistance(Point2D point, Line2D line) {
        return Math.abs((line.getX2() - line.getX1()) * (line.getY1() - point.getY()) - (line.getX1() - point.getX()) * (line.getY2() - line.getY1())) /
        lineLength(line);
    }
    
    /** @author nano */
    public static double lineLength(Line2D line) {
        return Math.sqrt(Math.pow(line.getX2() - line.getX1(), 2) + Math.pow(line.getY2() - line.getY1(), 2));
    }
    
    
    /** @author nano */
    public static Point2D closestPointOnLine(Point2D point, Line2D line) {
        double distance = pointToLineDistance(point, line);
        double length = lineLength(line);
        return new Point2D.Double(point.getX() - distance * (line.getX2() - line.getX1()) / length, point.getY() + distance * (line.getY2() - line.getY1()) / length);
    }
    
}
