package gh.ghutils;

import java.awt.geom.*;

/**
 * BotState
 *
 * This class represents a single state of a robot (me or opponent).
 * Credit: Insprired by Dookious by Voidious
 *
 * This code is open source, released under the RoboWiki Public Code License:
 * http://robowiki.net/cgi-bin/robowiki?RWPCL
 */

public class BotState
{
    private Point2D.Double position;
    private double absBearing;
    private double bearing;
    private double heading;
    private double distance;
    private double speed;
    private double energy;
    private int    direction;
	private int    accbin;
	private int    velbin;
	private int    walbin;
	private int    d14bin;
    private long   time;

    public BotState(Point2D.Double p, double ab, double b, double h, double d, double v, double e,
                    int dir, int abin, int vbin, int wbin, int dbin, long t) {
    	position = p;
        absBearing = ab;
    	bearing = b;
    	heading = h;
        distance = d;
        speed = v;
        energy = e;
        direction = dir;
		accbin = abin;
		velbin = vbin;
		walbin = wbin;
		d14bin = dbin;
        time = t;
    }

    public BotState() {    }

    public double getAbsBearing() {
        return absBearing;
    }

    public double getHeading() {
        return heading;
    }

    public double getDistance() {
        return distance;
    }

    public double getSpeed() {
        return speed;
    }

    public double getEnergy() {
        return energy;
    }

    public int getAccBin() {
        return accbin;
    }

    public int getVelBin() {
        return velbin;
    }

    public int getWallBin() {
        return walbin;
    }

    public int getDL14Bin() {
        return d14bin;
    }
    
    public Point2D.Double getPosition() {
    	return position;
    }
    
    public int getDirection() {
        return direction;
    }

}
