package tm;
import robocode.*;

/********************************************************************
* Gun15B.java -- Cg̉]p̎Zo
*				ASY15, Gun1on1_103(MogBot)
*               Radar360B p
*
* Date:		2003/Jan/11
* Author:	Matunaga Takateru
*
********************************************************************/
class Gun15B implements Gun {
	MyRobot my;
	FieldMap map;
	double fW, fH;
	Radar360B radar;
	EnemyHistory4Melee ehism;
	EnemyMoveAnalyzer4Melee analyzer;
	
	//------------------------------------------------------------------
	// constructor
	//
	//
	//------------------------------------------------------------------
	public Gun15B(MyRobot my) {
		this.my = my;
		this.map = my.map;
		fW = my.fW;
		fH = my.fH;
		this.radar = (Radar360B)my.radar;
		this.ehism = my.ehism4;
		this.analyzer = new EnemyMoveAnalyzer4Melee(ehism, my);
	}
	
	//------------------------------------------------------------------
	// put()
	//
	//
	//------------------------------------------------------------------
	public void put(double x, double y, double distance, double velocity, double heading, double bearing, long t, String name) {
		ehism.put(x, y, distance, velocity, heading, bearing, t, name);
	}
	
	//------------------------------------------------------------------
	//
	//
	//
	//------------------------------------------------------------------
	public void fire() {
		Enemy ene = map.getNearestEnemy(my.getTime());
		if (ene == null) return;


		if (my.getGunHeat() > 0.2) return;
		
		double dx, dy;						//GWƂ̍
		double bulletPower;
		double angle;
		double distance;					//GƂ̋
		
		
		dx = ene.getX() - my.getX();
		dy = ene.getY() - my.getY();
		distance = Math.sqrt(dx*dx + dy*dy);
		double myEne = my.getEnergy();
		
		//߂Gɂ͎v
		if (myEne > 80) {
			//SB6	
			if (distance < 300)      bulletPower = 3;
			else if (distance < 900) bulletPower = 4 - (distance / 300);
			else                     bulletPower = 3.25 - (distance / 400);
		} else if (myEne > 40) {
			//SB4
			if (distance < 200) bulletPower = 3;
			else bulletPower = 3.8 - (distance / 250);
		} else {
			//
			if (distance < 150) bulletPower = 3;
			else bulletPower = 3 - ((distance - 150) / 200);
		}
		
		
		if (myEne < 16) bulletPower *= myEne / 16;
				
		if (bulletPower < 0.1) bulletPower = 0.1;

		
		if (myEne - bulletPower <= 0.2) return;

		
		//Cg̉]p̎Zo
		angle = getTurnAngle(my, ene, bulletPower);

		my.setTurnGunRight(angle);
		
		if (my.getGunHeat() != 0) return;


		//px傫ƂfireȂ
		//fire\Ȋpx(CgƓG)
		double canFireAngle =  Math.toDegrees(Math.atan2(my.robotSize / 2, ene.getDistance()));
		if (Math.abs(angle) >= canFireAngle * 2) return;

		
		my.result.fire();
		Bullet bullet = my.setFireBullet(bulletPower);
		if (bullet == null) return;
		long timeToImpact = (long)(distance / bullet.getVelocity() + 0.5);		//B
		timeToImpact += (long)(timeToImpact * 8.0 / bullet.getVelocity() + 0.5);	//ɓGړl
		BulletTracker bt = new BulletTracker(my, bullet, ene, timeToImpact, 0);


		if (radar == null) {
			radar = (Radar360B)my.radar;
		}
		radar.turn360();
	}
	
	
	//------------------------------------------------------------------
	// getTurnAngle() -- Cg̉]p̎Zo
	//
	// F	my -- 
	//			ene -- G
	// ߂lF	-180 < theta <= 180
	//------------------------------------------------------------------
	double getTurnAngle(Robot my, Enemy ene, double bulletPower) {
		double epX = 0, epY = 0;			//enemy predicteed X, Y
		double bulletVelocity = 20 - 3 * bulletPower;
		double bulletTime = ene.getDistance() / bulletVelocity;		//eۓB
		Point po;

	
		if (ene.getDistance() < 60) {
			//G݈ʒuGun]
			double absBearing = ene.getBearing() + my.getHeading();
			return M.angleUnder180(absBearing - my.getGunHeading());
		} else if (ene.getDistance() < 100) {
			//Gis\ʒuGun]
			return gun3(my, ene, bulletPower);
		} else {
			//ʗ\
			po = analyzer.getPredictedEnemyPoint4((int)bulletTime, ene.getHeading(), my.getTime(), bulletVelocity, ene.getX(), ene.getY(), my.getX(), my.getY(), ene.getName());
		}
		
		if (po == null) return gun3(my, ene, bulletPower);
		
		epX = ene.getX() + po.x;
		epY = ene.getY() + po.y;
		
		if (epX < 20)           epX = 20;
		else if (epX > fW - 20) epX = fW - 20;
		if (epY < 20)           epY = 20;
		else if (epY > fH - 20) epY = fH - 20;
			
		double angle = M.point2degree(my.getX(), my.getY(), epX, epY);
		angle = 90 - angle;								//G̐ΕC̍W
		angle = angle - my.getGunHeading();				//GCCg̊px
		angle = M.angleUnder180(angle);
		
		return angle;
	}
	
	
	//------------------------------------------------------------------
	// gun3()
	//
	// F	my -- 
	//			ene -- G
	// ߂lF	-180 < theta <= 180
	//------------------------------------------------------------------
	double gun3(Robot my, Enemy ene, double bulletPower) {
		double moveAngleRad = Math.toRadians(90 - ene.getHeading());		//G̈ړ
		double dtime = my.getTime() - ene.getMtime();		//ԍ
		double eX, eY;			//\zGW
		double myX, myY;
		double angle;
		
		eX = ene.getX() + Math.cos(moveAngleRad) * ene.getVelocity() * dtime;
		eY = ene.getY() + Math.sin(moveAngleRad) * ene.getVelocity() * dtime;

		if (eX < 20)           eX = 20;
		else if (eX > fW - 20) eX = fW - 20;
		if (eY < 20)           eY = 20;
		else if (eY > fH - 20) eY = fH - 20;

		myX = my.getX();
		myY = my.getY();
		
		//ɒeۓBԂZ
		double bulletVelocity = 20 - 3 * bulletPower;
		double bulletTime = (ene.getDistance() - 20) / bulletVelocity;		//eۓB
		
		//eۓBԂQIɎZo
		double diffTime = 9999999;
		int i = 0;
		//15܂͎ԍ0.01timeȉ܂ŎZo
		while (i < 15 && diffTime > 0.01) {
			//GW
			double tmpEX = eX + Math.cos(moveAngleRad) * ene.getVelocity() * bulletTime;
			double tmpEY = eY + Math.sin(moveAngleRad) * ene.getVelocity() * bulletTime;

			if (tmpEX < 20)           tmpEX = 20;
			else if (tmpEX > fW - 20) tmpEX = fW - 20;
			if (tmpEY < 20)           tmpEY = 20;
			else if (tmpEY > fH - 20) tmpEY = fH - 20;

			double dx = my.getX() - tmpEX;
			double dy = my.getY() - tmpEY;
			double distance = Math.abs(Math.sqrt(dx*dx+dy*dy) - 20);		//{bg傫l
			double newBulletTime = distance / bulletVelocity;
			diffTime = Math.abs(newBulletTime - bulletTime);
			bulletTime = newBulletTime;
			i++;
		}
		
		eX += Math.cos(moveAngleRad) * ene.getVelocity() * bulletTime;
		eY += Math.sin(moveAngleRad) * ene.getVelocity() * bulletTime;

		if (eX < 0) eX = 20;
		else if (eX > my.getBattleFieldWidth()) eX = my.getBattleFieldWidth() - 20;
		if (eY < 0) eY = 20;
		else if (eY > my.getBattleFieldHeight()) eY = my.getBattleFieldHeight() - 20;
	
		angle = M.point2degree(my.getX(), my.getY(), eX, eY);
		angle = 90 - angle;						//G̐ΕC̍W
		angle = angle - my.getGunHeading();		//GCCg̊px
		angle = M.angleUnder180(angle);
		
		return angle;
	}

	//---------------------------------------
	// bulletTrackComplete() -- CeǐՊ
	//
	//--------------------------------------
	public void bulletTrackComplete(BulletTracker bt) {
		if (bt.hitTarget()) {
			my.result.hit();
		}
	}
	
	//--------------------------------------
	// bulletHit()
	//
	//--------------------------------------
	public void bulletHit(BulletHitEvent e) {
		my.result.hitAnyone();
	}

}