package sgp;
import robocode.*;
import java.util.*;

/**
 * DrunkenStrategyManager - a class by Simon Parker
 */

public class DrunkenStrategyManager extends Object
{
	public final int TEAM_LEADER_STRATEGY_ID = 3;
	public final int DRUNKEN_SOLDIER_STRATEGY_ID = 4;

	public int currentStrategyId = DRUNKEN_SOLDIER_STRATEGY_ID;

	private Strategy teamLeaderStrategy = null;
	private Strategy drunkenSoldierStrategy = null;


	public DrunkenStrategyManager()
	{
		teamLeaderStrategy = new TeamLeaderStrategy(this);
		drunkenSoldierStrategy = new DrunkenSoldierStrategy(this);
	}

	public void setStrategyId(int newStrategyId)
	{
		if (newStrategyId != currentStrategyId)
		{
			currentStrategyId = newStrategyId;
		}
	}

	public void reset()
	{
		teamLeaderStrategy.reset();
		drunkenSoldierStrategy.reset();
	}

	public Strategy getStrategy()
	{
		Strategy currentStrategy = null;
		switch (currentStrategyId)
		{
			case TEAM_LEADER_STRATEGY_ID:
				currentStrategy = teamLeaderStrategy;
				break;
			case DRUNKEN_SOLDIER_STRATEGY_ID:
				currentStrategy = drunkenSoldierStrategy;
				break;
		}
		return currentStrategy;
	}

	public String getStrategyName(int id)
	{
		String name = "Unknown Strategy";
		switch (currentStrategyId)
		{
			case TEAM_LEADER_STRATEGY_ID:
				name = "Team Leader";
				break;
			case DRUNKEN_SOLDIER_STRATEGY_ID:
				name = "Drunken Soldier";
				break;
		}
		return name;
	}


}