package ntc.slippery;
import robocode.*;
import robocode.util.Utils;
import java.io.*;
import java.awt.geom.*;
import java.awt.Color;

public class Leader1 extends TeamRobot
{
	
	public void run(){
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		turnRadarRightRadians(Utils.normalRelativeAngle(Math.toRadians(270)-getRadarHeadingRadians()));
		setTurnRightRadians(Utils.normalRelativeAngle(Math.toRadians(270)-getHeadingRadians()));
		setAhead(5000);		
		execute();		
		setBulletColor(Color.YELLOW);
		while(true){
			turnRadarRightRadians(Math.PI);
			turnRadarLeftRadians(Math.PI);
		}
	}

	public void onScannedRobot(ScannedRobotEvent e){
		if(isTeammate(e.getName())){ return; }
		double bulletPower = 2;
		double myX = getX();
		double myY = getY();
		double absoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyX = getX() + e.getDistance() * Math.sin(absoluteBearing);
		double enemyY = getY() + e.getDistance() * Math.cos(absoluteBearing);
		double enemyHeading = e.getHeadingRadians();
		double enemyVelocity = e.getVelocity();		
		double deltaTime = 0;
		double battleFieldHeight = getBattleFieldHeight(), battleFieldWidth = getBattleFieldWidth();
		double predictedX = enemyX, predictedY = enemyY;
		while((++deltaTime) * (20.0 - 3.0 * bulletPower) < Point2D.Double.distance(myX, myY, predictedX, predictedY)){		
			predictedX += Math.sin(enemyHeading) * enemyVelocity;	
			predictedY += Math.cos(enemyHeading) * enemyVelocity;
			if(	predictedX < 18.0 
				|| predictedY < 18.0
				|| predictedX > battleFieldWidth - 18.0
				|| predictedY > battleFieldHeight - 18.0){
				predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);	
				predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
				break;
			}
		}
		try{
			broadcastMessage(new Point2D.Double(predictedX,predictedY));
		}catch(IOException exc){
			out.println("Broadcasting error:" + e);
		}
	
		if(getEnergy()>10 && getGunTurnRemaining()<5){
			setTurnGunRightRadians(Utils.normalRelativeAngle(TeamDroid.absoluteBearing(new Point2D.Double(getX(),getY()),new Point2D.Double(predictedX,predictedY))-getGunHeadingRadians()));
			setFire(2);
		}
	}
	
	public void onHitWall(HitWallEvent e){
		turnRightRadians(Math.PI/2);
		turnRadarRightRadians(Math.PI/2);
		setAhead(5000);
		execute();
	}

	public void onHitRobot(HitRobotEvent e){
		turnRightRadians(Math.PI/2);
		turnRadarRightRadians(Math.PI/2);
		setAhead(5000);
		execute();
	}
	
	public void onRobotDeath(RobotDeathEvent e){
		out.print(e.getName() + " died ");
		if(isTeammate(e.getName())){
			out.println(":(");
		}else{
			out.println(":)");
		}
	}
			
}