package bvh.fry;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import robocode.*;
import robocode.util.Utils;

/**
 * innerclass met de Doel.
 */
class Doel extends Point2D.Double implements Constanten {
   String    naam;
   boolean   actief;
   long      scanTijd;
   long      tijdSindsStilstand;
   long      kanonAfkoelTijd;
   long      treffers;
   long      treffersFreya;
   long      schoten;
   long      schotenFreya;
   double    richting;
   double    bewegingsrichting;
   double    energie;
   double    snelheid;
   double    lateraleSnelheid;
   double    transversaleSnelheid;
   double    versnelling;
   double    gemSnelheid;
   double    cirkelRichting;
   double    gemKogelkracht;
   double    gemKogelkrachtFreya;
   double    gemAfstand;
   double    deltaBewegingsRichting, oudeBewegingsRichting;
   ArrayList golven = new ArrayList();
   ArrayList doelGolven = new ArrayList();
   static double[][][][][][][] trageGFStats = new double[SLAGKARAKTERISERING]
                                 [POSITIESEGMENTEN]
                                 [AFSTANDSEGMENTEN + 1]
                                 [LATERALESNELHEIDSSEGMENTEN]
                                 [TRANSVERSALESNELHEIDSSEGMENTEN]
                                 [VERSNELLINGSSEGMENTEN]
                                 [2 * GF_MIDDEN + 1];
   static double[][][]         snelleGFStats = new double[AFSTANDSEGMENTEN + 1]
                                 [LATERALESNELHEIDSSEGMENTEN]
                                 [2 * GF_MIDDEN + 1];

   /**
    * Creates a new Doel object.
    *
    * @param naam DOCUMENT ME!
    */
   public Doel(String naam) {
      this.naam = naam;
      this.actief = false;
      this.energie = 100D;
      this.gemSnelheid = 8D;
      this.gemKogelkracht = this.gemKogelkrachtFreya = 2D;
      this.treffers = 0;
      this.treffersFreya = 1; // om delen door nul te voorkomen.
      this.tijdSindsStilstand = 0;
      this.cirkelRichting = 1D;
      this.kanonAfkoelTijd = 0;
   }

   public void bijwerken(ScannedRobotEvent evt, Freya freya, long tijd, double richting) {
//      System.out.println("Doel.bijwerken():");

      this.actief = true;
      long tijdSindsLaatsteScan = tijd - this.scanTijd;

      // probeer de kracht van de door de tegenstander afgevuurde kogel in te schatten
      // (controleer of energieverschil optrad tussen twee opeenvolgende scans omdat
      // de oorzaak anders mogelijk het gevolg is van een combinatie van factoren):
      double deltaE = this.energie - (this.energie = evt.getEnergy());

      if ((deltaE > 0D && deltaE <= 3D) && tijdSindsLaatsteScan == 1) {
         // afvuren doelgolf voor echt afgevuurde kogel 
//System.out.println("Doel.bijwerken(): doel heeft kogel afgevuurd: doelGolf aanmaken.");
         this.kanonAfkoelTijd = (long)(10D*(0.90D + deltaE/5D))-1;
         this.gemKogelkracht += deltaE;
         this.schoten++;
      }

      this.kanonAfkoelTijd = Math.max(this.kanonAfkoelTijd-tijdSindsLaatsteScan, 0);
      
      this.richting = richting + evt.getBearingRadians();
      this.bewegingsrichting = evt.getHeadingRadians();
      this.versnelling = (Math.abs(evt.getVelocity()) - Math.abs(this.snelheid)) / tijdSindsLaatsteScan;
      this.snelheid = evt.getVelocity();
      this.setLocation(BotUtils.projecteerPositie(freya.positie, this.richting, evt.getDistance()));

      this.lateraleSnelheid = this.snelheid * Math.sin(this.bewegingsrichting - this.richting);
      this.transversaleSnelheid = this.snelheid * Math.cos(this.bewegingsrichting - this.richting);
      this.gemSnelheid = 0.85 * this.gemSnelheid + 0.15 * this.snelheid;
      this.gemAfstand = 0.85 * this.gemAfstand + 0.15 * this.distance(freya.positie);

      this.tijdSindsStilstand += tijdSindsLaatsteScan; // corrigeren voor tijd sinds laatste scan

      if (this.snelheid == 0) {
         this.tijdSindsStilstand = 0;
      } else {
         this.cirkelRichting = this.lateraleSnelheid < 0 ? -1D : 1D;
      }

      this.scanTijd = tijd;

      // controleer afgevuurde test-golven:
      bijwerkenGolven(tijd);

   }

   public void bijwerkenGolven(long tijd) {
//      System.out.println("Doel.bijwerkenGolven():");
      Iterator it = golven.iterator();

      while (it.hasNext()) {
         Golf g = (Golf) it.next();
         if (g.voorbijDoel((Point2D.Double)this, tijd)) {
            it.remove();
         }
      }
   }
   
   public void resetGolven() {
      golven.clear();
   }
   
   /**
    * schat de postie van het doel op basis van een lineaire beweging met de huidige
    * snelheid over een periode van n tik.
    *
    * @return de geschatte postie
    */
   public Point2D.Double schatPositie(long t) {
      return (new Point2D.Double(this.getX() + Math.sin(bewegingsrichting) * snelheid * (t-scanTijd),
         this.getY() + Math.cos(bewegingsrichting) * snelheid * (t-scanTijd)));
   }
}
