/*
 * Created on 2004-9-30
 */
package tide;

import tide.util.Utils;

/**
 * this event occurred when you radar scanned a robot.
 * you can get others information via this event
 * 
 * @author xiemin
 */
public class ScannedRobotEvent extends Event
{
	//the name of the robot
	private String name;
	//the position of the robot
	private double x,y;
	//the move heading of the robot
	private double heading;
	//the move velocity of the robot
	private double velocity;
	//the energy of the robot
	private double energy;
	
	/**
	 * create a new ScannedRobotEvent.
	 * @param event robocode ScannedRobotEvent.
	 * @param robot robocode AdvancedRobot.
	 */
	public ScannedRobotEvent( robocode.ScannedRobotEvent event, robocode.AdvancedRobot robot)
	{
		super(event);
		this.name = event.getName();
        this.energy = event.getEnergy();
        this.velocity = event.getVelocity();
        this.heading = Utils.transform(event.getHeadingRadians());

        this.x = robot.getX() + Math.sin( event.getBearingRadians()
        	+ robot.getHeadingRadians())*event.getDistance();
		this.y = robot.getY() + Math.cos( event.getBearingRadians()
			+ robot.getHeadingRadians())*event.getDistance();
	}
	
	/**
	 * return the name of the robot.
	 * @return the name of the robot.
	 */
    public String getName()
    {
    	return name;
    }

    /**
     * Return the x position of the robot.
     * @return the x position of the robot.
     */
    public double getX()
    {
    	return x;
    }

    /**
     * Return the y position of the robot.
     * @return the y position of the robot.
     */
    public double getY()
    {
    	return y;
    }
    
    /**
     * Return the move heading of the robot.
     * @return the move heading of the robot.
     */
    public double getHeading()
    {
    	return heading;
    }
    
    /**
     * Return the move velocity of the robot.
     * @return the move velocity of the robot.
     */
    public double getVelocity()
    {
    	return velocity;
    }

    /**
     * Return the energy of the robot.
     * @return the energy of the robot.
     */
    public double getEnergy()
    {
    	return energy;
    }

}

