package simonton.micro;

import java.awt.*;
import java.awt.geom.*;
import java.io.*;
import java.util.*;
import java.util.List;
import java.util.Map.*;

import robocode.*;
import robocode.util.*;
import wiki.mc2k7.*;

/**
 * Alas, I tried to give up this game. Maybe sometime later ...
 * 
 * This bot is pretty cool, I think. I uses a very unique pattern matcher. I
 * originally designed it without any kind of size restrictions in mind, but it
 * turns out to cram into a micro very nicely! Actually, there's tons of room to
 * spare - let's see what we can do for movement, too!
 * 
 * Version history can be found at
 * http://robowiki.net/?WeeklongObsession/VersionHistory
 * 
 * @author Eric Simonton
 */
public class WeeklongObsession extends AdvancedRobot {

	private static final double MAX_RETREAT = 55 * Math.PI / 180;
	private static final double WALL_CORRECT = 1 * Math.PI / 180;
	private static final double MAX_ATTACK = 45 * Math.PI / 180;
	private static final double FLIP_FACTOR = 2;
	private static final int WALKING_STICK_LENGTH = 120;
	private static final double TARGET_DISTANCE = 600;
	private static final int MOVE_LENGTH = 48;

	private static final double FIRE_POWER_FACTOR = 900;

	private static double enemyEnergy;
	private static double damage;
	private static double myX;
	private static double myY;
	private static int random;

	// private static final String roundSeparator = "" + (char) -10 + (char)
	// -10;
	private static double enemyFireSpeed;
	private static double oDir = 1;

	private static String enemyHistory = "";
	private static String flipHistory = "";

	// private static StringBuilder enemyHistory = new StringBuilder();
	// private static StringBuilder flipHistory = new StringBuilder();

	// private static RaikoGun raikoGun;

	public void run() {

		enemyHistory = concat(Character.MAX_VALUE, enemyHistory);
		flipHistory = concat(Character.MAX_VALUE, flipHistory);
		// enemyHistory.insert(0, (char) -1);
		// flipHistory.insert(0, (char) -1);
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		do {
			turnRadarRightRadians(1);
		} while (true);
		// if (raikoGun == null) {
		// raikoGun = new RaikoGun(this);
		// }
		// raikoGun.run();
	}

	public void onScannedRobot(ScannedRobotEvent r2e) { // 4

		int r3i; // 2
		double r4d; // 15
		double distance; // 6

		double angleToEnemy; // 5

		double localODir; // 4
		double clockDist; // 2
		double flipProb; // 3
		double flipMod; // 3

		// raikoGun.onScannedRobot(r2e);

		myX = getX();
		myY = getY();

		r4d = r2e.getBearingRadians() + this.getHeadingRadians();
		angleToEnemy = r4d;
		this.setTurnRadarRightRadians(2 * Utils.normalRelativeAngle(r4d
			- this.getRadarHeadingRadians()));

		// ----------------------------------------------------------- movement

		// calculate probability of flipping next turn.
		// flipProb = FLIP_FACTOR * enemyFireSpeed / (distance =
		// r2e.getDistance());
		// flipMod =
		// // 1 - Math.min(distance / TARGET_DISTANCE, Math.abs(clockDist =
		// 1
		// - Math.abs(clockDist =
		// Utils.normalRelativeAngle(Math.atan2(
		// (this.getX() + distance * Math.sin(r4d))
		// - (BATTLEFIELD_WIDTH / 2),
		// (this.getY() + distance * Math.cos(r4d))
		// - (BATTLEFIELD_HEIGHT / 2))
		// - r4d))
		// / (Math.PI * 4);
		// // flipMod = 1;
		distance = r2e.getDistance();

		// calculate our angle of travel.
		// r3i = 0;
		// r3i = 1;
		r3i = random;
		r4d = Math.PI / 2 - 15 * Math.PI / 180;
		if (r3i > 0) {
			r4d =
				Math.max(Math.PI / 2 - MAX_RETREAT, distance
					* ((Math.PI / 2) / (TARGET_DISTANCE - 40)));
		}
		while (isOut(-WALKING_STICK_LENGTH, angleToEnemy
			+ (localODir = oDir)
			* (r4d = r4d + WALL_CORRECT)) != 0)
			;

		// decide if we flip next turn.
		if (r4d > Math.PI - MAX_ATTACK
		// || (r3i > 0 && Math.random() < (clockDist * localODir > 0 ? flipMod
			// * flipProb : 1 - flipMod * (1 - flipProb)))) {
			|| (r3i > 0 && Math.random() < FLIP_FACTOR
				* enemyFireSpeed
				/ (distance = r2e.getDistance()))) {
			oDir = -localODir;
		}

		// move!
		this.setTurnRightRadians(Math.tan(r4d =
			angleToEnemy + localODir * r4d - this.getHeadingRadians()));
		if (enemyEnergy > (enemyEnergy = r2e.getEnergy()) || r3i > 0) {
			this.setAhead(Math.cos(r4d) * -MOVE_LENGTH);
		}

		// // Debug
		// positions.clear();
		// positions.add(project(WALKING_STICK_LENGTH, a + tmp * rocket));
		// positions.add(project(-WALKING_STICK_LENGTH, a + tmp * rocket));

		// ---------------------------------------------------------------- gun

		// memorize
		enemyHistory =
			concat(encodeTable.charAt(r3i =
				17
					* (int) Math.rint(r2e.getVelocity()
						* Math
							.sin(r4d = r2e.getHeadingRadians() - angleToEnemy))
					+ (int) Math.rint(r2e.getVelocity() * Math.cos(r4d))
					+ (17 * 8 + 8)), enemyHistory);
		flipHistory = concat(flipTable.charAt(r3i), flipHistory);
		// enemyHistory.insert(0, encodeTable.charAt(r3i =
		// 17
		// * (int) Math.rint((enemyVelocity = r2e.getVelocity())
		// * Math.sin(r4d = r2e.getHeadingRadians() - angleToEnemy))
		// + (int) Math.rint(enemyVelocity * Math.cos(r4d))
		// + (17 * 8 + 8)));
		// flipHistory.insert(0, flipTable.charAt(r3i));

		// fire.
		r4d =
			Math.min(
				Math.min(FIRE_POWER_FACTOR / distance, getEnergy() / 16),
				3);
		// Targetting Challenge
		// firePower = 3;
		if (getGunTurnRemaining() == 0) {
			setFire(r4d);
		}

		this.setTurnGunRightRadians(Utils.normalRelativeAngle(getGunTurn(
			3,
			1,
			null,
			angleToEnemy,
			distance,
			this,
			Rules.getBulletSpeed(r4d))
			- this.getGunHeadingRadians()));
	}

	private static double getGunTurn(int startPos, // 5 + 1 - 1 = 5
		int nextMatchLen, // 3 + 1 = 4
		String history, // 4 + 1 = 5
		double tAngle, // 2
		double origDist, // 1 + 1 = 2
		WeeklongObsession THIS, // 1 (for execution speed only)
		double fireSpeed) { // 1

		if (THIS.getGunHeat() > .3) {
			return tAngle;
		}
		
		int i; // 4 - 1 = 3
		int step; // 3
		int testMatchLen; // 5 - 1 = 4
		String testHistory; // 4
		String pattern; // 2
		double tDist; // 1 + 1 = 2
		double origAngle; // 5
		double shootAngle; // 2 + 1 = 3

		shootAngle = origAngle = tAngle;
		do { // for each start position
			testMatchLen = nextMatchLen;
			while ((testHistory = enemyHistory).startsWith(pattern =
				testHistory.substring(0, testMatchLen), startPos)
				|| (testHistory = flipHistory).startsWith(pattern, startPos)) {
				history = testHistory;
				++testMatchLen;
			}

			if (testMatchLen > nextMatchLen) {
				// aim.
				i = 0;
				tDist = origDist;
				tAngle = origAngle;
				try {
					// // Debug
					// positions.clear();
					do {
						++i;
						history.charAt(step = history.charAt(startPos - i));
						tAngle =
							tAngle
								+ Math.atan2(step / 9 - 8, tDist =
									tDist + (step % 9 - 4) * 2);
						history.charAt(-isOut(tDist, tAngle));
						// // Debug
						// positions.add(THIS.project(tDist, tAngle));
					} while (i * fireSpeed < tDist);
					nextMatchLen = testMatchLen + 1;
					shootAngle = tAngle;
				} catch (StringIndexOutOfBoundsException ex) {}
			}

			++startPos;
		} while (startPos < enemyHistory.length()); // end for start position
		return shootAngle;

		// origDist = dist;
		// do {
		// // match.
		// do {
		// try {
		// int match = enemyHistory.indexOf(pattern = enemyHistory.substring(0,
		// matchLen), startPos);
		// int flipMatch = flipHistory.indexOf(pattern, startPos);
		// if (match >= 0) {
		// if (flipMatch >= 0 && flipMatch < match) {
		// history = flipHistory;
		// startPos = (matchPos = flipMatch) + 1;
		// break;
		// }
		// history = enemyHistory;
		// startPos = (matchPos = match) + 1;
		// break;
		// }
		// if (flipMatch >= 0) {
		// history = flipHistory;
		// startPos = (matchPos = flipMatch) + 1;
		// break;
		// }
		// // if ((matchPos =
		// // (history = enemyHistory).indexOf(pattern =
		// // enemyHistory.substring(0, matchLen), startPos)) >= 0
		// // || (matchPos =
		// // (history = flipHistory).indexOf(pattern, startPos)) >= 0) {
		// // ++startPos;
		// // break;
		// // }
		// } catch (StringIndexOutOfBoundsException ex) {}
		// if (--matchLen == 0 || THIS.getGunHeat() > .2) {
		// return angleToEnemy;
		// }
		// startPos = 3;
		// } while (true);
		//
		// // aim.
		// dist = origDist;
		// testAngle = angleToEnemy;
		// bTrav = 0;
		// // // Debug
		// // positions.clear();
		// try {
		// do {
		// history.charAt(step = (short) history.charAt(--matchPos));
		// testAngle =
		// testAngle
		// + Math.atan2(step / 9 - 8, dist =
		// dist + (step % 9 - 4) * 2);
		// history.charAt(-isOut(dist, testAngle));
		// // // Debug
		// // positions.add(THIS.project(dist, testAngle));
		// } while ((bTrav = bTrav + fireSpeed) < dist);
		// return testAngle;
		// } catch (StringIndexOutOfBoundsException ex) {}
		// } while (true);
	}

	private static String concat(char thisStep, String pattern) {

		return String.valueOf(thisStep).concat(pattern);
	}

	public void onHitByBullet(HitByBulletEvent e) {

		int round;
		enemyFireSpeed = e.getVelocity();
		if ((damage = damage + e.getPower()) > 9 * (round = getRoundNum())) {
			random = round / 3;
		}
		// System.out.println(damage + " >? " + (9 * round));
	}

	public void onBulletHit(BulletHitEvent e) {

		enemyEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}

	private static int isOut(double distance, double angle) {

		try {
			return xOutTable.charAt(((int) (myX + distance * Math.sin(angle))))
				| yOutTable.charAt(((int) (myY + distance * Math.cos(angle))));
		} catch (StringIndexOutOfBoundsException ex) {
			return 1;
		}
	}

	// // Debug
	// public void onSkippedTurn(SkippedTurnEvent e) {
	//	
	// System.out.println(getTime() + " Skipped turn!");
	// }
	//	
	// static List positions = new LinkedList();
	//	
	// public void onPaint(Graphics2D g) {
	//	
	// g.setColor(Color.WHITE);
	// for (Iterator it = positions.iterator(); it.hasNext();) {
	// Point2D.Double p = (Point2D.Double) it.next();
	// g.fillOval((int) p.x - 2, (int) p.y - 2, 4, 4);
	// }
	// }
	//	
	// private Point2D.Double project(double d, double a) {
	//	
	// return new Point2D.Double(myX + d * Math.sin(a), myY + d * Math.cos(a));
	// }

	// // Table Generation
	// static PrintStream out;
	//
	// public static void main(String[] args) throws IOException {
	//
	// out = System.out;// new PrintWriter(new FileWriter("table.txt"));
	//
	// // encodeTable
	// // 17 * (lateralVelocity + 8) + (retreatingVelocity + 8);
	// line = " private static final String encodeTable =";
	// flush("");
	// line = " \"";
	// for (int lat = -8; lat <= 8; ++lat) {
	// for (int dist = 40; dist < 1000; ++dist) {
	// for (int ret = -8; ret <= 8; ++ret) {
	// print((9 * 5 * (lat + 8)) + (9 * (dist / 200)) + (ret / 2 + 4));
	// // print((lat << 4) + (ret / 2 + 4));
	// }
	// }
	// }
	// end();
	//
	// // // flipTable
	// // // 17 * (lateralVelocity + 8) + (retreatingVelocity + 8);
	// // line = " private static final String flipTable =";
	// // flush("");
	// // line = " \"";
	// // for (int lat = -8; lat <= 8; ++lat) {
	// // for (int ret = -8; ret <= 8; ++ret) {
	// // print(9 * (-lat + 8) + (ret / 2 + 4));
	// // // print((-lat << 4) + (ret / 2 + 4));
	// // }
	// // }
	// // end();
	//
	// // // xOutTable
	// // line = " private static final String xOutTable =";
	// // flush("");
	// // line = " \"";
	// // for (int x = 0; x <= 1200; ++x) {
	// // if (x < 18 || x >= 800 - 18) {
	// // print(1);
	// // } else {
	// // print(0);
	// // }
	// // }
	// // end();
	//
	// // // yOutTable
	// // line = " private static final String yOutTable =";
	// // flush("");
	// // line = " \"";
	// // for (int x = 0; x <= 1000; ++x) {
	// // if (x < 18 || x >= 600 - 18) {
	// // print(1);
	// // } else {
	// // print(0);
	// // }
	// // }
	// // end();
	//
	// System.out.println(lines + " lines total");
	// }
	//
	// private static void print(int code) throws IOException {
	//
	// String now = "\\" + Integer.toString((char) code, 8);
	// if (line.length() + now.length() > 79) {
	// flush("\"");
	// }
	// line += now;
	// }
	//
	// static int lines;
	// static String line;
	//
	// private static void end() throws IOException {
	//
	// flush("\"");
	// out.println(";");
	// }
	//
	// private static void flush(String suffix) throws IOException {
	//
	// out.print("\n" + line + suffix);
	// line = " + \"";
	// if (++lines % 1200 == 0) {
	// System.out.println(lines + " lines, and more to come");
	// System.in.read();
	// System.in.read();
	// }
	// }

	private static final String encodeTable =
		"\0\1\1\2\2\3\3\4\4\4\5\5\6\6\7\7\10\11\12\12\13\13\14\14\15\15\15\16"
			+ "\16\17\17\20\20\21\22\23\23\24\24\25\25\26\26\26\27\27\30\30\31"
			+ "\31\32\33\34\34\35\35\36\36\37\37\37\40\40\41\41\42\42\43\44\45"
			+ "\45\46\46\47\47\50\50\50\51\51\52\52\53\53\54\55\56\56\57\57\60"
			+ "\60\61\61\61\62\62\63\63\64\64\65\66\67\67\70\70\71\71\72\72\72"
			+ "\73\73\74\74\75\75\76\77\100\100\101\101\102\102\103\103\103\104"
			+ "\104\105\105\106\106\107\110\111\111\112\112\113\113\114\114\114"
			+ "\115\115\116\116\117\117\120\121\122\122\123\123\124\124\125\125"
			+ "\125\126\126\127\127\130\130\131\132\133\133\134\134\135\135\136"
			+ "\136\136\137\137\140\140\141\141\142\143\144\144\145\145\146\146"
			+ "\147\147\147\150\150\151\151\152\152\153\154\155\155\156\156\157"
			+ "\157\160\160\160\161\161\162\162\163\163\164\165\166\166\167\167"
			+ "\170\170\171\171\171\172\172\173\173\174\174\175\176\177\177\200"
			+ "\200\201\201\202\202\202\203\203\204\204\205\205\206\207\210\210"
			+ "\211\211\212\212\213\213\213\214\214\215\215\216\216\217\220\221"
			+ "\221\222\222\223\223\224\224\224\225\225\226\226\227\227\230";

	private static final String flipTable =
		"\220\221\221\222\222\223\223\224\224\224\225\225\226\226\227\227\230"
			+ "\207\210\210\211\211\212\212\213\213\213\214\214\215\215\216\216"
			+ "\217\176\177\177\200\200\201\201\202\202\202\203\203\204\204\205"
			+ "\205\206\165\166\166\167\167\170\170\171\171\171\172\172\173\173"
			+ "\174\174\175\154\155\155\156\156\157\157\160\160\160\161\161\162"
			+ "\162\163\163\164\143\144\144\145\145\146\146\147\147\147\150\150"
			+ "\151\151\152\152\153\132\133\133\134\134\135\135\136\136\136\137"
			+ "\137\140\140\141\141\142\121\122\122\123\123\124\124\125\125\125"
			+ "\126\126\127\127\130\130\131\110\111\111\112\112\113\113\114\114"
			+ "\114\115\115\116\116\117\117\120\77\100\100\101\101\102\102\103"
			+ "\103\103\104\104\105\105\106\106\107\66\67\67\70\70\71\71\72\72"
			+ "\72\73\73\74\74\75\75\76\55\56\56\57\57\60\60\61\61\61\62\62\63"
			+ "\63\64\64\65\44\45\45\46\46\47\47\50\50\50\51\51\52\52\53\53\54"
			+ "\33\34\34\35\35\36\36\37\37\37\40\40\41\41\42\42\43\22\23\23\24"
			+ "\24\25\25\26\26\26\27\27\30\30\31\31\32\11\12\12\13\13\14\14\15"
			+ "\15\15\16\16\17\17\20\20\21\0\1\1\2\2\3\3\4\4\4\5\5\6\6\7\7\10";

	private static final int BATTLEFIELD_WIDTH = 800;
	private static final String xOutTable =
		"\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1";

	private static final int BATTLEFIELD_HEIGHT = 600;
	private static final String yOutTable =
		"\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0"
			+ "\0\0\0\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1\1"
			+ "\1\1\1\1\1\1";
}
