package dmp.micro;
import robocode.*;
import java.awt.Color;

/** 					Aurora - a robot by Daniel Pereira
 *		---------------------------------------------------------------
 *
 * Beyond Aurora
 *	- This bot was made be like girls. You will never know when they like or
 *		dislike you. Or even what will be they next move.
 *	- Builded over the Eve framework so you should see similarities.
 *		---------------------------------------------------------------
 *
 * Version 1.41 11/17/2002:
 *	- Movement controled by random function.
 *	- Eve machine gun.
 *  - 1-on-1 elite.
 *
 *  Note: A reborn from the shadows and with victory dance included.
 *		---------------------------------------------------------------
 *
 * Special thanks to:
 *	- Frederico Schuh who make me know about this great game.
 *	- Jan Schrader and his Lemon.	(Radar movement)
 *	- Michael Dorgan and his UDTNB.	(Basic gun turn and shot detector codesize trick)
 *	- Graygoo and his Wolverine.	(Winner dance)
 *	- Robocode Repository and all that great community.
 */
public final class Aurora extends TeamRobot
{
	private static double avgAim1, bullet1;	// Enemy average movement.
	private static double avgAim2;			// Removed the need of the aimFactor var. :)

	private static double enemyEnergy;		// Enemy energy duh,
	private static double enemyBearing;		// enemy bearing, and
	private static double enemyDistance;	// enemy distance! What a great comments.

	private static double dodge;			// Mod distance from the tracked bullet.
	private static double lastmove;			// Last direction and distance of movement.
	private static double control, control2;	// It's secret ;)


	/**
	 * run: (still) nothing to see here.
	 */
	public void run()
	{
		Color c = Color.pink;
		setColors(c,c,c);
		setAdjustGunForRobotTurn(true);	// Not really needed but there's too much space!
		setAdjustRadarForGunTurn(true);

		dodge		= 0;
		enemyEnergy	= 100;
		control = control2 = 0;

		// Wide scan until you find a target.
		do { turnRadarRight(45); } while(true);
	}


	/**
	 * onScannedRobot: What to do function, almost everything goes here.
	 */
	public void onScannedRobot(ScannedRobotEvent e)
	{
		// Absolute bearing.
		double absBearing = (enemyBearing = e.getBearingRadians()) + getHeadingRadians();
		enemyDistance	  = e.getDistance();
		
		dodge(e);

		// Radar turn grabed from Lemon 2.3 (Jan Schrader).
		setTurnRadarRightRadians(Math.tan(absBearing - getRadarHeadingRadians()));

		// Gun turn, in linear form. Eve 2.3 machine gun.
		setTurnGunRightRadians(normalizeBearing(absBearing - getGunHeadingRadians() + (e.getEnergy() > 0 ? (avgAim1/bullet1 + 2*avgAim2)/(528): 0)));

		// Gun powder.
		// The lead have been designed to any bullet power so save energy when you can.
		double energy = Math.min(3, Math.max(0.1, Math.min(1500/enemyDistance, Math.min(e.getEnergy()/3,getEnergy()/3))));
		// Try to get the survey bonus, all points are welcome.
		if ((getEnergy() > energy+0.1 || e.getEnergy() == 0) && setFireBullet(energy) != null)
		{
			avgAim2 = avgAim1/bullet1;			// Clear the leading aim in two turns.
			avgAim1	= 0;						// So it will not be easily fooled by multi strategy bots.
			bullet1 = Math.floor(getGunHeat());	// Number of ticks until next shot. /10
		}
		// Patented pattern matching in NanoBot form.
		avgAim1 += (e.getVelocity()* Math.sin(e.getHeadingRadians() - absBearing));
	}


	/**
	 * dodge: sorry comrade, but if I release this function all the fun will gone.
	 * I hope you can understand.
	 */
	void dodge(Event event)
	{
		/*
		* Sorry, but it's all Aurora do diferent of Eve.
		* and it's all it do at all, so will be no fair to give you
		* the movement pattern.
		*
		* This function only exists to me be able to release the rest of the source code.
		* All this code should be in the onHitWall function in a optimized robot.
		*
		* It's not that original so I'm sure you will get your bullets on me anyway.
		*/
	}


	/**
	 * onHitWall: I really should avoid walls, but for now let's keep it.
	 */
	public void onHitWall(HitWallEvent e)
	{
		dodge(e);
	}


	/******* The enemy energy can float with these follow events. *******/
	// I know, they can hit walls too, but that's a dumb thing to do.

	/**
	 * onHitByBullet: The enemy refills with the bullet damage.
	 */
	public void onHitByBullet(HitByBulletEvent e)
	{
		enemyEnergy += 3 * e.getPower();
	}


	/**
	 * onBulletHit: The enemy lose energy here.
	 */
	public void onBulletHit(BulletHitEvent e)
	{
		enemyEnergy = e.getEnergy();
	}


	/**
	 * onHitRobot: Ops I should be drunk. The enemy loses energy here too.
	 */
	public void onHitRobot(HitRobotEvent e)
	{
		enemyEnergy = e.getEnergy();
	}


	/******* Helper functions for common use. *******/

	/**
	 * normalizeBearing: 
	 * Snippet code from NanoGeek (Thomas Graf).
	 */
	static final double normalizeBearing(double angle)
	{
		return (angle + (9 * Math.PI)) % (2 * Math.PI) - Math.PI;
	}


	/**
	 * sign: returns -1 if the value is negative, +1 if the value is positive, 0.0 if the value is zero 
	 * Snippet code from SandboxMini (Paul Evans).
	 */
	static final double sign(double value)
	{
		return (value == 0.0) ? 0.0 : value/Math.abs(value);
	}


	/******* Why not amuse the loser until I don't find a good use to spare space? *******/


	/**
	 * onWin: If I win then let's dance!
	 * Snippet code from Wolverine (Graygoo).
	 */
	public void onWin(WinEvent e)
	{
		setMaxVelocity(8);
		setAdjustGunForRobotTurn(false);
		setAdjustRadarForGunTurn(false);
		for(int i = 0; i < 16; i++)
		{
			setTurnRightRadians(Math.PI/32);
			ahead(-2);
		}
		setTurnRightRadians(Math.PI/4);
		ahead(70);
		setMaxVelocity(1);
		ahead(35);
		setMaxVelocity(8);
	}
}
