package sch;

import robocode.*;
import java.util.*;

public class DodgeStrategy extends SimpleStrategy implements Constants {

	private final String strategyName="Dodge Strategy";
	private int direction;
	private double fieldHeight;
	private double fieldWidth;
	private double timeInterval;
	private double timeCounter;
	
	public DodgeStrategy () {
		super();
		direction=1;
	}

	public void initialize () {
		fieldHeight=myBot.getBattleFieldHeight();
		fieldWidth=myBot.getBattleFieldWidth();
		timeInterval=0;
		timeCounter=0;
	}
	
	public void reinitialize () {
		direction=1;
		fieldHeight=myBot.getBattleFieldHeight();
		fieldWidth=myBot.getBattleFieldWidth();
		timeInterval=0;
		timeCounter=0;
	}
	
	
	public String getName() {return strategyName;}
	
	public void setMovement() {
		double movement;
		double maxSpeed;
		double bearingToTarget;
		double turnAmount=0;
		double diffAngle=0;
		double angleTurningDir=-1;
		boolean doDodge=false;
		String targetName="";		//For debugging purpose
		Bot target=null;
		
		if (nearWall()==true) {
			goTo(fieldWidth/2,fieldHeight/2);
			return;
		}
			
		target = enemyManager.getCurrentTarget();
		if(target!=null)
			if (target.hasShoot()==true) {
				if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) myBot.out.println("Dodging");
				doDodge=true;
				timeInterval=calculateRandomTimeInterval()/10;
				}
		if (doDodge==true && timeCounter>=timeInterval) {
			direction*=-1;
			movement=calculateRandomMovement();
			maxSpeed=calculateRandomSpeed();
			if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) myBot.out.println("Moving for " + direction*BotMath.round2(movement) +"px at " + BotMath.round2(maxSpeed)+"px/tk");
			myBot.setMaxVelocity(maxSpeed);
			myBot.setAhead(direction*movement);
			timeCounter=0;
		}
		
		if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) targetName="none selected";
		if(target!=null) {
			diffAngle=Math.random()*PI/6;
			angleTurningDir*=-1;
			bearingToTarget=BotMath.normaliseBearing(BotMath.absBearing(new Point(myBot.getX(), myBot.getY()), target.getPos())-myBot.getHeadingRadians());
			turnAmount=BotMath.normaliseBearing(bearingToTarget+PI/2-direction*angleTurningDir*diffAngle);
			if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) targetName=target.getName();
		}
		if (BotUtil.varContains(DEBUG,DEBUG_BOT_MOVEMENT)) myBot.out.println("Turning right for " + BotMath.round2(Math.toDegrees(turnAmount)) + " to stay PI/2 to "+targetName);
		myBot.setTurnRightRadians(turnAmount);
		if (doDodge) timeCounter++;
	}

	public double getGoodness() {
		if (myBot.getOthers()==1)
			return 20.0;
		else
			return 0.0;
		}
		
	private boolean nearWall() {
		if (myBot.getX()<WALL_PROXIMITY || myBot.getX()>fieldWidth-WALL_PROXIMITY || myBot.getY()<WALL_PROXIMITY || myBot.getY()>fieldHeight-WALL_PROXIMITY)
			return true;
		else
			return false;
	}
}