/*
 * Created on 28/10/2003
 */

package mnt.utils;

import robocode.*;

/**
 * Esta clase es una estructura de datos con informacin sobre un robot enemigo.
 * Contiene nombre, posicin, velocidad, distancia, etc...
 * 
 * @author Lolo
 * @version 1.0
 */
public class Enemigo {
	/**
	 * Nombre Del robot enemigo.
	 */
	private String nombre = null;
	/**
	 * Distacia desde nuestro robot al robot enemigo.
	 */
	private double distancia = 0;
	/**
	 * Angulo del robot enemigo relativo al nuestro.
	 */
	private double relAngulo = 0;
	/**
	 * Angulo del robot enemigo.
	 */
	private double absAngulo = 0;
	private double absRelAng = 0;
	/**
	 * Velocidad del robot enemigo.
	 */
	private double velocidad = 0;
	/**
	 * Energia del robot enemigo.
	 */
	private double energia = 0;

	/**
	 * Coordenada x del robot.
	 */
	private double x = 0;

	/**
	 * Coordenada y del robot.
	 */
	private double y = 0;

	/**
	 * Tiempo en el que se tomaron los datos del robot.
	 */
	private long tiempo = 0;

	/**
	 * Mtodo constructor. Transforma un ScannedRobotEvent en un Enemigo.
	 * 
	 * @param e el ScannedRobotEvent que se desea convertir.
	 * @param miRobot referencia al robot llamante.
	 */
	public Enemigo(ScannedRobotEvent e, Robot miRobot) {
		nombre = e.getName();
		distancia = e.getDistance();
		relAngulo = e.getBearing();
		absRelAng = e.getBearing() + miRobot.getHeading();
		absAngulo = e.getHeading();
		velocidad = e.getVelocity();
		energia = e.getEnergy();
		tiempo = e.getTime();
		this.x = RoboMath.calculaX(miRobot.getX(), distancia, absRelAng);
		this.y = RoboMath.calculaY(miRobot.getY(), distancia, absRelAng);
		//System.out.println("Constructor " + getClass());
	}

	/**
	 * Consturctor copia.
	 * 
	 * @param e Enemigo a copiar.
	 */
	public Enemigo(Enemigo e) {
		this.nombre = e.nombre;
		this.distancia = e.distancia;
		this.relAngulo = e.relAngulo;
		this.absAngulo = e.absAngulo;
		this.absRelAng = e.absRelAng;
		this.velocidad = e.velocidad;
		this.energia = e.energia;
		this.x = e.x;
		this.y = e.y;
		this.tiempo = e.getTime();
	}

	//***********************************//
	//*		 MTODOS MODIFICADORES		*//
	//***********************************//

	/**
	 * Establece el nombre.
	 * 
	 * @param nombre nuevo nombre.
	 */
	public void setName(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Establece la distancia.
	 * 
	 * @param dist nueva distancia.
	 */
	public void setDistance(double dist) {
		distancia = dist;
	}

	/**
	 * Establece el ngulo relativo a nuestro robot.
	 * 
	 * @param bearing nuevo ngulo.
	 */
	public void setBearing(double bearing) {
		relAngulo = bearing;
	}

	/**
	 * Establece el ngulo absoluto del enemigo.
	 * 
	 * @param heading nuevo ngulo.
	 */
	public void setHeading(double heading) {
		absAngulo = heading;
	}
	
	/**
	 * Establece el angulo relativo a nuestro robot.
	 * 
	 * @param absbearing
	 */
	public void setAbsBearing(double absbearing){
		absRelAng = absbearing;
	}

	/**
	 * Establece la velocidad.
	 * 
	 * @param vel nueva velocidad.
	 */
	public void setVelocity(double vel) {
		velocidad = vel;
	}

	/**
	 * Establece el nivel de energa del robot enemigo.
	 *  
	 * @param energy nueva valor de la energa.
	 */
	public void setEnergy(double energy) {
		energia = energy;
	}
	/**
	 * Establece la coordenada x.
	 * 
	 * @param x	nueva coordenada x.
	 */
	public void setX(double x) {
		this.x = x;
	}

	/**
	 * Establece la coordenada y.
	 * 
	 * @param y nueva coordenada y
	 */
	public void setY(double y) {
		this.y = y;
	}

	//*******************************//
	//*		MTODOS CONSULTORES		*//
	//*******************************//

	/**
	 * Devuelve el nombre del robot enemigo.
	 * 
	 * @return nombre.
	 */
	public String getName() {
		return nombre;
	}

	/**
	 * Devuelve la distancia del robot enemigo.
	 * 
	 * @return distancia.
	 */
	public double getDistance() {
		return distancia;
	}

	/**
	 * Devuelve la energa del robot enemigo.
	 * 
	 * @return energa.
	 */
	public double getEnergy() {
		return energia;
	}

	/**
	 * Devuelve el ngulo absoluto del enemigo. El ngulo devuelto est comprendido
	 * entre 0 y 360, donde 0 apunta al borde superior de la pantalla, 90 a la parte
	 * derecha de la pantalla, etc...
	 *  
	 * @return ngulo absoluto del enemigo.
	 */
	public double getHeading() {
		return absAngulo;
	}

	/**
	 * Devuelve el ngulo absoluto del enemigo. El ngulo devuelto est comprendido
	 * entre 0 y 2*PI, donde 0 apunta al borde superior de la pantalla, etc...
	 *  
	 * @return ngulo absoluto del enemigo.
	 */
	public double getHeadingRadians() {
		return Math.toRadians(absAngulo);
	}

	/**
	 * Devuelve el ngulo relativo a nuestro robot del enemigo. Es el ngulo que
	 * nuestro robot debe girar para encarar al robot enemigo.
	 * El ngulo devuelto est comprendido entre 180 y -180.
	 *  
	 * @return ngulo relativo del enemigo.
	 */
	public double getBearing() {
		return relAngulo;
	}

	/**
	 * Devuelve el ngulo relativo a nuestro robot del enemigo. Es el ngulo que
	 * nuestro robot debe girar para encarar al robot enemigo.
	 * El ngulo devuelto est radianes.
	 *  
	 * @return ngulo relativo del enemigo.
	 */
	public double getBearingRadians() {
		return Math.toRadians(relAngulo);
	}
	
	public double getAbsBearing(){
		return absRelAng;
	}
	
	public double getAbsBearingRadians(){
		return Math.toRadians(absRelAng);
	}

	/**
	 * Devuelve la velocidad del robot enemigo.
	 * 
	 * @return velocidad.
	 */
	public double getVelocity() {
		return velocidad;
	}

	/**
	 * Devuelve la coordenada x del robot enemigo.
	 * 
	 * @return coordenada x.
	 */
	public double getX() {
		return x;
	}

	/**
	 * Devuelve la coordenada y del robot enemigo.
	 * 
	 * @return coordenada y.
	 */
	public double getY() {
		return y;
	}

	/**
	 * Devuelve el tiempo en que fue creado el objeto.
	 * 
	 * @return tiempo.
	 */
	public long getTime() {
		return tiempo;
	}
}
