package dsx724.EventProcessors;

import robocode.*;
public class EventProcessor3 {
	public double[][] track = new double[3][2];
	public ScannedRobotEvent e;
	private AdvancedRobot r;
	private boolean initEvent = true;
	private final double RR = 20;
	private boolean DEBUG = false;
	
	public EventProcessor3(AdvancedRobot robot){
		r = robot;
	}
	public void processScanEvent(ScannedRobotEvent event){
		for (int i = 2; i > 0; i--){
			track[i] = track[i-1];
		}
		track[0] = getAbsoluteLocation(event);
		if (initEvent){
			initEvent = false;
			for (int i = 2; i > 0; i--){
				track[i][0] = track[0][0];
				track[i][1] = track[0][1];
			}
		}
		/*		for (int i = 0; i < 3; i++){
			System.out.println("Track " + i + ": "+ (int)track[i][0] + " " + (int)track[i][1]);
		}*/
	}
	private double[] getAbsoluteLocation(ScannedRobotEvent event){
		e = event;
		double da = (r.getHeadingRadians() + e.getBearingRadians());
		double ax = Math.sin(da) * e.getDistance() + r.getX();
		double ay = Math.cos(da) * e.getDistance() + r.getY();
		ax = Math.min(ax, r.getBattleFieldWidth() - RR);
		ay = Math.min(ay, r.getBattleFieldHeight() - RR);
		ax = Math.max(ax, RR);
		ay = Math.max(ay, RR);
		return new double[]{ax,ay};
	}
	
	public double[] getLocation(){
		return track[0];
	}
	public double[] getPredictedLocation(int turns){
		double bfwidth = r.getBattleFieldWidth() - RR;
		double bfheight = r.getBattleFieldHeight() - RR;
		double px = track[0][0];
		double py = track[0][1];
		double m2dy = track[1][1] - track[2][1];
		//System.out.println("M2DY: " + m2dy);
		double m2dx = track[1][0] - track[2][0];
		//System.out.println("M2DX: " + m2dx);
		double m2;
		if (m2dy == 0)
			m2 = Double.POSITIVE_INFINITY;
		else
			m2 = -(m2dx)/(m2dy);
		//System.out.println("M2: " + m2);
		double m1dy = track[0][1] - track[1][1];
		//System.out.println("M1DY: " + m1dy);
		double m1dx = track[0][0] - track[1][0];
		//System.out.println("M1DX: " + m1dx);
		double m1;
		if (m1dy == 0)
			m1 = Double.POSITIVE_INFINITY;
		else 
			m1 = -(m1dx)/(m1dy);
		//System.out.println("M1: " + m1);
		if (isNear(m1,m2) || (track[1][0] == track[2][0] && track[1][1] == track[2][1])){
			if (DEBUG)
				System.out.println("Straight Movement");
			double dx2 = track[1][0] - track[2][0];
			//System.out.println("dx2:" + (int)(dx2 * 100) + "\t");
			double dx1 = track[0][0] - track[1][0];
			//System.out.println("dx1:" + (int)(dx1 * 100) + "\t");
			double dy2 = track[1][1] - track[2][1];
			//System.out.println("dy2:" + (int)(dy2 * 100) + "\t");
			double dy1 = track[0][1] - track[1][1];
			//System.out.println("dy1:" + (int)(dy1 * 100) + "\t");
			
			double d2x = dx1 - dx2;
			if (Math.abs(d2x) > 2){
				d2x = 0;
				dx1 = 0;
			}
			//System.out.println("s-d2x:" + (int)(d2x * 100) + "\n");
			double dx0 = dx1;
			

			double d2y = dy1 - dy2;
			if (Math.abs(d2y) > 2)
				d2y = 0;
			//System.out.println("s-d2y:" + (int)(d2y * 100) + "\n");
			double dy0 = dy1;
			
			for (int i = 0; i < turns; i++){
				boolean hitwall = false;
				dx0 += d2x;
				dy0 += d2y;
				dx0 = Math.min(dx0, 8);
				dy0 = Math.min(dy0, 8);
				dx0 = Math.max(dx0, -8);
				dy0 = Math.max(dy0, -8);
				px += dx0;
				py += dy0;
				
				if (px > bfwidth){
					px = bfwidth;
					hitwall = true;
				}
				if (px < RR){
					px = RR;
					hitwall = true;
				}
				if (py > bfheight){
					py = bfheight;
					hitwall = true;
				}
				if (py < RR){
					py = RR;
					hitwall = true;
				}
				if (hitwall){
					d2x = 0;
					d2y = 0;
					dx0 = 0;
					dy0 = 0;
				}
			}
			return new double[]{px,py};
		} else if (isNear(m2dy,0) || isNear(m1dy,0)){
			if (DEBUG)
				System.out.println("Horizontal Movement");
			double dx2 = track[1][0] - track[2][0];
			//System.out.print("dx2:" + (int)dx2 + "\t");
			double dx1 = track[0][0] - track[1][0];
			//System.out.print("dx1:" + (int)dx1 + "\t");
			double d2x = dx1 - dx2;
			if (Math.abs(d2x) > 2){
				d2x = 0;
				dx1 = 0;
			}
			//System.out.print("h-d2x:" + (int)d2x + "\n");
			double dx0 = dx1;

			for (int i = 0; i < turns; i++){
				dx0 += d2x;
				dx0 = Math.min(dx0, 8);
				dx0 = Math.max(dx0, -8);
				
				px += dx0;
				if (px > bfwidth){
					d2x = 0;
					dx0 = 0;
					px = bfwidth;
				}
				if (px < RR){
					d2x = 0;
					dx0 = 0;
					px = RR;
				}
			}
			//System.out.print("dx0:" + dx0 + "\t");
			//System.out.print("px:" + px + "\n");
			return new double[]{px,py};
		} if (isNear(m2dx,0) || isNear(m1dx,0)){
			if (DEBUG)
				System.out.println("Vertical Movement");
			double dy2 = track[1][1] - track[2][1];
			double dy1 = track[0][1] - track[1][1];

			double d2y = dy1 - dy2;
			if (Math.abs(d2y) > 2){
				d2y = 0;
				dy1 = 0;
			}
			//System.out.print("v-d2x:" + (int)d2y + "\n");
			double dy0 = dy1;
			
			for (int i = 0; i < turns; i++){
				dy0 += d2y;
				dy0 = Math.min(dy0, 8);
				dy0 = Math.max(dy0, -8);
				py += dy0;
				
				if (py > bfheight){
					d2y = 0;
					dy0 = 0;
					py = bfheight;
				}
				if (py < RR){
					d2y = 0;
					dy0 = 0;
					py = RR;
				}
			}
			return new double[]{px,py};
		} else {
			if (DEBUG)
				System.out.println("Arc Movement");
			double x2 = (track[2][0] + track[1][0]) / 2;
			//System.out.println("X2: " + x2);
			double y2 = (track[2][1] + track[1][1]) / 2;
			//System.out.println("Y2: " + y2);
			double x1 = (track[1][0] + track[0][0]) / 2;
			//System.out.println("X1: " + x1);
			double y1 = (track[1][1] + track[0][1]) / 2;
			//System.out.println("Y1: " + y1);
			double centerx = (m1 * x1 - m2 * x2 - y1 + y2) / (m1 - m2);
			//System.out.println("CX: " + centerx);
			double centery = m1 * (centerx - x1) + y1;
			//System.out.println("CY: " + centery);
			
			double r2dx = track[1][0] - centerx;
			double r2dy = track[1][1] - centery;
			double r2 = Math.sqrt(r2dx * r2dx + r2dy * r2dy);
			double r1dx = track[0][0] - centerx;
			double r1dy = track[0][1] - centery;
			double r1 = Math.sqrt(r1dx * r1dx + r1dy * r1dy);
			
			double r0 = 2 * r1 - r2;
			if (r0 - r1 > 8)
				r0 = 8 + r1;
			//System.out.println("R0: " + r0);
			
			double t2 = Math.atan2(r2dx, r2dy);
			//System.out.println("T2: " + t2 * 180 / Math.PI);
			double t1 = Math.atan2(r1dx, r1dy);
			//System.out.println("T1: " + t1 * 180 / Math.PI);
			double dt = t1 - t2;
			double t0 = t1;
			for (int i = 0; i < turns; i++){
				t0 += dt;
				px = centerx + Math.sin(t0) * r0;
				py = centery + Math.cos(t0) * r0;
				if (px > bfwidth || py > bfheight || px < RR || py < RR){
					t0-= dt;
				}
			}
			//System.out.println("T0: " + t0 * 180 / Math.PI);
			return new double[]{px,py};
		}
	}
	public double[] getRelativePredictedLocation(int turns){
		double[] ploc = getPredictedLocation(turns);
		return new double[]{ploc[0] - r.getX(), ploc[1] - r.getY()};
	}
	public boolean isNear(double a, double b){
		return Math.abs(a - b) < 0.000000001;
	}
    public double cappi(double arg0){
    	while (arg0 > Math.PI){
    		arg0 -= 2 * Math.PI;
    	}
    	while (arg0 < -Math.PI){
    		arg0 += 2 * Math.PI;
    	}
    	return arg0;
    }
    public double captwopi(double arg0){
    	while (arg0 >= 2 * Math.PI){
    		arg0 -= 2 * Math.PI;
    	}
    	while (arg0 < 0){
    		arg0 += 2 * Math.PI;
    	}
    	return arg0;
    }
}