package ers.nano.meroka;

/**
 * Author: ER Samson
 * 
 * First few iterations was built with (ISuckNano 0.1d)
 *
 * The design has evolved to
 * 		• Pattern Matching gun
 * 		• Multi-Mode Stop-Go Movement
 * 			• Health Drop Stop-Go Movement 
 * 			• Oscillator Movement
 * 		• Staying perpendicular to the enemy
 * 
 * Movement:
 * 		• Mark Whiteley      - http://mark.random-article.com/robocode/improved_movement.html
 * 		• Wiki               - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Wiki               - https://robowiki.net/wiki/Oscillator_Movement
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 
 * Radar:
 * 		• Wiki               - https://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targeting:
 * 		• Wiki               - https://robowiki.net/wiki/Rolling_Averages
 *		• Exauge             - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 
 * Code Shrinking Tips:
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 
 * Symbolic Pattern String (old PM gun):
 *      • Sheldor            - https://robowiki.net/wiki/Foilist
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;

public class Meroka extends AdvancedRobot {
	
	/* ---------- Gun Variables ---------- */
	private static final int	BULLET_POWER	= 2;
	private static final int	BULLET_VELOCITY	= (int)(20 - 3 * BULLET_POWER);
	private static final int	ANTIRAM_FACTOR	= 70;
	private static final int	PATTERN_DEPTH	= 30;

	/* ---------- Movement Variables ---------- */
	private static final double BIG_NUMBER		= 30000;
	private static final double TARGET_DISTANCE	= 180;
	private static double moveDirection 		= 72;
	private static double moveMode 				= 1;
	private static double enemyHealth;

	public void run() {
		// Color Identification
		//setColors(Color.blue, Color.red, Color.orange);

		// Easy targetting and infinite radar movement
		setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
		//setAdjustGunForRobotTurn(true); // Saving code size!
	}

	public void onScannedRobot(ScannedRobotEvent e) {
	
		/* ---------- Generic Variables ---------- */
		int matchLength = PATTERN_DEPTH; // for PM gun, arranged like so to save codesize!
		double absoluteBearing;
		double enemyDistance;			
		int i, indX;  // for PM gun

		/* ---------- Musashi Movement Logic ----------	*/
		// Turn perpendicular to enemy, Yatagan style, no wall avoidance D:				
		setTurnRightRadians(Math.cos((absoluteBearing = e.getBearingRadians()) + 
						   ((TARGET_DISTANCE - (enemyDistance = e.getDistance())) * (moveDirection / BIG_NUMBER)))); // Yatagan D:

		/* ---------- Gun Logic ---------- */
		// PM Gun from Exauge in RoboWiki
		// Math.round function from Exauge makes this better
		enemyLog = String.valueOf((char)Math.round(e.getVelocity() 
             	* Math.sin(e.getHeadingRadians() - (absoluteBearing += getHeadingRadians())))).concat(enemyLog);
		
		while((indX = enemyLog.indexOf(enemyLog.substring(0, matchLength--), 
               i = (int)(enemyDistance) / BULLET_VELOCITY)) < 0);
		
		do {
			absoluteBearing += (short) enemyLog.charAt(indX--) / enemyDistance; // Nifty aiming from WeekendObsession_S! 
		} while (--i > 0);
		
		setTurnGunRightRadians(Utils.normalRelativeAngle(absoluteBearing - getGunHeadingRadians()));
		setFire(BULLET_POWER + (int)(ANTIRAM_FACTOR / enemyDistance)); // Shoot to kill, with Anti-Ram

		/* ---------- Multi-Mode Movement Logic ---------- */
		// Energy drop, random distance movement, change strat!
		if ((char)(enemyHealth - 1 - (enemyHealth = e.getEnergy())) < 4) {
		//if (enemyHealth > (enemyHealth = e.getEnergy())) {
			setAhead(moveDirection *= moveMode);
		}

		/* ---------- Radar Logic ---------- */
		// From RoboWiki
		setTurnRadarLeft(getRadarTurnRemaining());		
	}
	
	/**
	 * Reverse direction when I hit wall
	 */
	public void onHitWall(HitWallEvent e) {
		moveDirection = -moveDirection;
	}

	/**
	 * Change movement mode when enemy bullet hits
	 */	
	public void onHitByBullet(HitByBulletEvent e) {
		moveMode = -moveMode;
	}
	
	/**
	 * Symbolic log of enemy movements for pattern matcher.
	 * Preloaded to prevent StringIndexOutOfBoundsException.
	 */
	private static String enemyLog = ""
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 2
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char)-1
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char) 0 + (char) 0 + (char) 0
		+ (char) 0 + (char)-2 + (char)-4 + (char)-6
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-8 + (char)-8 + (char)-8 + (char)-8
		+ (char)-7 + (char)-6 + (char)-5 + (char)-4
		+ (char)-3 + (char)-2 + (char)-1 + (char) 0
		+ (char) 2 + (char) 4 + (char) 6 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 8 + (char) 8 + (char) 8 + (char) 8
		+ (char) 7 + (char) 6 + (char) 5 + (char) 4
		+ (char) 3 + (char) 2 + (char) 1 + (char) 0;
}