package js;
import robocode.*;
//import js.Gravity.*;
import java.awt.Color;

							/***********
			*****************IMPORTANT!******************************************
			*By reading the source code you agree to the following :
			*
			1.You are allowed to use(copy,modify) parts of this code aslong you 
			*make your bot open source and state the origin of the used bytes.:-) 
			2.You are NOT allowed to use it for any commercial purpose
			*or simply to copy this bot :-( 
							***********/

/**
 * PinBall - a nano robot(codesize 248) by Jan Schrader (v 1.2) [11.07.02]
 * - Creates a artificial (anti) gravity field
 * - Changes polarity to attack
 * - Firepower saving mode
 * - Straight fireing(more bug than feature)
 * - Uses a "relative" geek style radar
 * - Has a tiny "anti-copycat" bug

	v 1.3	(codesize 248) [18.07.02]
 * - Works completely on radians//thanks to Michael Dorgan and his Butterfly
 * - Now at least has some kind of bullet dogging for 1v1
 * - A new (cheaper) relative radar calculation
 * - A relative round scan

	v 1.4	(codesize 249) [19.08.02]	(Vampire)
 * - Code is more efficent
 * - Uses setFire()
 * - Radar now always turns in melee mode
 * - Has predictive aiming //thanks (at least) to Stuart Holliday and Michael Dorgan

	v 1.5	(codesize 237) [20.08.02]	"Color"
 * - Lots of space for improvement
 * - Back to Anti-gravity movement
 * - Improved radar that cosiders targets distance
 * - And color is green (easy to find in melees)
 * - "anti-copycat" bug has been displaced

	v 1.6	(codesize 247) [29.09.02]	(Vampire again)
 * - The vampire-gen breaks through again //nanos taste too good yam,yam... :[
 * - Tracking movement from Lemon transformed into a new vampiric movement
 * - Some code reduction tricks give more space for the new features
 * - Michael Dorgan saves me again with his new, excellent aiming and of course challanges me with his new Infinity :)
//
 * Known bugs :-{
 * - it doesnt get last surviver bonus against much better bots (abc.MiniTron)
 * - does not react to tracking robots at its back
 * - gets sometimes trapped in corners
 * - still runs a lot into fying bullets, but recovers now from taken damage
 * So for a melee nano bot it does quite well :-) //in 1v1 too  
 */
public class PinBall extends TeamRobot //started as a pure funBot
{	/**
	 * run: PinBalls's default behavior
	 * Eating up nanos, one after one...
	 */
	public static float direct;
	public static double lastHeading;
	
	public void run() {
		direct=135;//asigning here saves one byte
		setColors(null,null,Color.red);//more agressive color scheme
		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true);
		do{	
				turnRadarRightRadians(5);//spin a bit faster, because there is space
		}while(true);
	}
	//protected void saveBotData(){	//codefragment left from original js.PinBall, written with clear code in mind and was 7KB! class size big
	//	for(int i = 0;i < others;i++){
	//		if(allNames[i] == null || allNames[i].equals(name)){
	//			allDistance[i]	= distance;
	//			allNames[i] = name;
	//			allBearing[i] = bear;
	//			allGravity[i] = Gravity.gCalc(new Gravity(bear,2000/distance),new Gravity(bear,2000/distance));
	//			return;
	//		}
	//	}
	//}
	/**
	 * onScannedRobot: What to do when you see another robot
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		/*Update information*/
		double cbear = e.getBearingRadians()+getHeadingRadians();//putting all in one local var saves some space
		/*Lock radar if target is close enough*/
		if(e.getDistance()<2200/getOthers())//patented lock system ;)
		setTurnRadarRightRadians(Math.asin(Math.sin(cbear-getRadarHeadingRadians())));//narrow beam, to get correct deltas
		/*Variant of the circular and linear aim from Infinity - and no, this is Java, not Scheme :-P*/
		setTurnGunRightRadians(Math.asin(Math.sin(cbear - getGunHeadingRadians()+ 
		Math.sin(lastHeading-cbear+(cbear=(e.getDistance()/36)*(-lastHeading+(lastHeading=e.getHeadingRadians()))))*Math.asin(e.getVelocity()/(4*(4+Math.abs(cbear))))))); 
		/*(set)Fire - save energy*/
		setFire(Math.min(825/e.getDistance(),getEnergy())/5+1);//make the shots travel faster
		/*Vampiric movement*/
		if(getVelocity()==0){//handle getDistanceRemaing()==0,HitWall,HitRobot //thanks to Grafi for that trick
			if(Math.random()<=.062*getOthers()+.15)direct=-direct;//a bit random is always nice
			setAhead(direct);
			setTurnRightRadians((e.getBearingRadians()-Math.PI/2+direct/375)*5);//vampiric tracking move, no normalisation saves some bytes
			return;
		}
		scan();
	}
}//somehow this nano bot would never been possible without all those guys who discovered brilliant tricks
 //to make code smaller and the bots more efficient.
 //THANKS VERY MUCH !!!
 //PS: I hope this bot contains anything that could be a worthful addition to yours