package nkn.mini;

import robocode.*;
import robocode.util.*;
import java.awt.geom.*;
import java.util.*;

public class Jskr0 extends AdvancedRobot {

    static Rectangle2D fieldRect = 
	new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);

    static final double prefDistance = 450.0;
    static final double stickLength = 150.0;
    static final double bulletPower = 2.0;
    static final double bulletSpeed = 14.0;
    static final double hitDelta = 36.0;

    static final int midIndex = 12;
    static final int nbBins = 25;
    static final int nbSegm = 5;
    static int tstats[][][] = new int[nbSegm][nbSegm][nbBins];
    static int dstats[][][] = new int[nbSegm][nbSegm][nbBins];

    static double direction = 1.0;

    LinkedList<eWave> waves = new LinkedList<eWave>();

    double targetX, targetY;
    double targetAbsBearing, targetDistance;
    double targetPrevEnergy, targetPrevVelocity;

    public void run() {
	setAdjustRadarForGunTurn(true);
	setAdjustGunForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
	targetDistance = e.getDistance();
	targetAbsBearing = Utils.normalAbsoluteAngle(getHeadingRadians() 
						     + e.getBearingRadians());
	targetX = (getX() + Math.sin(targetAbsBearing) * targetDistance);
	targetY = (getY() + Math.cos(targetAbsBearing) * targetDistance);
	double energyDelta = targetPrevEnergy - e.getEnergy();
	if (energyDelta > 0 && energyDelta <= 3.0)
	    addCustomEvent(new eWave(energyDelta, 
				     dstats
				     [(int)(Math.abs(getVelocity())) / 2]
				     [(int)(targetDistance / (900 / nbSegm))]));

	// radar
	setTurnRadarRightRadians
	    (Utils.normalRelativeAngle(targetAbsBearing 
				       - getRadarHeadingRadians()) * 2.0);
	
	// movement
	double orbitAngle = targetAbsBearing - direction * (Math.PI / 2.0);
	double minFactor = 1e6, bestAngle = 0.0;
	for (double absAngle = 0.0; absAngle < (Math.PI * 2.0); 
	     absAngle += (Math.PI / 16.0)) {
	    double destX = getX() + Math.sin(absAngle) * stickLength;
	    double destY = getY() + Math.cos(absAngle) * stickLength;

	    if (!fieldRect.contains(destX, destY))
		continue;

	    double destDist =
		Point2D.distance(destX, destY, targetX, targetY);
	    double distDelta =
		((int)(Math.abs(destDist - prefDistance) / 50.0)) * 50.0;
	    double deltaToOrbit = 
		Utils.normalRelativeAngle(orbitAngle - absAngle);
	    double riskFactor = 
		Math.min(100.0, (distDelta / prefDistance) * 100.0)
		+ Math.min(100.0, (Math.abs(deltaToOrbit) / (Math.PI)) * 100.0);
	    
	    for (eWave wave : waves) {
		if (Math.abs(wave.flightDistance - wave.sourceDistance) 
		    / wave.velocity > 20.0) continue;
			
		if (wave.intersectsZone(destX, destY)) riskFactor += 100.0;
		else riskFactor += 
			 Math.max(0.0, Math.min(100.0,
		       ((Math.abs((Math.PI / 2.0) - 
			  Math.abs(Utils.normalRelativeAngle(wave.targetingAngle
			     - absAngle)))) / (Math.PI / 2.0)) * 100.0 / 2.0));
	    }

	    if (riskFactor < minFactor) {
		minFactor = riskFactor;
		bestAngle = absAngle;
	    }
	}

	if ((Math.abs(Utils.normalRelativeAngle(orbitAngle - bestAngle))
	     > (Math.PI / 2.0))
	    || (Math.random() < ( 1.0 / (targetDistance / 14.0))))
	    direction = - direction;

	double turnAngle =
	    Utils.normalRelativeAngle(bestAngle - getHeadingRadians());
	setAhead(stickLength * Math.cos(turnAngle));
	setTurnRightRadians(Math.tan(turnAngle));
	
	// gun
	int tsg[] = tstats
	    [(int)(Math.abs(e.getVelocity())) / 2]
	    [(int)(Math.abs(targetPrevVelocity)) / 2];

	double maxBearingDelta =
	    (((e.getVelocity() * Math.sin(e.getHeadingRadians() 
					  - targetAbsBearing)) < 0.0) ? -1 : 1)
	    * Math.asin(Rules.MAX_VELOCITY / bulletSpeed);

	setTurnGunRightRadians(
	       Utils.normalRelativeAngle(
		 targetAbsBearing - getGunHeadingRadians() 
		 + guessFactor(tsg) * maxBearingDelta));
	setFire(bulletPower);
	addCustomEvent(new fWave(maxBearingDelta, tsg));

	//
	targetPrevEnergy = e.getEnergy();
	targetPrevVelocity = e.getVelocity();
    }

    public void onHitByBullet(HitByBulletEvent e) {
	for (eWave w : waves)
	    if (Math.abs(w.flightDistance - w.sourceDistance) <= hitDelta) {
		updateFactor(w.dsg, 
			     Utils.normalRelativeAngle(e.getHeadingRadians() 
			       - w.sourceAbsBearing) / w.usedMaxBearingDelta);
		return;
	    }
    }

    class fWave extends Condition {
	double sourceX, sourceY;
	double sourceAbsBearing, usedMaxBearingDelta;
	long sourceTime;
	int tsg[];

	public fWave(double m, int s[]) {
	    sourceTime = getTime();
	    sourceX = getX();
	    sourceY = getY();
	    sourceAbsBearing =targetAbsBearing;
	    usedMaxBearingDelta = m;
	    tsg = s;
	}

	public boolean test() {
	    if (((getTime() - sourceTime) * bulletSpeed) >= 
		Point2D.distance(sourceX, sourceY, targetX, targetY)) {
		updateFactor(tsg, 
			     Utils.normalRelativeAngle(
			       Math.atan2(targetX - sourceX, targetY - sourceY)
			       - sourceAbsBearing) / usedMaxBearingDelta);
		removeCustomEvent(this);
	    }
	    return false;
	}
    }

    class eWave extends Condition {
	double sourceX, sourceY;
	double sourceAbsBearing, usedMaxBearingDelta;
	long sourceTime;
	int dsg[];
	double velocity;
	double targetingAngle;
	double sourceDistance, flightDistance;

	public eWave(double p, int d[]) {
	    sourceTime = getTime() - 1;
	    sourceX = targetX;
	    sourceY = targetY;
	    sourceAbsBearing = targetAbsBearing - Math.PI;
	    velocity = Rules.getBulletSpeed(p);
	    dsg = d;
	    usedMaxBearingDelta =
		(((getVelocity() * Math.sin(getHeadingRadians() 
					    - sourceAbsBearing)) < 0.0) ? -1 : 1)
		* Math.asin(Rules.MAX_VELOCITY / velocity);
	    targetingAngle =
		sourceAbsBearing + (guessFactor(dsg) * usedMaxBearingDelta); 
	    waves.add(this);
	}

	public boolean intersectsZone(double dX, double dY) {
	    final double maxLen = 1000.0;
	    double botWidthAngle;
	    double zoneAngle1 = targetingAngle - (botWidthAngle = 
				  Math.atan(hitDelta / sourceDistance));
	    double zoneAngle2 = targetingAngle + botWidthAngle;

	    boolean intersects =
		Line2D.Double.linesIntersect
		(getX(), getY(), dX, dY, sourceX, sourceY, 
		 sourceX + Math.sin(zoneAngle1) * maxLen, 
		 sourceY + Math.cos(zoneAngle1) * maxLen) 
		|| 
		Line2D.Double.linesIntersect
		(getX(), getY(), dX, dY, sourceX, sourceY, 
		 sourceX + Math.sin(zoneAngle2) * maxLen, 
		 sourceY + Math.cos(zoneAngle2) * maxLen);

	    if (Math.abs(Math.atan2(getX() - sourceX, getY() - sourceY) 
			 - targetingAngle) < botWidthAngle)
		return !intersects;
	    else return intersects;
	}

	public boolean test() {
	    if ((flightDistance =
		 (getTime() - sourceTime) * velocity) > 
		(sourceDistance = 
		 Point2D.distance(sourceX, sourceY, getX(), getY())) + hitDelta){
		waves.remove(this);
		removeCustomEvent(this);
	    }
	    return false;
	}
    }

    public double guessFactor(int seg[]) {
	int bestindex = midIndex;
	for (int i = 0; i < seg.length; i++)
	    if (seg[bestindex] < seg[i]) bestindex = i;
	return (double) (bestindex - midIndex) / midIndex;
    }

    public void updateFactor(int seg[], double f) {
	seg[(int)(midIndex * (Math.max(-1.0, Math.min(1.0, f)) + 1))]++;
    }

}
