/*
 * Created by IntelliJ IDEA.
 * User: Joachim
 * Date: 13.06.2002
 * Time: 00:50:04
 */
package qohnil.blot;

import java.util.StringTokenizer;

public class StaticBotData {
    int numKilledMe = 0;
    long[] numFired = new long[3];
    long[] numHit = new long[3];
    double damageTaken = 0.0;  // damage taken by this bot
    double damageDealt = 0.0;  // damage dealt to me by this bot

    public StaticBotData() {}

    public String getHitRatioString() {
        String str = "";
        for (int i = 0; i < 3; i++) {
            str += numFired[i] + " " + numHit[i] + " ";
        }
        return str;
    }

    public StaticBotData(String hitRatios) {
        StringTokenizer strTok = new StringTokenizer(hitRatios, " ");
        for (int i = 0; i < 3; i++) {
            try {
                numFired[i] = Long.parseLong(strTok.nextToken());
                numHit[i] = Long.parseLong(strTok.nextToken());
            } catch (NumberFormatException e) {
                e.printStackTrace(System.out);
            }
        }
    }
}