/*
 * Written by Kinsen Choy
 */

package kinsen.melee.Guns;
import kinsen.melee.Details;

/*
 * AveragedCircular - A gun class that fires circularly predicted bullets.
 */
public class AveragedCircular extends Gun
{
	// Last enemy details
	private Details enemy = null;
	// Last my details
	private Details me = null;
	// Last time
	private long lastTime = 0;

	// Averaged data
	private double averageVelocity = 0;
	private double averageTurn = 0;
	// Data count
	private int averageCount = 0;

	public void calculateGun(double initialFirePower)
	{
		// If there is no data then it can not fire
		if (enemy != null)
		{
			// Sets target location and fire power
			firePower = initialFirePower;
			fireAt = super.predictPosition(enemy.getX(), enemy.getY(), me.getX(), me.getY(), enemy.getHeading(),
											averageVelocity * enemy.getVelocity() / Math.abs(enemy.getVelocity()), averageTurn, firePower);
		}
	}

	public void calculateGun(double initialFirePower, boolean canChangePower)
	{
		calculateGun(initialFirePower);
	}

	public void recordData(Details enemyDetails, Details myDetails, long time)
	{
		// If there is previous data then calculate turn
		if (enemy != null)
		{
			averageTurn = (averageTurn * averageCount + enemyDetails.getHeading() - enemy.getHeading()) / (averageCount + 1) / (time - lastTime);
			// So that counter is consistent
			averageVelocity = (averageVelocity * averageCount) / (averageCount + 1);
			averageCount++;
			if (averageCount > 10)
				averageCount = 10;
		}

		enemy = enemyDetails;
		me = myDetails;
		lastTime = time;
	}
}