package cx.utils;
import java.awt.geom.Point2D;
import robocode.*;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Infinity Virtule Bullets looks like a wave
 */

public class Wave
{
	//-------comparable varialbles---------
	public double linePreDiffAngle;
	public double distance;
	public double distanceToCenter;
	//----------------------------------
	Point2D.Double startPoint;
	public long   startTime;
	public double absBearing;
	public double velocity;   //in test it is velocity but final it is the distance
	public double power;
	//if willHitDiffAngle==10 means it is testing,==20 means it is useless,others means a succeded wave 
	public double willHitDiffAngle;
	public Wave(Point2D.Double startPoint,double power,long time,double bearing,double dist,double lpda,double distanceToCenter){
		velocity=20-power*3;
		if(power==0){
			velocity=11;
		}
		this.power=power;
		absBearing=bearing;
		distance=dist/90d;
        linePreDiffAngle=lpda;
		this.distanceToCenter=distanceToCenter/75d;
		this.startPoint=startPoint;
        startTime=time;

		willHitDiffAngle=10D;//a very max angle show it is not a succeded value
	}
	public static double getComVal(Object o,Object o2,double dir){
		Wave curWave=(Wave)o;
		Wave comWave=(Wave)o2;
        return Point2D.distanceSq(curWave.linePreDiffAngle,curWave.distance,comWave.linePreDiffAngle*dir,comWave.distance)
			   +Math.pow((curWave.distanceToCenter-comWave.distanceToCenter),2);
	}
	/**
	 * test the wave (when the wave hit enemy,test succede)
	 */
	public void test(Point2D.Double enemyPoint,long time){
		if(willHitDiffAngle==10D){//it is not a succeded wave,so test
		    double dist=enemyPoint.distance(startPoint);
			double travel=velocity*(time-startTime);
			if (travel<0){
				willHitDiffAngle=20D;
			}else if(Math.abs(dist-travel)<18){  //is the wav hit enemy?
				willHitDiffAngle=robocode.util.Utils.normalRelativeAngle(getAngle(enemyPoint,startPoint)-absBearing);
                velocity=dist; //recored distance in velocity
			}
		}
	}
	public static double getAngle(Point2D.Double p2,Point2D.Double p1){
		return Math.atan2(p2.x-p1.x,p2.y-p1.y);
	}
};
