package abud;

import java.util.Hashtable;

import robocode.*;

/**
 * Comments
 */
public abstract class BaseRobo extends TeamRobot {
	Hashtable enemyMap = new Hashtable();	
	Hashtable teamMap = new Hashtable();

	/**
	 * Not used, use #onScannedRobot(AdvancedRobot robo, AdvancedScannedRobotEvent e) instead
	 */
	public void onScannedRobot(ScannedRobotEvent e) {
		AdvancedScannedRobotEvent as = (AdvancedScannedRobotEvent)e;
		as.setRobo(this);
		onScannedRobot(this, as);
	}
	
	public void onScannedRobot(AdvancedRobot robo, AdvancedScannedRobotEvent e) {
	}
	
	
	
	public double getGunHeadingRelative(){
		double x = getGunHeading() - getHeading();
		if (x > 180) {
			x -= 360;
		} else if (x < -180){
			x += 360;
		}
		return x;  
	}
	
	public double getRadarHeadingRelative(){
		double x = getRadarHeading() - getHeading();
		if (x > 180) {
			x -= 360;
		} else if (x < -180){
			x += 360;
		}
		return x;  
	}
	
	public void setGunHeadingAbsolute(double x, double y){
		double dx = x - this.getX();
		double dy = y - this.getY();
		double theta = Math.toDegrees(Math.atan2(dx,dy));
		turnGunRight(normalRelativeAngle(theta - getGunHeading()));
	}

	public void setRadarHeadingAbsolute(double x, double y){
		double dx = x - this.getX();
		double dy = y - this.getY();
		double theta = Math.toDegrees(Math.atan2(dx,dy));
		turnRadarRight(normalRelativeAngle(theta - getRadarHeading()));
	}

	public double normalRelativeAngle(double angle) {
		if (angle > -180 && angle <= 180)
			return angle;
		double fixedAngle = angle;
		while (fixedAngle <= -180)
			fixedAngle += 360;
		while (fixedAngle > 180)
			fixedAngle -= 360;
		return fixedAngle;
	}

	public void setGunHeadingRelative(double tujuan){
		turnGunRight(tujuan - getGunHeadingRelative());
	}
	
	public void setRadarHeadingRelative(double tujuan){
		turnRadarRight(tujuan - getRadarHeadingRelative());
	}

	public abstract void run();	
}
