package ags.rougedc.gun;

import ags.rougedc.waves.SelfWave;

public class BulletPowerSelector {
	private double a=0;
	private int b=0;
	private int c=0;
	
	public void waveEnd(SelfWave wave) {
		b++;
		
		if (wave.getHitRange().intersects(wave.targetedGF)) {
			final double maxEscapeAngle = wave.getMaxEscapeAngle();
			final double distance = wave.getStaticTarget().getLocation().distance(wave.getOrigin());
			final double halfWidth = Math.atan(18/distance);
			a += maxEscapeAngle/halfWidth;  // 1.0 / (halfWidth/maxEscapeAngle)
			c++;
		} else {
			System.out.println("MISS MISS MISS MISS MISS MISS! "+wave.targetedGF+" not in "+wave.getHitRange());
		}
		System.out.println("Hitrate:"+((double)c)/b);
	}
	
	public double getBestPower(double distance, double myEnergy, double enemyEnergy) {
		final boolean survivalist = false;
		final double halfWidth = Math.atan(18/distance);
		final double m = halfWidth*a/b;
		if (b<20)
			return 1.9;
		double bestPower=Double.NaN;
		double bestGain=Double.NEGATIVE_INFINITY;
		double bhit=0;
		for (double p=0.1; p<3.03125; p+=0.03125) {
			if (p>3) p = 3;
			final double hitrate = Math.min(1, m/Math.asin(8.0/(20-3*p)));
			final double unitGain;
			if (survivalist) {
				final double gain = ((p <= 1)?(7*p):(9*p-2))*hitrate-p;
				unitGain = gain/(10.0+2*p);
			} else {
				final double damage = ((p <= 1)?(4*p):(6*p-2))*hitrate;
				final double gain = ((p <= 1)?(7*p):(9*p-2))*hitrate-p;
				unitGain = ((gain+damage*.5)/2)/(10.0+2*p);
			}
			
			if (unitGain > bestGain) {
				bestGain = unitGain;
				bestPower = p;
				bhit = hitrate;
			}
		}
		
		System.out.println(bhit);
		
		return bestPower;
	}
}