package cx.micro;
import java.awt.geom.Point2D;
import java.util.ArrayList;

import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.DeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Smoke:use MicroWave to do pattern analyzer and random movement
 *--------------------version 0.5 2003.1.5--------------
 * 0.5:Can only fire 3 power because MicroWave,so may west much power.(codesize 737)
 *--------------------version 0.55 2003.1.5--------------               
 * 0.55:improved movement a little.(codesize 749)
 *--------------------version 0.60 2003.1.8--------------
 * 0.60:changed a movement.it does better.(codesize 748)
 *--------------------version 0.70 2003.1.25-------------
 * 0.70:changed a movement similar to the new verion of Cigaret. (codesize 742)
 *--------------------version 0.80 2003.2.3-------------
 * 0.80:Squeezed much(MicroWave squeezed too) so added some in aim. (codesize 749)
 *--------------------version 0.82 2003.2.5-------------
 * 0.82:Squeezed again,added a judge to aim prediction points only in battle feild.
 *      and can set one color now(but have not set).(codesize 740)
  *--------------------version 0.91 2003.7.12-------------
 * 0.91:Squeezed again,tweaked movement as experience from Spark.(codesize 742)
  *--------------------version 0.95 2003.9.12-------------
 * 0.95:Squeezed again,can fire different power bullet and can fight in different battle fileds now.(codesize 748)
  *--------------------version 0.96 2004.10.24-------------
 * 0.95:Squeezed again,then add a trick to HOT bot, tweaked a little.(codesize 748)
 *-------------------------------------------------------
 * future:Squeeze so that i can do more and get my whole colors back.
 */
public class Smoke extends AdvancedRobot
{
	private static final double BATTLE_WIDTH  = 800;
	private static final double BATTLE_HEIGHT = 600;
	
	private static final double POWER = 3d;
	private static final double BULLET_VELOCITY = 20d - 3d*POWER;
	private static final double ESCPAE_ANGLE = 1.5;
	
	private static ArrayList waves = new ArrayList();
	private static double enemyEnergy;
	private static double HOT_Trick;

	private static Point2D.Double enemyPosition;
	
	public void run( ) {
		
		setAdjustGunForRobotTurn(true);
	    setAdjustRadarForGunTurn(true);
	    
		do{
			turnRadarRightRadians(1);	
		}
		while(true);
	} 
	
	/* (non-Javadoc)
	 * @see robocode.Robot#onDeath(robocode.DeathEvent)
	 */
	public void onDeath(DeathEvent event) {
			HOT_Trick = ESCPAE_ANGLE/2;
	}
    // -------------------- function for event handle ---------------
   	public void onScannedRobot( ScannedRobotEvent e ) {
		double absBearing;
		double edistance;
		double moveDistance;
		double moveAngle;
		Point2D.Double myPosition;
		enemyPosition=nextPoint(myPosition=new Point2D.Double(getX(),getY()),
			absBearing = e.getBearingRadians() + getHeadingRadians(),
            moveDistance = edistance = e.getDistance());
		// Radar turn grabed from David Alves.
		setTurnRadarRightRadians(Math.sin(absBearing - getRadarHeadingRadians()));

		//fire
        double power = Math.min(POWER, enemyEnergy/5d);
		if(getEnergy()>power)
			setFire(power);
		
		//--------------movement---------------------
        if(enemyEnergy!=(enemyEnergy=e.getEnergy()) && Math.abs(getDistanceRemaining())<53d){  
			Point2D.Double nextP;

			while(distanceToWall(nextP
					=nextPoint(enemyPosition,
							absBearing+(moveAngle=Math.random()*ESCPAE_ANGLE-HOT_Trick),
							-(moveDistance-=10d)/Math.cos(moveAngle)
							)
						)<24d);
            //thanks to David Alves and Dummy for this small code to find which direction is shortest to our next destination
			//Thanx DrLoco of this usage
			setAhead(
			 (
				( 
				moveAngle = Utils.normalRelativeAngle(
				                  getAngle( nextP,myPosition) - getHeadingRadians() 
				                  ) 
				) == ( moveDistance = Math.atan( Math.tan( moveAngle ) ) 
					) ? 1 : - 1 )	
			 * myPosition.distance(nextP) );	//move towards point
			setTurnRightRadians( moveDistance );
		}

		//-----------------pattern analyser--------------------
		int size;
        size=waves.size();

		MicroWave wave;
		waves.add(wave=new MicroWave());
		wave.absBearing=moveDistance=absBearing;
		wave.compareValue=new Point2D.Double(edistance/64d, e.getVelocity()*Math.sin(e.getHeadingRadians()-absBearing));
		wave.startPosition=myPosition;

		addCustomEvent(wave);
		if(getGunHeat()<0.4d){
        	for(int i=Math.max(71, size-4500); i<size; i++){
	    		if((wave=(MicroWave)waves.get(i)).startPosition.x<10){//is a succeded wave?
				    int j=0; 
					double div = 0;
					double comVal = 0;
					do{
						comVal+=((MicroWave)waves.get(size-j)).compareValue.distanceSq(((MicroWave)waves.get(i-j)).compareValue)/(div=div*2+1);
					}while((j+=7)<71);
		    	    if(comVal<=edistance          //edistance is matchValue now
						&& distanceToWall(nextPoint(//
						myPosition,moveAngle=absBearing+Math.asin(Math.sin(wave.startPosition.x)/(1.818182d-power*0.2727273d)),wave.startPosition.y))>17
					){
					    moveDistance=moveAngle;  //moveDistance is shoot bearing now
				    	edistance=comVal;
    				}
				}
	       }
        }
        //turn gun
        setTurnGunLeftRadians(Utils.normalRelativeAngle(getGunHeadingRadians()-moveDistance));
        
		scan();
    }
	public static Point2D.Double nextPoint(Point2D.Double originPoint,double angle,double distance){
		return new Point2D.Double(originPoint.x+Math.sin(angle)*distance,originPoint.y+Math.cos(angle)*distance);
	}

	public static double getAngle(Point2D.Double p2,Point2D.Double p1){
		return Math.atan2(p2.x-p1.x,p2.y-p1.y);
	}
	
	public static double distanceToWall(Point2D.Double p){
		return Math.min(Math.min(p.x, BATTLE_WIDTH-p.x),Math.min(p.y, BATTLE_HEIGHT-p.y));
	}
	
class MicroWave extends Condition
{
	//-------comparable varialbles
	Point2D.Double compareValue;   
	//-----------
	Point2D.Double startPosition;
	double absBearing;
	
   	double traveledDistance;
	//double realBullet;

	public boolean test(){
		traveledDistance += BULLET_VELOCITY;
		if(traveledDistance > enemyPosition.distance(startPosition)-18){  //is the wav hit enemy?
			startPosition=new Point2D.Double(getAngle(enemyPosition,startPosition)-absBearing, traveledDistance);
	    	removeCustomEvent(this);
		}
		return false;
	}
}

}

