package chase.s2.stat;
/**
 * @author Nat Pavasant
 */
public interface BinUpdater {
	public void update(float[] bin, double index, float weight);
	public void update(float[] bin, double lindex, double uindex, float weight);
	
	public class DefaultUpdater implements BinUpdater {
		public void update(float[] bin, double index, float weight) {
			update(bin, index, index, weight);
		}
		public void update(float[] bin, double lindex, double uindex, float weight) {
			double center = (lindex + uindex) / 2;
			for (int i = 0; i < bin.length; i++) {
				bin[i] += weight
						/ Math.pow(distanceOutside(uindex, lindex, i) * 1.3 + 0.2
								* Math.abs(i - center) + 1, 1.5);
			}
		}
		
		private double distanceOutside(double h, double l, double i) {
			if (i > h) return i-h;
			if (i < l) return l-i;
			return 0d;
		}
	}
	
	/**
	 * Decorater for BinUpdater
	 * @author Nat Pavasant
	 *
	 */
	public class RollingAverageUpdater implements BinUpdater {
		private final BinUpdater updater;
		private final float weight;
		private int count = 0;
		
		public RollingAverageUpdater(BinUpdater updater, float weight) {
			this.updater = updater;
			this.weight = weight;
		}
		

		public void update(float[] bin, double index, float weight) {
			float w = Math.min(count++, this.weight);
			float[] newbin = new float[bin.length];
			updater.update(newbin, index, weight);
			for (int i = 0; i < bin.length; i++) {
				bin[i] = (bin[i] * w + newbin[i]) / (w + 1f);
			}
		}
		
		public void update(float[] bin, double lindex, double uindex, float weight) {
			float w = Math.min(count++, this.weight);
			float[] newbin = new float[bin.length];
			updater.update(newbin, lindex, uindex, weight);
			for (int i = 0; i < bin.length; i++) {
				bin[i] = (bin[i] * w + newbin[i]) / (w + 1f);
			}
		}
	}
}
