package cx.mini;
import robocode.*;
import cx.utils.MeleeWave;
import java.util.Vector;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
/**
 *-----------------------------------------------------------------
 * @author:iiley (iiley@hotmail.com)
 * http://www.robochina.org
 * Enemy contain enemy's all infos
 */

public class Enemy
{
	public Vector waves=new Vector();
	public Point2D.Double pos;
	public double absBearing;
    public double energy;
	public double distance;
	public static double battleFieldWidth,battleFieldHeight;

	public void update(Point2D.Double myP,long time,double eb,double myh,double eh,
		double ev,double dist,double energy){
		pos=nextPoint(myP,
			absBearing=robocode.util.Utils.normalRelativeAngle(eb+myh),
            distance=dist);
		this.energy=energy;

        waves.add(new MeleeWave(
			myP,time,absBearing,distance,
			ev*Math.sin(eh-absBearing),
			pos.distance(battleFieldWidth/2d,battleFieldHeight/2d)/60d  //ev*Math.sin(eh-MeleeWave.getAngle(pos,new Point2D.Double(battleFieldWidth/2,battleFieldHeight/2)))
			));

		while(waves.size()>3000)	
			waves.remove(0);   //max size 3000
	}
    
	public void testWave(long time){
		int wavesSize=waves.size();
		//use 25,25*11*8>2200 > battleFiledWidth and battleFiledHeight and farest distance to enemy
		for(int i=wavesSize-2;i>=0 && i>wavesSize-25;i--)
			((MeleeWave)waves.elementAt(i)).test(pos,time);
	}
	public double getShootTurnAngle(Point2D.Double myP,double firePower){
		double comVal,comValD,dir,div,minComVal,hitAngle;
		minComVal=1000d;
		hitAngle=0;
		absBearing=MeleeWave.getAngle(pos,myP);
		int size=waves.size();
    	for(int i=10;i<size;i++){
	    		//double comVal;
    			MeleeWave wave;
	    		if((wave=(MeleeWave)waves.elementAt(i)).startP.x<10){//is a succeded wave
					div=comVal=comValD=0;
					dir=wave.startP.x;
					int j=0;
					do{
						comVal+=((MeleeWave)waves.elementAt(size-j-1)).getComVal((MeleeWave)waves.elementAt(i-j),1d)/(div=div*2+1);
						comValD+=((MeleeWave)waves.elementAt(size-j-1)).getComVal((MeleeWave)waves.elementAt(i-j),-1d)/(div);
					}while(j++ < 10);
					if(comValD<comVal){
						comVal=comValD;
						dir= -wave.startP.x;
					}
		    	    if(comVal<=minComVal 
						&& isInBattle(nextPoint(myP,absBearing+dir,wave.startP.y))
					){
					    hitAngle=dir;
				    	minComVal=comVal;
    				}
				}
	    }
		if(energy==0d) hitAngle=0d;
		//Math.asin(Math.sin(e.getHeadingRadians()-absBearing)*(11/(20-f*3)));
		return absBearing+Math.asin(Math.sin(hitAngle)/(1.818182d-firePower*0.2727273d));
	}
	public static boolean isInBattle(Point2D.Double p){
		return new Rectangle2D.Double(22,22,battleFieldWidth-44,battleFieldHeight-44).contains(p);
	}
	public static Point2D.Double nextPoint(Point2D.Double originPoint,double angle,double distance){
		return new Point2D.Double(originPoint.x+Math.sin(angle)*distance,originPoint.y+Math.cos(angle)*distance);
	}	
};
