package bvh.tyr;
import robocode.*;

public class KanonManager implements Constanten {

// variabelen voor kanon:
   static Tyr    mijnBot;
   static Doel   mijnDoel;
   double kanonDraaicircel = 0;
   double kanonVuurkracht  = 0.1;

   public KanonManager(Tyr bot, Doel doel) {
      mijnBot  = bot;
      mijnDoel = doel;
   }

/**********************************************************************
*  KANNON-STURING
**********************************************************************/
/**
* Vuurkracht afhankelijk van de doelafstand en de (voorspelde) hoek tussen kanon en doel
*
* v0.2 (28-08-2002)
*/
   public void stuurKannon() {
	   // alleen kanon sturen als er op iets te schieten valt 
	   // en raakkans redelijk groot is (d.w.z. doel dichtbij)
    if ( mijnBot.radar.getDoelGevonden() ) { 
      double doelHoek;
      double factor = 1D ;

      // vuurkracht baseren op eigen energie (overlevings bonus groter dan damage bonus):
      if (mijnBot.getEnergy() < 50) factor = mijnBot.getEnergy()/100D;
      kanonVuurkracht      = Math.min( Math.max( (standaardVuurkracht*factor), 0.1 ), 3.0);

      // bereken schade o.b.v. vuurkracht v.d. kogel:
      double schade        = 4D * kanonVuurkracht;
      if (kanonVuurkracht > 1) schade += 2 * (kanonVuurkracht-1);

      // vuurkracht aanpassen aan resterende energie van het doel:
      if (schade > mijnDoel.e) {
         if (mijnDoel.e <= 12 ) kanonVuurkracht = mijnDoel.e/4D + 0.1;
         else                   kanonVuurkracht = (mijnDoel.e+2D)/6D;
         kanonVuurkracht   = kanonVuurkracht + 0.1; // en beetje meer energie om doel te vernietigen...
      }
      double kogelSnelheid = 20 - 3 * kanonVuurkracht;

// indien verschil in bewegingsrichting doel groter dan vaste waarde,
      if (Math.abs(mijnDoel.vRot) < 0.005) {
         if (Math.abs(mijnDoel.afstand_o - mijnDoel.afstand) < 6) {
// direct op doel schieten (waarschijnlijk oscillatoriche beweging):
            doelHoek = mijnDoel.richting;
if (mijnBot.debugMode > 0) mijnBot.out.println("stuurKannon(): doelHoek (drct)= " + Math.toDegrees(doelHoek));
         } 
         else if (mijnDoel.v == 0 && mijnDoel.e !=0) { // stop-&-go bot ?
            doelHoek = lineaireBewegingsSchatter(mijnBot.getX(), mijnBot.getY(), mijnBot.getTime(), kogelSnelheid, true);
if (mijnBot.debugMode > 0) mijnBot.out.println("stuurKannon(): doelHoek (linV)= " + Math.toDegrees(doelHoek) +" (kogelSnelheid="+kogelSnelheid+")");
         }
         else { // voorspelling obv lineaire beweging:
//         long kogelVliegTijd = (long)(mijnDoel.afstand/(20 - 3 * kanonVuurkracht)) + (getTime() - mijnDoel.scanTijd) + 1;
            doelHoek = lineaireBewegingsSchatter(mijnBot.getX(), mijnBot.getY(), mijnBot.getTime(), kogelSnelheid, false);
if (mijnBot.debugMode > 0) mijnBot.out.println("stuurKannon(): doelHoek (linr)= " + Math.toDegrees(doelHoek) +" (kogelSnelheid="+kogelSnelheid+")");
         }

      }
      else { // dan voorspelling obv circelvormige beweging:
         doelHoek = circulaireBewegingsSchatter(mijnBot.getX(), mijnBot.getY(), mijnBot.getTime(), kogelSnelheid);
if (mijnBot.debugMode > 0) mijnBot.out.println("stuurKannon(): doelHoek (circ)= " + Math.toDegrees(doelHoek) +" (kogelSnelheid="+kogelSnelheid+")");
      }

      kanonDraaicircel = Utils.normaliseBearing( doelHoek - mijnBot.getGunHeadingRadians() );
if (mijnBot.debugMode > 0) mijnBot.out.println("stuurKannon(): kanon draaihoek= " + Math.toDegrees(kanonDraaicircel));
      mijnBot.setTurnGunRightRadians(kanonDraaicircel);
    } // einde controle op aanwezigheid doel
   }

/**
* Kanon wordt afgevuurd indien: 
*  - doel nog bekend is, 
*  - doel nabij is (raakkans relatief groot)
*  - kanon naar voorspelde positie van het doel wijst
*  - energie niet te laag 
*  - en kanon is afgekoeld.
*
* v0.1 (08-08-2002)
*/
   public void vuurKannon() {
      if (mijnBot.radar.getDoelGevonden() 
       && mijnDoel.afstand                        < 9D*naderingsAfstand // groot: ik richt goed !
       && mijnBot.getEnergy()                     > 3D
       && Math.abs(mijnBot.getGunTurnRemaining()) < 5D //degrees 
       && mijnBot.getGunHeat()                   == 0
         )  mijnBot.fire(kanonVuurkracht);
  }

/**********************************************************************
*  DOEL RICHTING SCHATTERS
**********************************************************************/
/**
* LineaireDoelRichtingVoorspelling: berekend de verwachte Doel bearing op tijd T+deltaT
*    o.b.v. snelheid kogel, (x,y)Robot, (x,y)Doel, Doel bearing, Doel heading
*    en de Robot heading
*    Directe berekening (zie aantekeningen).
*
* v0.1 (27-08-2002)
*/
   public double lineaireBewegingsSchatter(double xBot, double yBot, long tijd, double vKogel, boolean isGestopt) {
      int    t;
      double xSchat = 0;
      double ySchat = 0;
      double dSchat = mijnDoel.afstand;
      for (int i = 0; i < 4; i++){ // iteratie om afstand tot doel te schatten (geen wijziging
                                   // in resultaat na 4 iteraties (getest tegen spinbot)))
         t = (int)(Math.round(dSchat/vKogel) + (tijd - mijnDoel.scanTijd) + 1);
         if (isGestopt) {
            xSchat = mijnDoel.xtMean(t);
            ySchat = mijnDoel.ytMean(t);
         }
         else {
            xSchat = mijnDoel.xt(t);
            ySchat = mijnDoel.yt(t);
         }
         dSchat = Utils.bepaalAfstand(xSchat,ySchat,xBot,yBot);
      }
// nu nieuwe definitie van Utils.bepaalRichting waarbij dX, dY van plaats zijn gewisseld.
      return ( Utils.bepaalRichting( xSchat, ySchat, xBot, yBot ) );
   }

/**
* CirculaireDoelRichtingVoorspelling:
* (zie aantekeningen).
*
* v0.1 (28-08-2002)
*/
   public double circulaireBewegingsSchatter(double xBot, double yBot, long tijd, double vKogel) {
      int    t;
      double xSchat = mijnDoel.x;
      double ySchat = mijnDoel.y;
      double radius = mijnDoel.v / mijnDoel.vRot;
      double vRotTot;

      for (int i = 0; i < 4; i++){ // iteratie om afstand tot doel te schatten (geen wijziging
                                   // in resultaat na 4 iteraties (getest tegen spinbot)))
         t = (int)(Math.round((Utils.bepaalAfstand(xBot,yBot,xSchat,ySchat)/vKogel)) + (tijd - mijnDoel.scanTijd) + 1);
         vRotTot = t * mijnDoel.vRot;
         xSchat = mijnDoel.x + (Math.cos(mijnDoel.bewegingsrichting) * radius)
                             - (Math.cos(mijnDoel.bewegingsrichting + vRotTot) * radius);
         ySchat = mijnDoel.y + (Math.sin(mijnDoel.bewegingsrichting + vRotTot) * radius)
                             - (Math.sin(mijnDoel.bewegingsrichting) * radius);
      }

      return ( Utils.bepaalRichting( xSchat, ySchat, xBot, yBot ) );
   }

}
