/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.Enemy;
import com.spp.robocode.GuidanceComputer;
import com.spp.robocode.WaveBullet;
import java.util.ArrayList;
import java.util.List;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class Gunner {
    private Enemy currentTarget;
    private final AdvancedRobot robot;
    private final BattlefieldModel model;
    public static GuidanceComputer guidanceComputer = new GuidanceComputer();
    private double lastRobotHeading;
    private double lastRobotX;
    private double lastRobotY;
    List<WaveBullet> waves = new ArrayList<WaveBullet>();
    int direction = 1;

    Gunner(AdvancedRobot r, BattlefieldModel m) {
        this.robot = r;
        this.model = m;
        this.currentTarget = null;
        guidanceComputer.setModel(this.model, this.robot);
        this.lastRobotHeading = 0.0;
    }

    void chooseTarget() {
        int numEnemies = this.model.numEnemies();
        Enemy closest = this.model.getClosestEnemy();
        Enemy weakest = this.model.getWeakestEnemy();
        Enemy strongest = this.model.getStrongestEnemy();
        if (closest != null && closest.getDistance() < 300) {
            this.currentTarget = closest;
        } else if (weakest != null && weakest.getEnergy() < 15.0) {
            this.currentTarget = weakest;
        } else if (numEnemies < 5) {
            this.currentTarget = strongest;
        } else {
            double max = -1.0;
            for (Enemy e : this.model.getEnemies().values()) {
                double hitRate = guidanceComputer.getHitRate(e);
                if (!(hitRate > max)) continue;
                max = hitRate;
                this.currentTarget = e;
            }
            if (this.currentTarget == null) {
                this.currentTarget = strongest;
            }
        }
    }

    Enemy currentTarget() {
        return this.currentTarget;
    }

    boolean onScannedRobot(ScannedRobotEvent event) {
        guidanceComputer.onScannedRobot(event);
        boolean fired = false;
        if (this.currentTarget != null && this.model.getEnemy(this.currentTarget.getName(), false) == null) {
            this.currentTarget = null;
        }
        if (this.currentTarget != null && event.getName().equals(this.currentTarget.getName())) {
            double power = Gunner.GetPower(this.currentTarget.getDistance());
            double angleOffset = guidanceComputer.getFiringSolution(this.currentTarget, power, this.robot.getHeadingRadians(), this.robot.getX(), this.robot.getY());
            this.robot.setTurnGunRightRadians(angleOffset);
            if (this.robot.getGunHeat() == 0.0 && Math.abs(this.robot.getGunTurnRemaining()) < 1.0) {
                this.robot.setFireBullet(power);
                fired = true;
            }
        }
        this.lastRobotHeading = this.robot.getHeadingRadians();
        this.lastRobotX = this.robot.getX();
        this.lastRobotY = this.robot.getY();
        return fired;
    }

    public static double GetPower(double distance) {
        double power = 1.01;
        if (distance < 200.0) {
            power = 3.0;
        } else if (distance < 400.0) {
            power = 2.5;
        } else if (distance < 600.0) {
            power = 2.0;
        }
        return power;
    }

    void onRobotDeath(String name) {
        if (this.currentTarget != null && this.currentTarget.getName().equals(name)) {
            this.currentTarget = null;
        }
    }
}

