/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.recon;

import ags.muse.base.Rules;
import ags.muse.recon.Enemy;
import ags.muse.recon.SelfStatus;
import ags.util.points.AbsolutePoint;
import ags.util.points.RelativePoint;
import java.util.LinkedList;
import java.util.List;
import robocode.BulletHitEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

public class ExtendedEnemyInfo {
    private final Rules rules;
    private double accel = 0.0;
    private int orientation = 1;
    private double lateralVelocity;
    private double advancingVelocity;
    private double lateralAccel;
    private double advancingAccel;
    private int lateralOrientation = 1;
    private int velocityChangeTime = 0;
    private int latDirTime = 0;
    private double energyChange = 0.0;
    private double enemyPower = 0.0;
    private double lastEnemyPower = 1.9;
    private double lastlastEnemyPower = 1.9;
    private RelativePoint rel;
    private AbsolutePoint lastLocation;
    private final LinkedList<AbsolutePoint> locations;
    private double gunheat = Double.NaN;
    private long coolticks = 0L;
    private double damageTaken = 0.0;
    private long lastcoolticks = 0L;
    private static final double WALL_MARGIN = 18.0;

    public double getRecentEnemyPower() {
        if (Math.abs(this.lastEnemyPower - this.lastlastEnemyPower) >= 0.4) {
            return (this.lastEnemyPower + this.lastlastEnemyPower) / 2.0;
        }
        return this.lastEnemyPower;
    }

    public double getDamageTaken() {
        return this.damageTaken;
    }

    public double getLastEnemyPower() {
        return this.lastEnemyPower;
    }

    public double getGunheat() {
        return this.gunheat;
    }

    public long getCoolticks() {
        return this.coolticks;
    }

    public long getLastCoolticks() {
        return this.lastcoolticks;
    }

    public void firedBullet(double power, int ticksago) {
        this.gunheat = this.rules.getGunHeat(power) - (double)ticksago * this.rules.GUN_COOLING_RATE;
        this.lastcoolticks = this.coolticks - (long)ticksago;
        this.coolticks = 0L;
    }

    public ExtendedEnemyInfo(Rules rules) {
        this.rules = rules;
        this.locations = new LinkedList();
    }

    public void update(SelfStatus status, Enemy e, List<Event> events, AbsolutePoint oldLocation, RelativePoint oldVelocity, double oldEnergy) {
        if (oldVelocity == null) {
            this.gunheat = 3.0 >= (double)(status.t - 1) * this.rules.GUN_COOLING_RATE ? 3.0 - (double)(status.t - 1) * this.rules.GUN_COOLING_RATE : Double.NaN;
        }
        if (this.gunheat == 0.0) {
            ++this.coolticks;
        }
        this.gunheat = Math.max(0.0, this.gunheat - this.rules.GUN_COOLING_RATE);
        if (oldVelocity != null) {
            this.accel = e.getVelocity().magnitude - oldVelocity.magnitude;
        }
        if (e.getVelocity().magnitude > 0.0) {
            this.orientation = 1;
        } else if (e.getVelocity().magnitude < 0.0) {
            this.orientation = -1;
        }
        this.rel = RelativePoint.fromPP(status.getLocation(), e.getLocation());
        double oldLat = this.lateralVelocity;
        this.lateralVelocity = e.getVelocity().magnitude * Math.sin(e.getVelocity().direction - this.rel.direction);
        double oldAdv = this.advancingVelocity;
        this.advancingVelocity = e.getVelocity().magnitude * -Math.cos(e.getVelocity().getDirection() - this.rel.direction);
        if (oldVelocity != null) {
            this.lateralAccel = this.lateralVelocity - oldLat;
            this.advancingAccel = this.advancingVelocity - oldAdv;
        }
        int oldLatOri = this.lateralOrientation;
        if (this.lateralVelocity > 0.0) {
            this.lateralOrientation = 1;
        } else if (this.lateralVelocity < 0.0) {
            this.lateralOrientation = -1;
        }
        this.latDirTime = oldLatOri == this.lateralOrientation ? ++this.latDirTime : 0;
        this.velocityChangeTime = this.accel > -0.001 && this.accel < 0.001 ? ++this.velocityChangeTime : 0;
        this.locations.addFirst(e.getLocation());
        if (this.locations.size() > 30) {
            this.locations.removeLast();
        }
        this.energyChange = e.getEnergy() - oldEnergy;
        this.enemyPower = -this.energyChange;
        for (Event ev : events) {
            BulletHitEvent bh;
            if (ev instanceof BulletHitEvent) {
                bh = (BulletHitEvent)ev;
                if (!bh.getName().equals(e.name)) continue;
                this.enemyPower -= this.rules.getBulletDamage(bh.getBullet().getPower());
                this.damageTaken += this.rules.getBulletDamage(bh.getBullet().getPower());
            }
            if (!(ev instanceof HitByBulletEvent) || !(bh = (HitByBulletEvent)ev).getName().equals(e.name)) continue;
            this.enemyPower += this.rules.getHitRegneration(bh.getBullet().getPower());
        }
        if (this.enemyPower >= 3.01 || this.enemyPower <= 0.09) {
            this.enemyPower = 0.0;
        }
        if (this.gunheat != 0.0 && !Double.isNaN(this.gunheat)) {
            this.enemyPower = 0.0;
        }
        if (this.enemyPower != 0.0) {
            this.lastlastEnemyPower = this.enemyPower;
            this.lastEnemyPower = this.enemyPower;
        }
        this.lastLocation = oldLocation;
    }

    public double getAccel() {
        return this.accel;
    }

    public double getLateralAccel() {
        return this.lateralAccel;
    }

    public double getAdvancingAccel() {
        return this.advancingAccel;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getLateralVelocity() {
        return this.lateralVelocity;
    }

    public double getAdvancingVelocity() {
        return this.advancingVelocity;
    }

    public int getLateralOrientation() {
        return this.lateralOrientation;
    }

    public RelativePoint getRelativeLocation() {
        return this.rel;
    }

    public double getDistanceLastTicks(int ticks) {
        return this.locations.getFirst().distance(this.locations.get(Math.min(ticks, this.locations.size() - 1)));
    }

    public double getEnergyChange() {
        return this.energyChange;
    }

    public double getEnemyPower() {
        return this.enemyPower;
    }

    public AbsolutePoint getLastLocation() {
        return this.lastLocation;
    }

    public int getVelocityChangeTime() {
        return this.velocityChangeTime;
    }

    public int getLateralDirectionTime() {
        return this.latDirTime;
    }

    private double wallDistance(AbsolutePoint l, double eDist, double eAngle, int oDir) {
        double S = 18.0;
        double W = 18.0;
        double N = this.rules.BATTLEFIELD_HEIGHT - 18.0;
        double E = this.rules.BATTLEFIELD_WIDTH - 18.0;
        return Math.min(Math.min(Math.min(this.distanceWest(N - l.y, eDist, eAngle - 1.5707963267948966, oDir), this.distanceWest(E - l.x, eDist, eAngle + Math.PI, oDir)), this.distanceWest(l.y - 18.0, eDist, eAngle + 1.5707963267948966, oDir)), this.distanceWest(l.x - 18.0, eDist, eAngle, oDir));
    }

    private double distanceWest(double toWall, double eDist, double eAngle, int oDir) {
        if (eDist <= toWall) {
            return Double.POSITIVE_INFINITY;
        }
        double wallAngle = Math.acos((double)(-oDir) * toWall / eDist) + (double)oDir * Math.PI / 2.0;
        return Utils.normalAbsoluteAngle((double)((double)oDir * (wallAngle - eAngle)));
    }

    public double getWallSegment(int inv, AbsolutePoint source, double power) {
        double angle = this.wallDistance(source, this.rel.magnitude, this.rel.direction, inv * this.lateralOrientation);
        return angle / Math.asin(this.rules.MAX_VELOCITY / this.rules.getBulletSpeed(power));
    }
}

